/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.classfile;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.derby.iapi.services.io.AccessibleByteArrayOutputStream;

public final class ClassFormatOutput
extends DataOutputStream {
    public ClassFormatOutput() {
        this(512);
    }

    public ClassFormatOutput(int n2) {
        this(new AccessibleByteArrayOutputStream(n2));
    }

    public ClassFormatOutput(OutputStream outputStream) {
        super(outputStream);
    }

    public void putU1(int n2) throws IOException {
        if (n2 > 255) {
            ClassFormatOutput.limit("U1", 255, n2);
        }
        this.write(n2);
    }

    public void putU2(int n2) throws IOException {
        this.putU2("U2", n2);
    }

    public void putU2(String string, int n2) throws IOException {
        if (n2 > 65535) {
            ClassFormatOutput.limit(string, 65535, n2);
        }
        this.write(n2 >> 8);
        this.write(n2);
    }

    public void putU4(int n2) throws IOException {
        this.writeInt(n2);
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        ((AccessibleByteArrayOutputStream)this.out).writeTo(outputStream);
    }

    public byte[] getData() {
        return ((AccessibleByteArrayOutputStream)this.out).getInternalByteArray();
    }

    static void limit(String string, int n2, int n3) throws IOException {
        throw new IOException(string + "(" + n3 + " > " + n2 + ")");
    }
}

