/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.ArrayUtil;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;

public class IndexLister {
    private TableDescriptor tableDescriptor;
    private IndexRowGenerator[] indexRowGenerators;
    private long[] indexConglomerateNumbers;
    private String[] indexNames;
    private IndexRowGenerator[] distinctIndexRowGenerators;
    private long[] distinctIndexConglomerateNumbers;
    private String[] distinctIndexNames;

    public IndexLister(TableDescriptor tableDescriptor) {
        this.tableDescriptor = tableDescriptor;
    }

    public IndexRowGenerator[] getIndexRowGenerators() throws StandardException {
        if (this.indexRowGenerators == null) {
            this.getAllIndexes();
        }
        return ArrayUtil.copy(this.indexRowGenerators);
    }

    public long[] getIndexConglomerateNumbers() throws StandardException {
        if (this.indexConglomerateNumbers == null) {
            this.getAllIndexes();
        }
        return ArrayUtil.copy(this.indexConglomerateNumbers);
    }

    public IndexRowGenerator[] getDistinctIndexRowGenerators() throws StandardException {
        if (this.distinctIndexRowGenerators == null) {
            this.getAllIndexes();
        }
        return ArrayUtil.copy(this.distinctIndexRowGenerators);
    }

    public long[] getDistinctIndexConglomerateNumbers() throws StandardException {
        if (this.distinctIndexConglomerateNumbers == null) {
            this.getAllIndexes();
        }
        return ArrayUtil.copy(this.distinctIndexConglomerateNumbers);
    }

    public String[] getDistinctIndexNames() throws StandardException {
        if (this.distinctIndexNames == null) {
            this.getAllIndexes();
        }
        return ArrayUtil.copy(this.distinctIndexNames);
    }

    private void getAllIndexes() throws StandardException {
        int n2;
        int n3;
        int n4 = 0;
        ConglomerateDescriptor[] conglomerateDescriptorArray = this.tableDescriptor.getConglomerateDescriptors();
        long[] lArray = new long[conglomerateDescriptorArray.length - 1];
        int n5 = 0;
        int n6 = lArray.length - 1;
        for (n3 = 0; n3 < conglomerateDescriptorArray.length; ++n3) {
            ConglomerateDescriptor conglomerateDescriptor = conglomerateDescriptorArray[n3];
            if (!conglomerateDescriptor.isIndex()) continue;
            long l2 = conglomerateDescriptor.getConglomerateNumber();
            for (n2 = 0; n2 < n5; ++n2) {
                if (lArray[n2] != l2) continue;
                lArray[n6--] = n3;
                break;
            }
            if (n2 == n5) {
                lArray[n5++] = l2;
            }
            ++n4;
        }
        this.indexRowGenerators = new IndexRowGenerator[n4];
        this.indexConglomerateNumbers = new long[n4];
        this.indexNames = new String[n4];
        this.distinctIndexRowGenerators = new IndexRowGenerator[n5];
        this.distinctIndexConglomerateNumbers = new long[n5];
        this.distinctIndexNames = new String[n5];
        n3 = lArray.length - 1;
        n2 = -1;
        int n7 = -1;
        for (int i2 = 0; i2 < conglomerateDescriptorArray.length; ++i2) {
            ConglomerateDescriptor conglomerateDescriptor = conglomerateDescriptorArray[i2];
            if (!conglomerateDescriptor.isIndex()) continue;
            this.indexRowGenerators[++n2] = conglomerateDescriptor.getIndexDescriptor();
            this.indexConglomerateNumbers[n2] = conglomerateDescriptor.getConglomerateNumber();
            if (!conglomerateDescriptor.isConstraint()) {
                this.indexNames[n2] = conglomerateDescriptor.getConglomerateName();
            }
            if (n3 > n6 && i2 == (int)lArray[n3]) {
                --n3;
                continue;
            }
            this.distinctIndexRowGenerators[++n7] = this.indexRowGenerators[n2];
            this.distinctIndexConglomerateNumbers[n7] = this.indexConglomerateNumbers[n2];
            this.distinctIndexNames[n7] = this.indexNames[n2];
        }
    }
}

