/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.store.access.xa;

import java.util.Arrays;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.apache.derby.iapi.store.access.GlobalXact;
import org.apache.derby.iapi.util.StringUtil;

public class XAXactId
extends GlobalXact
implements Xid {
    private static final char COLON = ':';

    private void copy_init_xid(int n2, byte[] byArray, byte[] byArray2) {
        this.format_id = n2;
        this.global_id = (byte[])byArray.clone();
        this.branch_id = (byte[])byArray2.clone();
    }

    public XAXactId(int n2, byte[] byArray, byte[] byArray2) {
        this.copy_init_xid(n2, byArray, byArray2);
    }

    public XAXactId(Xid xid) throws XAException {
        if (xid == null) {
            throw new XAException(-4);
        }
        this.copy_init_xid(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier());
    }

    public String toHexString() {
        int n2 = 20 + (this.global_id.length + this.branch_id.length) * 2;
        StringBuffer stringBuffer = new StringBuffer(n2);
        stringBuffer.append(':').append(Integer.toString(this.global_id.length)).append(':').append(Integer.toString(this.branch_id.length)).append(':').append(Integer.toString(this.format_id, 16)).append(':').append(StringUtil.toHexString(this.global_id, 0, this.global_id.length)).append(':').append(StringUtil.toHexString(this.branch_id, 0, this.branch_id.length)).append(':');
        return stringBuffer.toString();
    }

    public XAXactId(String string) {
        int n2 = 1;
        int n3 = string.indexOf(58, n2);
        String string2 = string.substring(n2, n3);
        int n4 = Integer.parseInt(string2);
        n2 = n3 + 1;
        n3 = string.indexOf(58, n2);
        String string3 = string.substring(n2, n3);
        int n5 = Integer.parseInt(string3);
        n2 = n3 + 1;
        n3 = string.indexOf(58, n2);
        String string4 = string.substring(n2, n3);
        this.format_id = Integer.parseInt(string4, 16);
        n2 = n3 + 1;
        n3 = string.indexOf(58, n2);
        this.global_id = StringUtil.fromHexString(string, n2, n3 - n2);
        n2 = n3 + 1;
        n3 = string.indexOf(58, n2);
        this.branch_id = StringUtil.fromHexString(string, n2, n3 - n2);
    }

    @Override
    public int getFormatId() {
        return this.format_id;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return (byte[])this.global_id.clone();
    }

    @Override
    public byte[] getBranchQualifier() {
        return (byte[])this.branch_id.clone();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        try {
            if (object instanceof GlobalXact) {
                return super.equals(object);
            }
            Xid xid = (Xid)object;
            return Arrays.equals(xid.getGlobalTransactionId(), this.global_id) && Arrays.equals(xid.getBranchQualifier(), this.branch_id) && xid.getFormatId() == this.format_id;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }
}

