/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.types.BooleanDataValue;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.NumberDataType;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.iapi.types.SQLBoolean;

public final class SQLSmallint
extends NumberDataType {
    static final int SMALLINT_LENGTH = 2;
    private static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(SQLSmallint.class);
    private short value;
    private boolean isnull;

    @Override
    public int getInt() {
        return this.value;
    }

    @Override
    public byte getByte() throws StandardException {
        if (this.value > 127 || this.value < -128) {
            throw StandardException.newException("22003", "TINYINT");
        }
        return (byte)this.value;
    }

    @Override
    public short getShort() {
        return this.value;
    }

    @Override
    public long getLong() {
        return this.value;
    }

    @Override
    public float getFloat() {
        return this.value;
    }

    @Override
    public double getDouble() {
        return this.value;
    }

    @Override
    public boolean getBoolean() {
        return this.value != 0;
    }

    @Override
    public String getString() {
        if (this.isNull()) {
            return null;
        }
        return Short.toString(this.value);
    }

    @Override
    public int getLength() {
        return 2;
    }

    @Override
    public Object getObject() {
        if (this.isNull()) {
            return null;
        }
        return (int)this.value;
    }

    @Override
    public String getTypeName() {
        return "SMALLINT";
    }

    @Override
    public int getTypeFormatId() {
        return 83;
    }

    @Override
    public boolean isNull() {
        return this.isnull;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeShort(this.value);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        this.value = objectInput.readShort();
        this.isnull = false;
    }

    @Override
    public void restoreToNull() {
        this.value = 0;
        this.isnull = true;
    }

    @Override
    protected int typeCompare(DataValueDescriptor dataValueDescriptor) throws StandardException {
        int n2;
        int n3 = this.getInt();
        if (n3 == (n2 = dataValueDescriptor.getInt())) {
            return 0;
        }
        if (n3 > n2) {
            return 1;
        }
        return -1;
    }

    @Override
    public DataValueDescriptor cloneValue(boolean bl) {
        return new SQLSmallint(this.value, this.isnull);
    }

    @Override
    public DataValueDescriptor getNewNull() {
        return new SQLSmallint();
    }

    @Override
    public void setValueFromResultSet(ResultSet resultSet, int n2, boolean bl) throws SQLException {
        try {
            this.value = resultSet.getShort(n2);
            this.isnull = bl && resultSet.wasNull();
        }
        catch (SQLException sQLException) {
            int n3 = resultSet.getInt(n2);
            this.value = (short)n3;
            this.isnull = false;
        }
    }

    @Override
    public final void setInto(PreparedStatement preparedStatement, int n2) throws SQLException {
        if (this.isNull()) {
            preparedStatement.setNull(n2, 5);
            return;
        }
        preparedStatement.setShort(n2, this.value);
    }

    @Override
    public final void setInto(ResultSet resultSet, int n2) throws SQLException, StandardException {
        resultSet.updateShort(n2, this.value);
    }

    public SQLSmallint() {
        this.isnull = true;
    }

    public SQLSmallint(short s2) {
        this.value = s2;
    }

    private SQLSmallint(short s2, boolean bl) {
        this.value = s2;
        this.isnull = bl;
    }

    public SQLSmallint(Short s2) {
        this.isnull = s2 == null;
        if (!this.isnull) {
            this.value = s2;
        }
    }

    @Override
    public void setValue(String string) throws StandardException {
        if (string == null) {
            this.value = 0;
            this.isnull = true;
        } else {
            try {
                this.value = Short.valueOf(string.trim());
            }
            catch (NumberFormatException numberFormatException) {
                throw this.invalidFormat();
            }
            this.isnull = false;
        }
    }

    @Override
    public void setValue(short s2) {
        this.value = s2;
        this.isnull = false;
    }

    @Override
    public void setValue(byte by) {
        this.value = by;
        this.isnull = false;
    }

    @Override
    public void setValue(int n2) throws StandardException {
        if (n2 > Short.MAX_VALUE || n2 < Short.MIN_VALUE) {
            throw StandardException.newException("22003", "SMALLINT");
        }
        this.value = (short)n2;
        this.isnull = false;
    }

    @Override
    public void setValue(long l2) throws StandardException {
        if (l2 > 32767L || l2 < -32768L) {
            throw StandardException.newException("22003", "SMALLINT");
        }
        this.value = (short)l2;
        this.isnull = false;
    }

    @Override
    public void setValue(float f2) throws StandardException {
        if ((f2 = NumberDataType.normalizeREAL(f2)) > 32767.0f || f2 < -32768.0f) {
            throw StandardException.newException("22003", "SMALLINT");
        }
        float f3 = (float)Math.floor(f2);
        this.value = (short)f3;
        this.isnull = false;
    }

    @Override
    public void setValue(double d2) throws StandardException {
        if ((d2 = NumberDataType.normalizeDOUBLE(d2)) > 32767.0 || d2 < -32768.0) {
            throw StandardException.newException("22003", "SMALLINT");
        }
        double d3 = Math.floor(d2);
        this.value = (short)d3;
        this.isnull = false;
    }

    @Override
    public void setValue(boolean bl) {
        this.value = bl ? (short)1 : 0;
        this.isnull = false;
    }

    @Override
    protected void setFrom(DataValueDescriptor dataValueDescriptor) throws StandardException {
        this.setValue(dataValueDescriptor.getShort());
    }

    @Override
    public int typePrecedence() {
        return 40;
    }

    @Override
    public BooleanDataValue equals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.getShort() == dataValueDescriptor2.getShort());
    }

    @Override
    public BooleanDataValue notEquals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.getShort() != dataValueDescriptor2.getShort());
    }

    @Override
    public BooleanDataValue lessThan(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.getShort() < dataValueDescriptor2.getShort());
    }

    @Override
    public BooleanDataValue greaterThan(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.getShort() > dataValueDescriptor2.getShort());
    }

    @Override
    public BooleanDataValue lessOrEquals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.getShort() <= dataValueDescriptor2.getShort());
    }

    @Override
    public BooleanDataValue greaterOrEquals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.getShort() >= dataValueDescriptor2.getShort());
    }

    @Override
    public NumberDataValue times(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3) throws StandardException {
        if (numberDataValue3 == null) {
            numberDataValue3 = new SQLSmallint();
        }
        if (numberDataValue.isNull() || numberDataValue2.isNull()) {
            numberDataValue3.setToNull();
            return numberDataValue3;
        }
        int n2 = numberDataValue.getShort() * numberDataValue2.getShort();
        numberDataValue3.setValue(n2);
        return numberDataValue3;
    }

    @Override
    public NumberDataValue mod(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3) throws StandardException {
        if (numberDataValue3 == null) {
            numberDataValue3 = new SQLSmallint();
        }
        if (numberDataValue.isNull() || numberDataValue2.isNull()) {
            numberDataValue3.setToNull();
            return numberDataValue3;
        }
        short s2 = numberDataValue2.getShort();
        if (s2 == 0) {
            throw StandardException.newException("22012", new Object[0]);
        }
        numberDataValue3.setValue(numberDataValue.getShort() % s2);
        return numberDataValue3;
    }

    @Override
    public NumberDataValue minus(NumberDataValue numberDataValue) throws StandardException {
        if (numberDataValue == null) {
            numberDataValue = new SQLSmallint();
        }
        if (this.isNull()) {
            numberDataValue.setToNull();
            return numberDataValue;
        }
        short s2 = this.getShort();
        numberDataValue.setValue((int)(-s2));
        return numberDataValue;
    }

    @Override
    protected boolean isNegative() {
        return !this.isNull() && this.value < 0;
    }

    public String toString() {
        if (this.isNull()) {
            return "NULL";
        }
        return Short.toString(this.value);
    }

    public int hashCode() {
        return this.value;
    }

    @Override
    public int estimateMemoryUsage() {
        return BASE_MEMORY_USAGE;
    }
}

