/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.catalog.types.BaseTypeIdImpl;
import org.apache.derby.catalog.types.DecimalTypeIdImpl;
import org.apache.derby.catalog.types.TypeDescriptorImpl;
import org.apache.derby.catalog.types.UserDefinedTypeIdImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.SQLBit;
import org.apache.derby.iapi.types.SQLBlob;
import org.apache.derby.iapi.types.SQLBoolean;
import org.apache.derby.iapi.types.SQLChar;
import org.apache.derby.iapi.types.SQLClob;
import org.apache.derby.iapi.types.SQLDate;
import org.apache.derby.iapi.types.SQLDecimal;
import org.apache.derby.iapi.types.SQLDouble;
import org.apache.derby.iapi.types.SQLInteger;
import org.apache.derby.iapi.types.SQLLongVarbit;
import org.apache.derby.iapi.types.SQLLongint;
import org.apache.derby.iapi.types.SQLLongvarchar;
import org.apache.derby.iapi.types.SQLReal;
import org.apache.derby.iapi.types.SQLRef;
import org.apache.derby.iapi.types.SQLSmallint;
import org.apache.derby.iapi.types.SQLTime;
import org.apache.derby.iapi.types.SQLTimestamp;
import org.apache.derby.iapi.types.SQLTinyint;
import org.apache.derby.iapi.types.SQLVarbit;
import org.apache.derby.iapi.types.SQLVarchar;
import org.apache.derby.iapi.types.UserType;
import org.apache.derby.iapi.types.XML;

public final class TypeId {
    public static final int LONGINT_PRECISION = 19;
    public static final int LONGINT_SCALE = 0;
    public static final int LONGINT_MAXWIDTH = 8;
    public static final int INT_PRECISION = 10;
    public static final int INT_SCALE = 0;
    public static final int INT_MAXWIDTH = 4;
    public static final int SMALLINT_PRECISION = 5;
    public static final int SMALLINT_SCALE = 0;
    public static final int SMALLINT_MAXWIDTH = 2;
    public static final int TINYINT_PRECISION = 3;
    public static final int TINYINT_SCALE = 0;
    public static final int TINYINT_MAXWIDTH = 1;
    public static final int DOUBLE_PRECISION = 52;
    public static final int DOUBLE_PRECISION_IN_DIGITS = 15;
    public static final int DOUBLE_SCALE = 0;
    public static final int DOUBLE_MAXWIDTH = 8;
    public static final int REAL_PRECISION = 23;
    public static final int REAL_PRECISION_IN_DIGITS = 7;
    public static final int REAL_SCALE = 0;
    public static final int REAL_MAXWIDTH = 4;
    public static final int DECIMAL_PRECISION = 31;
    public static final int DECIMAL_SCALE = 31;
    public static final int DECIMAL_MAXWIDTH = 31;
    public static final int BOOLEAN_MAXWIDTH = 1;
    public static final int CHAR_MAXWIDTH = 254;
    public static final int VARCHAR_MAXWIDTH = 32672;
    public static final int LONGVARCHAR_MAXWIDTH = 32700;
    public static final int BIT_MAXWIDTH = 254;
    public static final int VARBIT_MAXWIDTH = 32672;
    public static final int LONGVARBIT_MAXWIDTH = 32700;
    public static final int BLOB_MAXWIDTH = Integer.MAX_VALUE;
    public static final int CLOB_MAXWIDTH = Integer.MAX_VALUE;
    public static final int XML_MAXWIDTH = Integer.MAX_VALUE;
    public static final int DATE_MAXWIDTH = 10;
    public static final int TIME_MAXWIDTH = 8;
    public static final int TIMESTAMP_MAXWIDTH = 29;
    public static final int TIME_SCALE = 0;
    public static final int TIMESTAMP_SCALE = 9;
    public static final String BIT_NAME = "CHAR () FOR BIT DATA";
    public static final String VARBIT_NAME = "VARCHAR () FOR BIT DATA";
    public static final String LONGVARBIT_NAME = "LONG VARCHAR FOR BIT DATA";
    public static final String TINYINT_NAME = "TINYINT";
    public static final String SMALLINT_NAME = "SMALLINT";
    public static final String INTEGER_NAME = "INTEGER";
    public static final String BIGINT_NAME = "BIGINT";
    public static final String FLOAT_NAME = "FLOAT";
    public static final String REAL_NAME = "REAL";
    public static final String DOUBLE_NAME = "DOUBLE";
    public static final String NUMERIC_NAME = "NUMERIC";
    public static final String DECIMAL_NAME = "DECIMAL";
    public static final String CHAR_NAME = "CHAR";
    public static final String VARCHAR_NAME = "VARCHAR";
    public static final String LONGVARCHAR_NAME = "LONG VARCHAR";
    public static final String DATE_NAME = "DATE";
    public static final String TIME_NAME = "TIME";
    public static final String TIMESTAMP_NAME = "TIMESTAMP";
    public static final String BINARY_NAME = "BINARY";
    public static final String VARBINARY_NAME = "VARBINARY";
    public static final String LONGVARBINARY_NAME = "LONGVARBINARY";
    public static final String BOOLEAN_NAME = "BOOLEAN";
    public static final String REF_NAME = "REF";
    public static final String REF_CURSOR = "REF CURSOR";
    public static final String NATIONAL_CHAR_NAME = "NATIONAL CHAR";
    public static final String NATIONAL_VARCHAR_NAME = "NATIONAL CHAR VARYING";
    public static final String NATIONAL_LONGVARCHAR_NAME = "LONG NVARCHAR";
    public static final String BLOB_NAME = "BLOB";
    public static final String CLOB_NAME = "CLOB";
    public static final String NCLOB_NAME = "NCLOB";
    public static final String XML_NAME = "XML";
    public static final String ARRAY_NAME = "ARRAY";
    public static final String STRUCT_NAME = "STRUCT";
    public static final String DATALINK_NAME = "DATALINK";
    public static final String ROWID_NAME = "ROWID";
    public static final String SQLXML_NAME = "SQLXML";
    public static final int USER_PRECEDENCE = 1000;
    public static final int XML_PRECEDENCE = 180;
    public static final int BLOB_PRECEDENCE = 170;
    public static final int LONGVARBIT_PRECEDENCE = 160;
    public static final int VARBIT_PRECEDENCE = 150;
    public static final int BIT_PRECEDENCE = 140;
    public static final int BOOLEAN_PRECEDENCE = 130;
    public static final int TIME_PRECEDENCE = 120;
    public static final int TIMESTAMP_PRECEDENCE = 110;
    public static final int DATE_PRECEDENCE = 100;
    public static final int DOUBLE_PRECEDENCE = 90;
    public static final int REAL_PRECEDENCE = 80;
    public static final int DECIMAL_PRECEDENCE = 70;
    public static final int NUMERIC_PRECEDENCE = 69;
    public static final int LONGINT_PRECEDENCE = 60;
    public static final int INT_PRECEDENCE = 50;
    public static final int SMALLINT_PRECEDENCE = 40;
    public static final int TINYINT_PRECEDENCE = 30;
    public static final int REF_PRECEDENCE = 25;
    public static final int CLOB_PRECEDENCE = 14;
    public static final int LONGVARCHAR_PRECEDENCE = 12;
    public static final int VARCHAR_PRECEDENCE = 10;
    public static final int CHAR_PRECEDENCE = 0;
    public static final TypeId BOOLEAN_ID = TypeId.create(4, 16);
    public static final TypeId SMALLINT_ID = TypeId.create(10, 22);
    public static final TypeId INTEGER_ID = TypeId.create(7, 19);
    public static final TypeId CHAR_ID = TypeId.create(5, 17);
    private static final TypeId TINYINT_ID = TypeId.create(195, 196);
    public static final TypeId BIGINT_ID = TypeId.create(11, 23);
    private static final TypeId REAL_ID = TypeId.create(8, 20);
    public static final TypeId DOUBLE_ID = TypeId.create(6, 18);
    private static final TypeId DECIMAL_ID = new TypeId(197, new DecimalTypeIdImpl(false));
    private static final TypeId NUMERIC_ID = new TypeId(197, new DecimalTypeIdImpl(true));
    private static final TypeId VARCHAR_ID = TypeId.create(13, 25);
    private static final TypeId DATE_ID = TypeId.create(40, 32);
    private static final TypeId TIME_ID = TypeId.create(35, 33);
    private static final TypeId TIMESTAMP_ID = TypeId.create(36, 34);
    private static final TypeId BIT_ID = TypeId.create(27, 28);
    private static final TypeId VARBIT_ID = TypeId.create(29, 30);
    private static final TypeId REF_ID = TypeId.create(9, 21);
    private static final TypeId LONGVARCHAR_ID = TypeId.create(230, 231);
    private static final TypeId LONGVARBIT_ID = TypeId.create(232, 233);
    private static final TypeId BLOB_ID = TypeId.create(440, 442);
    private static final TypeId CLOB_ID = TypeId.create(444, 446);
    private static final TypeId XML_ID = TypeId.create(456, 457);
    private static final TypeId[] ALL_BUILTIN_TYPE_IDS = new TypeId[]{BOOLEAN_ID, SMALLINT_ID, INTEGER_ID, CHAR_ID, TINYINT_ID, BIGINT_ID, REAL_ID, DOUBLE_ID, DECIMAL_ID, NUMERIC_ID, VARCHAR_ID, DATE_ID, TIME_ID, TIMESTAMP_ID, BIT_ID, VARBIT_ID, REF_ID, LONGVARCHAR_ID, LONGVARBIT_ID, BLOB_ID, CLOB_ID, XML_ID};
    private BaseTypeIdImpl baseTypeId;
    private int formatId;
    private boolean isBitTypeId;
    private boolean isLOBTypeId;
    private boolean isBooleanTypeId;
    private boolean isConcatableTypeId;
    private boolean isDecimalTypeId;
    private boolean isLongConcatableTypeId;
    private boolean isNumericTypeId;
    private boolean isRefTypeId;
    private boolean isStringTypeId;
    private boolean isFloatingPointTypeId;
    private boolean isRealTypeId;
    private boolean isDateTimeTimeStampTypeId;
    private boolean isUserDefinedTypeId;
    private int maxPrecision;
    private int maxScale;
    private int typePrecedence;
    private String javaTypeName;
    private int maxMaxWidth;

    private static TypeId create(int n2, int n3) {
        return new TypeId(n2, new BaseTypeIdImpl(n3));
    }

    public static TypeId[] getAllBuiltinTypeIds() {
        int n2 = ALL_BUILTIN_TYPE_IDS.length;
        TypeId[] typeIdArray = new TypeId[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            typeIdArray[i2] = ALL_BUILTIN_TYPE_IDS[i2];
        }
        return typeIdArray;
    }

    public static TypeId getBuiltInTypeId(int n2) {
        switch (n2) {
            case -6: {
                return TINYINT_ID;
            }
            case 5: {
                return SMALLINT_ID;
            }
            case 4: {
                return INTEGER_ID;
            }
            case -5: {
                return BIGINT_ID;
            }
            case 7: {
                return REAL_ID;
            }
            case 6: 
            case 8: {
                return DOUBLE_ID;
            }
            case 3: {
                return DECIMAL_ID;
            }
            case 2: {
                return NUMERIC_ID;
            }
            case 1: {
                return CHAR_ID;
            }
            case 12: {
                return VARCHAR_ID;
            }
            case 91: {
                return DATE_ID;
            }
            case 92: {
                return TIME_ID;
            }
            case 93: {
                return TIMESTAMP_ID;
            }
            case -7: 
            case 16: {
                return BOOLEAN_ID;
            }
            case -2: {
                return BIT_ID;
            }
            case -3: {
                return VARBIT_ID;
            }
            case -4: {
                return LONGVARBIT_ID;
            }
            case -1: {
                return LONGVARCHAR_ID;
            }
            case 2004: {
                return BLOB_ID;
            }
            case 2005: {
                return CLOB_ID;
            }
            case 2009: {
                return XML_ID;
            }
        }
        return null;
    }

    public static TypeId getUserDefinedTypeId(String string) throws StandardException {
        return new TypeId(267, new UserDefinedTypeIdImpl(string));
    }

    public static TypeId getUserDefinedTypeId(String string, String string2, String string3) throws StandardException {
        return new TypeId(267, new UserDefinedTypeIdImpl(string, string2, string3));
    }

    public static TypeId getSQLTypeForJavaType(String string) throws StandardException {
        if (string.equals("java.lang.Boolean") || string.equals("boolean")) {
            return BOOLEAN_ID;
        }
        if (string.equals("byte[]")) {
            return VARBIT_ID;
        }
        if (string.equals("java.lang.String")) {
            return VARCHAR_ID;
        }
        if (string.equals("java.lang.Integer") || string.equals("int")) {
            return INTEGER_ID;
        }
        if (string.equals("byte")) {
            return TINYINT_ID;
        }
        if (string.equals("short")) {
            return SMALLINT_ID;
        }
        if (string.equals("java.lang.Long") || string.equals("long")) {
            return BIGINT_ID;
        }
        if (string.equals("java.lang.Float") || string.equals("float")) {
            return REAL_ID;
        }
        if (string.equals("java.lang.Double") || string.equals("double")) {
            return DOUBLE_ID;
        }
        if (string.equals("java.math.BigDecimal")) {
            return DECIMAL_ID;
        }
        if (string.equals("java.sql.Date")) {
            return DATE_ID;
        }
        if (string.equals("java.sql.Time")) {
            return TIME_ID;
        }
        if (string.equals("java.sql.Timestamp")) {
            return TIMESTAMP_ID;
        }
        if (string.equals("java.sql.Blob")) {
            return BLOB_ID;
        }
        if (string.equals("java.sql.Clob")) {
            return CLOB_ID;
        }
        if (string.equals("org.apache.derby.iapi.types.XML")) {
            return XML_ID;
        }
        if (string.equals("char")) {
            return null;
        }
        return TypeId.getUserDefinedTypeId(string);
    }

    public static TypeId getBuiltInTypeId(String string) {
        if (string.equals(BOOLEAN_NAME)) {
            return BOOLEAN_ID;
        }
        if (string.equals(CHAR_NAME)) {
            return CHAR_ID;
        }
        if (string.equals(DATE_NAME)) {
            return DATE_ID;
        }
        if (string.equals(DOUBLE_NAME)) {
            return DOUBLE_ID;
        }
        if (string.equals(FLOAT_NAME)) {
            return DOUBLE_ID;
        }
        if (string.equals(INTEGER_NAME)) {
            return INTEGER_ID;
        }
        if (string.equals(BIGINT_NAME)) {
            return BIGINT_ID;
        }
        if (string.equals(REAL_NAME)) {
            return REAL_ID;
        }
        if (string.equals(SMALLINT_NAME)) {
            return SMALLINT_ID;
        }
        if (string.equals(TIME_NAME)) {
            return TIME_ID;
        }
        if (string.equals(TIMESTAMP_NAME)) {
            return TIMESTAMP_ID;
        }
        if (string.equals(VARCHAR_NAME)) {
            return VARCHAR_ID;
        }
        if (string.equals(BIT_NAME)) {
            return BIT_ID;
        }
        if (string.equals(VARBIT_NAME)) {
            return VARBIT_ID;
        }
        if (string.equals(TINYINT_NAME)) {
            return TINYINT_ID;
        }
        if (string.equals(DECIMAL_NAME)) {
            return DECIMAL_ID;
        }
        if (string.equals(NUMERIC_NAME)) {
            return NUMERIC_ID;
        }
        if (string.equals(LONGVARCHAR_NAME)) {
            return LONGVARCHAR_ID;
        }
        if (string.equals(LONGVARBIT_NAME)) {
            return LONGVARBIT_ID;
        }
        if (string.equals(BLOB_NAME)) {
            return BLOB_ID;
        }
        if (string.equals(CLOB_NAME)) {
            return CLOB_ID;
        }
        if (string.equals(XML_NAME)) {
            return XML_ID;
        }
        if (string.equals(REF_NAME)) {
            return REF_ID;
        }
        return null;
    }

    public static TypeId getTypeId(TypeDescriptor typeDescriptor) {
        TypeDescriptorImpl typeDescriptorImpl = (TypeDescriptorImpl)typeDescriptor;
        int n2 = typeDescriptor.getJDBCTypeId();
        TypeId typeId = TypeId.getBuiltInTypeId(n2);
        if (typeId != null) {
            return typeId;
        }
        if (n2 == 2000) {
            return new TypeId(267, typeDescriptorImpl.getTypeId());
        }
        if (typeDescriptorImpl.isRowMultiSet()) {
            return new TypeId(469, typeDescriptorImpl.getTypeId());
        }
        return null;
    }

    public TypeId(int n2, BaseTypeIdImpl baseTypeIdImpl) {
        this.formatId = n2;
        this.baseTypeId = baseTypeIdImpl;
        this.setTypeIdSpecificInstanceVariables();
    }

    public boolean equals(Object object) {
        if (object instanceof TypeId) {
            return this.getSQLTypeName().equals(((TypeId)object).getSQLTypeName());
        }
        return false;
    }

    public int hashCode() {
        return this.getSQLTypeName().hashCode();
    }

    private void setTypeIdSpecificInstanceVariables() {
        switch (this.formatId) {
            case 27: {
                this.typePrecedence = 140;
                this.javaTypeName = "byte[]";
                this.maxMaxWidth = 254;
                this.isBitTypeId = true;
                this.isConcatableTypeId = true;
                break;
            }
            case 4: {
                this.maxPrecision = 1;
                this.typePrecedence = 130;
                this.javaTypeName = "java.lang.Boolean";
                this.maxMaxWidth = 1;
                this.isBooleanTypeId = true;
                break;
            }
            case 5: {
                this.typePrecedence = 0;
                this.javaTypeName = "java.lang.String";
                this.maxMaxWidth = 254;
                this.isStringTypeId = true;
                this.isConcatableTypeId = true;
                break;
            }
            case 40: {
                this.typePrecedence = 100;
                this.javaTypeName = "java.sql.Date";
                this.maxMaxWidth = 10;
                this.maxPrecision = 10;
                this.isDateTimeTimeStampTypeId = true;
                break;
            }
            case 197: {
                this.maxPrecision = 31;
                this.maxScale = 31;
                this.typePrecedence = 70;
                this.javaTypeName = "java.math.BigDecimal";
                this.maxMaxWidth = 31;
                this.isDecimalTypeId = true;
                this.isNumericTypeId = true;
                break;
            }
            case 6: {
                this.maxPrecision = 52;
                this.maxScale = 0;
                this.typePrecedence = 90;
                this.javaTypeName = "java.lang.Double";
                this.maxMaxWidth = 8;
                this.isNumericTypeId = true;
                this.isFloatingPointTypeId = true;
                break;
            }
            case 7: {
                this.maxPrecision = 10;
                this.maxScale = 0;
                this.typePrecedence = 50;
                this.javaTypeName = "java.lang.Integer";
                this.maxMaxWidth = 4;
                this.isNumericTypeId = true;
                break;
            }
            case 11: {
                this.maxPrecision = 19;
                this.maxScale = 0;
                this.typePrecedence = 60;
                this.javaTypeName = "java.lang.Long";
                this.maxMaxWidth = 8;
                this.isNumericTypeId = true;
                break;
            }
            case 232: {
                this.typePrecedence = 160;
                this.javaTypeName = "byte[]";
                this.maxMaxWidth = 32700;
                this.isBitTypeId = true;
                this.isConcatableTypeId = true;
                this.isLongConcatableTypeId = true;
                break;
            }
            case 230: {
                this.typePrecedence = 12;
                this.javaTypeName = "java.lang.String";
                this.maxMaxWidth = 32700;
                this.isStringTypeId = true;
                this.isConcatableTypeId = true;
                this.isLongConcatableTypeId = true;
                break;
            }
            case 8: {
                this.maxPrecision = 23;
                this.maxScale = 0;
                this.typePrecedence = 80;
                this.javaTypeName = "java.lang.Float";
                this.maxMaxWidth = 4;
                this.isNumericTypeId = true;
                this.isRealTypeId = true;
                this.isFloatingPointTypeId = true;
                break;
            }
            case 9: {
                this.typePrecedence = 25;
                this.javaTypeName = "java.sql.Ref";
                this.isRefTypeId = true;
                break;
            }
            case 10: {
                this.maxPrecision = 5;
                this.maxScale = 0;
                this.typePrecedence = 40;
                this.javaTypeName = "java.lang.Integer";
                this.maxMaxWidth = 2;
                this.isNumericTypeId = true;
                break;
            }
            case 35: {
                this.typePrecedence = 120;
                this.javaTypeName = "java.sql.Time";
                this.maxScale = 0;
                this.maxMaxWidth = 8;
                this.maxPrecision = 8;
                this.isDateTimeTimeStampTypeId = true;
                break;
            }
            case 36: {
                this.typePrecedence = 110;
                this.javaTypeName = "java.sql.Timestamp";
                this.maxScale = 9;
                this.maxMaxWidth = 29;
                this.maxPrecision = 29;
                this.isDateTimeTimeStampTypeId = true;
                break;
            }
            case 195: {
                this.maxPrecision = 3;
                this.maxScale = 0;
                this.typePrecedence = 30;
                this.javaTypeName = "java.lang.Integer";
                this.maxMaxWidth = 1;
                this.isNumericTypeId = true;
                break;
            }
            case 267: {
                if (this.baseTypeId != null) {
                    this.setUserTypeIdInfo();
                } else {
                    this.typePrecedence = 1000;
                }
                this.maxMaxWidth = -1;
                this.isUserDefinedTypeId = true;
                break;
            }
            case 29: {
                this.typePrecedence = 150;
                this.javaTypeName = "byte[]";
                this.maxMaxWidth = 32672;
                this.isBitTypeId = true;
                this.isConcatableTypeId = true;
                break;
            }
            case 440: {
                this.typePrecedence = 170;
                this.javaTypeName = "java.sql.Blob";
                this.maxMaxWidth = Integer.MAX_VALUE;
                this.isBitTypeId = true;
                this.isConcatableTypeId = true;
                this.isLongConcatableTypeId = true;
                this.isLOBTypeId = true;
                break;
            }
            case 13: {
                this.typePrecedence = 10;
                this.javaTypeName = "java.lang.String";
                this.maxMaxWidth = 32672;
                this.isStringTypeId = true;
                this.isConcatableTypeId = true;
                break;
            }
            case 444: {
                this.typePrecedence = 14;
                this.javaTypeName = "java.sql.Clob";
                this.maxMaxWidth = Integer.MAX_VALUE;
                this.isStringTypeId = true;
                this.isConcatableTypeId = true;
                this.isLongConcatableTypeId = true;
                this.isLOBTypeId = true;
                break;
            }
            case 456: {
                this.typePrecedence = 180;
                this.javaTypeName = "org.apache.derby.iapi.types.XML";
                this.maxMaxWidth = Integer.MAX_VALUE;
                this.isLongConcatableTypeId = true;
            }
        }
    }

    public final int getJDBCTypeId() {
        return this.baseTypeId.getJDBCTypeId();
    }

    public String getSQLTypeName() {
        return this.baseTypeId.getSQLTypeName();
    }

    public final boolean userType() {
        return this.baseTypeId.userType();
    }

    public int getMaximumPrecision() {
        return this.maxPrecision;
    }

    public int getMaximumScale() {
        return this.maxScale;
    }

    private void setUserTypeIdInfo() {
        UserDefinedTypeIdImpl userDefinedTypeIdImpl = (UserDefinedTypeIdImpl)this.baseTypeId;
        this.typePrecedence = 1000;
        this.javaTypeName = userDefinedTypeIdImpl.getClassName();
    }

    public boolean isStringTypeId() {
        return this.isStringTypeId;
    }

    public boolean isDateTimeTimeStampTypeId() {
        return this.isDateTimeTimeStampTypeId;
    }

    public boolean isRealTypeId() {
        return this.isRealTypeId;
    }

    public boolean isFloatingPointTypeId() {
        return this.isFloatingPointTypeId;
    }

    public boolean isDoubleTypeId() {
        return this.isFloatingPointTypeId && !this.isRealTypeId;
    }

    public boolean isFixedStringTypeId() {
        return this.formatId == 5;
    }

    public boolean isClobTypeId() {
        return this.formatId == 444;
    }

    public boolean isBlobTypeId() {
        return this.formatId == 440;
    }

    public boolean isLongVarcharTypeId() {
        return this.formatId == 230;
    }

    public boolean isLongVarbinaryTypeId() {
        return this.formatId == 232;
    }

    public boolean isDateTimeTimeStampTypeID() {
        return this.formatId == 40 || this.formatId == 35 || this.formatId == 36;
    }

    public boolean isTimestampId() {
        return this.formatId == 36;
    }

    public boolean isXMLTypeId() {
        return this.formatId == 456;
    }

    public boolean orderable(ClassFactory classFactory) {
        switch (this.formatId) {
            case 230: 
            case 232: 
            case 440: 
            case 444: 
            case 456: {
                return false;
            }
            case 267: {
                return false;
            }
        }
        boolean bl = true;
        return bl;
    }

    public int typePrecedence() {
        return this.typePrecedence;
    }

    public String getCorrespondingJavaTypeName() {
        return this.javaTypeName;
    }

    public String getResultSetMetaDataTypeName() {
        if (BLOB_ID != null && BLOB_ID.equals(this)) {
            return "java.sql.Blob";
        }
        if (CLOB_ID != null && CLOB_ID.equals(this)) {
            return "java.sql.Clob";
        }
        return this.getCorrespondingJavaTypeName();
    }

    public int getMaximumMaximumWidth() {
        return this.maxMaxWidth;
    }

    public String toParsableString(DataTypeDescriptor dataTypeDescriptor) {
        return this.baseTypeId.toParsableString(dataTypeDescriptor.getCatalogType());
    }

    public boolean isNumericTypeId() {
        return this.isNumericTypeId;
    }

    public boolean isDecimalTypeId() {
        return this.isDecimalTypeId;
    }

    public boolean isBooleanTypeId() {
        return this.isBooleanTypeId;
    }

    public boolean isRefTypeId() {
        return this.isRefTypeId;
    }

    public boolean isConcatableTypeId() {
        return this.isConcatableTypeId;
    }

    public boolean isBitTypeId() {
        return this.isBitTypeId;
    }

    public boolean isLOBTypeId() {
        return this.isLOBTypeId;
    }

    public boolean isLongConcatableTypeId() {
        return this.isLongConcatableTypeId;
    }

    public boolean isUserDefinedTypeId() {
        return this.isUserDefinedTypeId;
    }

    public int getTypeFormatId() {
        return this.formatId;
    }

    public DataValueDescriptor getNull() {
        switch (this.formatId) {
            case 27: {
                return new SQLBit();
            }
            case 4: {
                return new SQLBoolean();
            }
            case 5: {
                return new SQLChar();
            }
            case 197: {
                return new SQLDecimal();
            }
            case 6: {
                return new SQLDouble();
            }
            case 7: {
                return new SQLInteger();
            }
            case 11: {
                return new SQLLongint();
            }
            case 232: {
                return new SQLLongVarbit();
            }
            case 440: {
                return new SQLBlob();
            }
            case 444: {
                return new SQLClob();
            }
            case 230: {
                return new SQLLongvarchar();
            }
            case 8: {
                return new SQLReal();
            }
            case 9: {
                return new SQLRef();
            }
            case 10: {
                return new SQLSmallint();
            }
            case 195: {
                return new SQLTinyint();
            }
            case 40: {
                return new SQLDate();
            }
            case 35: {
                return new SQLTime();
            }
            case 36: {
                return new SQLTimestamp();
            }
            case 267: {
                return new UserType();
            }
            case 29: {
                return new SQLVarbit();
            }
            case 13: {
                return new SQLVarchar();
            }
            case 456: {
                return new XML();
            }
        }
        return null;
    }

    public boolean streamStorable() {
        return this.isStringTypeId() || this.isBitTypeId();
    }

    public int getApproximateLengthInBytes(DataTypeDescriptor dataTypeDescriptor) {
        switch (this.formatId) {
            case 27: {
                return (int)Math.ceil((double)dataTypeDescriptor.getMaximumWidth() / 8.0);
            }
            case 5: {
                return 2 * dataTypeDescriptor.getMaximumWidth() + 2;
            }
            case 197: {
                if (dataTypeDescriptor.getPrecision() == Integer.MAX_VALUE) {
                    return 200;
                }
                return 8 + (int)Math.ceil((double)dataTypeDescriptor.getPrecision() / 2.0);
            }
            case 232: 
            case 440: 
            case 444: 
            case 456: {
                return 10240;
            }
            case 9: {
                return 16;
            }
            case 267: {
                return 200;
            }
            case 29: {
                if (dataTypeDescriptor.getMaximumWidth() == Integer.MAX_VALUE) {
                    return 200;
                }
                return (int)Math.ceil((double)dataTypeDescriptor.getMaximumWidth() / 8.0);
            }
            case 13: 
            case 230: {
                if (dataTypeDescriptor.getMaximumWidth() == Integer.MAX_VALUE) {
                    return 200;
                }
                return dataTypeDescriptor.getMaximumWidth() * 2 + 2;
            }
            case 40: {
                return 18;
            }
            case 35: {
                return 16;
            }
            case 36: {
                return 29;
            }
        }
        return dataTypeDescriptor.getMaximumWidth();
    }

    public BaseTypeIdImpl getBaseTypeId() {
        return this.baseTypeId;
    }

    public int getPrecision(DataTypeDescriptor dataTypeDescriptor, DataTypeDescriptor dataTypeDescriptor2) {
        long l2 = dataTypeDescriptor.getScale();
        long l3 = dataTypeDescriptor2.getScale();
        long l4 = dataTypeDescriptor.getPrecision();
        long l5 = dataTypeDescriptor2.getPrecision();
        long l6 = (long)this.getScale(dataTypeDescriptor, dataTypeDescriptor2) + Math.max(l4 - l2, l5 - l3);
        if (l6 > Integer.MAX_VALUE) {
            l6 = Integer.MAX_VALUE;
        }
        return (int)l6;
    }

    public int getScale(DataTypeDescriptor dataTypeDescriptor, DataTypeDescriptor dataTypeDescriptor2) {
        return Math.max(dataTypeDescriptor.getScale(), dataTypeDescriptor2.getScale());
    }

    public boolean variableLength() {
        switch (this.formatId) {
            case 5: 
            case 13: 
            case 27: 
            case 29: 
            case 197: 
            case 440: 
            case 444: {
                return true;
            }
        }
        return false;
    }
}

