/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.io.vfmem;

import java.io.InputStream;
import org.apache.derby.impl.io.vfmem.BlockedByteArray;

class BlockedByteArrayInputStream
extends InputStream {
    private BlockedByteArray src;
    private long pos;

    public BlockedByteArrayInputStream(BlockedByteArray blockedByteArray, long l2) {
        if (blockedByteArray == null) {
            throw new IllegalArgumentException("BlockedByteArray cannot be null");
        }
        this.src = blockedByteArray;
        this.pos = l2;
    }

    void setPosition(long l2) {
        this.pos = l2;
    }

    long getPosition() {
        return this.pos;
    }

    @Override
    public int read() {
        int n2 = this.src.read(this.pos);
        if (n2 != -1) {
            ++this.pos;
        }
        return n2;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        int n4 = this.src.read(this.pos, byArray, n2, n3);
        if (n4 != -1) {
            this.pos += (long)n4;
        }
        return n4;
    }

    @Override
    public void close() {
        this.src = null;
    }
}

