/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.info.JVMInfo;
import org.apache.derby.iapi.services.info.ProductVersionHolder;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SPSDescriptor;
import org.apache.derby.iapi.util.InterruptStatus;
import org.apache.derby.impl.jdbc.ConnectionChild;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.impl.sql.execute.GenericConstantActionFactory;

public class EmbedDatabaseMetaData
extends ConnectionChild
implements DatabaseMetaData,
PrivilegedAction<Object> {
    private static final int ILLEGAL_UDT_TYPE = 0;
    private final String url;
    private GenericConstantActionFactory constantActionFactory;
    private static Properties queryDescriptions;
    private static Properties queryDescriptions_net;

    public EmbedDatabaseMetaData(EmbedConnection embedConnection, String string) throws SQLException {
        super(embedConnection);
        this.url = string;
    }

    private Properties getQueryDescriptions(boolean bl) {
        Properties properties;
        Properties properties2 = properties = bl ? queryDescriptions_net : queryDescriptions;
        if (properties != null) {
            return properties;
        }
        this.loadQueryDescriptions();
        return bl ? queryDescriptions_net : queryDescriptions;
    }

    private void PBloadQueryDescriptions() {
        String[] stringArray = new String[]{"metadata.properties", "/org/apache/derby/impl/sql/catalog/metadata_net.properties"};
        Properties[] propertiesArray = new Properties[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            try {
                propertiesArray[i2] = new Properties();
                InputStream inputStream = this.getClass().getResourceAsStream(stringArray[i2]);
                propertiesArray[i2].load(inputStream);
                inputStream.close();
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        queryDescriptions = propertiesArray[0];
        queryDescriptions_net = propertiesArray[1];
    }

    @Override
    public boolean allProceduresAreCallable() {
        return true;
    }

    @Override
    public boolean allTablesAreSelectable() {
        return true;
    }

    @Override
    public final String getURL() {
        if (this.url == null) {
            return this.url;
        }
        int n2 = this.url.indexOf(59);
        if (n2 == -1) {
            return this.url;
        }
        return this.url.substring(0, n2);
    }

    @Override
    public String getUserName() {
        return this.getEmbedConnection().getTR().getUserName();
    }

    @Override
    public boolean isReadOnly() {
        return this.getLanguageConnectionContext().getDatabase().isReadOnly();
    }

    @Override
    public boolean nullsAreSortedHigh() {
        return true;
    }

    @Override
    public boolean nullsAreSortedLow() {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtStart() {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() {
        return false;
    }

    @Override
    public String getDatabaseProductName() {
        return EmbedConnection.getMonitor().getEngineVersion().getProductName();
    }

    @Override
    public String getDatabaseProductVersion() {
        ProductVersionHolder productVersionHolder = EmbedConnection.getMonitor().getEngineVersion();
        return productVersionHolder.getVersionBuildString(true);
    }

    @Override
    public String getDriverName() {
        return "Apache Derby Embedded JDBC Driver";
    }

    @Override
    public String getDriverVersion() {
        return this.getDatabaseProductVersion();
    }

    @Override
    public int getDriverMajorVersion() {
        return this.getEmbedConnection().getLocalDriver().getMajorVersion();
    }

    @Override
    public int getDriverMinorVersion() {
        return this.getEmbedConnection().getLocalDriver().getMinorVersion();
    }

    @Override
    public boolean usesLocalFiles() {
        return !this.url.contains("memory");
    }

    @Override
    public boolean usesLocalFilePerTable() {
        return !this.url.contains("memory");
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() {
        return true;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() {
        return true;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() {
        return true;
    }

    @Override
    public String getIdentifierQuoteString() {
        return "\"";
    }

    @Override
    public String getSQLKeywords() {
        return "ALIAS,BIGINT,BOOLEAN,CALL,CLASS,COPY,DB2J_DEBUG,EXECUTE,EXPLAIN,FILE,FILTER,GETCURRENTCONNECTION,INDEX,INSTANCEOF,METHOD,NEW,OFF,PROPERTIES,RECOMPILE,RENAME,RUNTIMESTATISTICS,STATEMENT,STATISTICS,TIMING,WAIT";
    }

    @Override
    public String getNumericFunctions() {
        return "ABS,ACOS,ASIN,ATAN,ATAN2,CEILING,COS,COT,DEGREES,EXP,FLOOR,LOG,LOG10,MOD,PI,RADIANS,RAND,SIGN,SIN,SQRT,TAN";
    }

    @Override
    public String getStringFunctions() {
        return "CONCAT,LENGTH,LCASE,LOCATE,LTRIM,RTRIM,SUBSTRING,UCASE";
    }

    @Override
    public String getSystemFunctions() {
        return "USER";
    }

    @Override
    public String getTimeDateFunctions() {
        return "CURDATE,CURTIME,HOUR,MINUTE,MONTH,SECOND,TIMESTAMPADD,TIMESTAMPDIFF,YEAR";
    }

    @Override
    public String getSearchStringEscape() {
        return "";
    }

    @Override
    public String getExtraNameCharacters() {
        return "";
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() {
        return true;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() {
        return true;
    }

    @Override
    public boolean supportsColumnAliasing() {
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() {
        return true;
    }

    @Override
    public boolean supportsConvert() {
        return false;
    }

    @Override
    public boolean supportsConvert(int n2, int n3) {
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() {
        return true;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() {
        return true;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() {
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() {
        return false;
    }

    @Override
    public boolean supportsGroupBy() {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() {
        return true;
    }

    @Override
    public boolean supportsLikeEscapeClause() {
        return true;
    }

    @Override
    public boolean supportsMultipleResultSets() {
        return true;
    }

    @Override
    public boolean supportsMultipleTransactions() {
        return true;
    }

    @Override
    public boolean supportsNonNullableColumns() {
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() {
        return true;
    }

    @Override
    public boolean supportsCoreSQLGrammar() {
        return false;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() {
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() {
        return true;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() {
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() {
        return false;
    }

    @Override
    public boolean supportsOuterJoins() {
        return true;
    }

    @Override
    public boolean supportsFullOuterJoins() {
        return false;
    }

    @Override
    public boolean supportsLimitedOuterJoins() {
        return true;
    }

    @Override
    public String getSchemaTerm() {
        return "SCHEMA";
    }

    @Override
    public String getProcedureTerm() {
        return "PROCEDURE";
    }

    @Override
    public String getCatalogTerm() {
        return "CATALOG";
    }

    @Override
    public boolean isCatalogAtStart() {
        return false;
    }

    @Override
    public String getCatalogSeparator() {
        return "";
    }

    @Override
    public boolean supportsSchemasInDataManipulation() {
        return true;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() {
        return true;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() {
        return true;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() {
        return true;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() {
        return true;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() {
        return false;
    }

    @Override
    public boolean supportsPositionedDelete() {
        return true;
    }

    @Override
    public boolean supportsPositionedUpdate() {
        return true;
    }

    @Override
    public boolean supportsRefCursors() {
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() {
        return true;
    }

    @Override
    public boolean supportsStoredProcedures() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() {
        return true;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() {
        return true;
    }

    @Override
    public boolean supportsUnion() {
        return true;
    }

    @Override
    public boolean supportsUnionAll() {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() {
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() {
        return false;
    }

    @Override
    public int getMaxBinaryLiteralLength() {
        return 0;
    }

    @Override
    public int getMaxCharLiteralLength() {
        return 0;
    }

    @Override
    public int getMaxColumnNameLength() {
        return 128;
    }

    @Override
    public int getMaxColumnsInGroupBy() {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() {
        return 0;
    }

    @Override
    public int getMaxColumnsInOrderBy() {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() {
        return 0;
    }

    @Override
    public int getMaxConnections() {
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() {
        return 128;
    }

    @Override
    public int getMaxIndexLength() {
        return 0;
    }

    @Override
    public long getMaxLogicalLobSize() {
        return 0L;
    }

    @Override
    public int getMaxSchemaNameLength() {
        return 128;
    }

    @Override
    public int getMaxProcedureNameLength() {
        return 128;
    }

    @Override
    public int getMaxCatalogNameLength() {
        return 0;
    }

    @Override
    public int getMaxRowSize() {
        return 0;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() {
        return true;
    }

    @Override
    public int getMaxStatementLength() {
        return 0;
    }

    @Override
    public int getMaxStatements() {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() {
        return 128;
    }

    @Override
    public int getMaxTablesInSelect() {
        return 0;
    }

    @Override
    public int getMaxUserNameLength() {
        return 128;
    }

    @Override
    public int getDefaultTransactionIsolation() {
        return 2;
    }

    @Override
    public boolean supportsTransactions() {
        return true;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int n2) {
        return n2 == 8 || n2 == 4 || n2 == 2 || n2 == 1;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() {
        return true;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() {
        return false;
    }

    @Override
    public ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        return this.doGetProcs(string, string2, string3, "getProcedures40");
    }

    public ResultSet getProceduresForODBC(String string, String string2, String string3) throws SQLException {
        return this.doGetProcs(string, string2, string3, "odbc_getProcedures");
    }

    @Override
    public ResultSet getFunctions(String string, String string2, String string3) throws SQLException {
        return this.doGetProcs(string, string2, string3, "getFunctions");
    }

    private ResultSet doGetProcs(String string, String string2, String string3, String string4) throws SQLException {
        PreparedStatement preparedStatement = this.getPreparedQuery(string4);
        preparedStatement.setString(1, EmbedDatabaseMetaData.swapNull(string));
        preparedStatement.setString(2, EmbedDatabaseMetaData.swapNull(string2));
        preparedStatement.setString(3, EmbedDatabaseMetaData.swapNull(string3));
        return preparedStatement.executeQuery();
    }

    @Override
    public ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        return this.doGetProcCols(string, string2, string3, string4, "getProcedureColumns40");
    }

    public ResultSet getProcedureColumnsForODBC(String string, String string2, String string3, String string4) throws SQLException {
        return this.doGetProcCols(string, string2, string3, string4, "odbc_getProcedureColumns");
    }

    @Override
    public ResultSet getFunctionColumns(String string, String string2, String string3, String string4) throws SQLException {
        return this.doGetProcCols(string, string2, string3, string4, "getFunctionColumns");
    }

    private ResultSet doGetProcCols(String string, String string2, String string3, String string4, String string5) throws SQLException {
        PreparedStatement preparedStatement = this.getPreparedQuery(string5);
        preparedStatement.setString(1, EmbedDatabaseMetaData.swapNull(string2));
        preparedStatement.setString(2, EmbedDatabaseMetaData.swapNull(string3));
        preparedStatement.setString(3, EmbedDatabaseMetaData.swapNull(string4));
        return preparedStatement.executeQuery();
    }

    @Override
    public ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        int n2;
        PreparedStatement preparedStatement = this.getPreparedQuery("getTables");
        preparedStatement.setString(1, EmbedDatabaseMetaData.swapNull(string));
        preparedStatement.setString(2, EmbedDatabaseMetaData.swapNull(string2));
        preparedStatement.setString(3, EmbedDatabaseMetaData.swapNull(string3));
        if (stringArray == null) {
            stringArray = new String[]{"TABLE", "VIEW", "SYNONYM", "SYSTEM TABLE"};
        }
        String[] stringArray2 = new String[4];
        for (n2 = 0; n2 < 4; ++n2) {
            stringArray2[n2] = null;
        }
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if ("TABLE".equals(stringArray[n2])) {
                stringArray2[0] = "T";
                continue;
            }
            if ("VIEW".equals(stringArray[n2])) {
                stringArray2[1] = "V";
                continue;
            }
            if ("SYNONYM".equals(stringArray[n2])) {
                stringArray2[2] = "A";
                continue;
            }
            if (!"SYSTEM TABLE".equals(stringArray[n2]) && !"SYSTEM_TABLE".equals(stringArray[n2])) continue;
            stringArray2[3] = "S";
        }
        for (n2 = 0; n2 < 4; ++n2) {
            if (stringArray2[n2] == null) {
                preparedStatement.setNull(n2 + 4, 1);
                continue;
            }
            preparedStatement.setString(n2 + 4, stringArray2[n2]);
        }
        return preparedStatement.executeQuery();
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        return this.getSchemas(null, null);
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        return this.getSimpleQuery("getCatalogs");
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        return this.getSimpleQuery("getTableTypes");
    }

    @Override
    public ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        return this.doGetCols(string, string2, string3, string4, "getColumns");
    }

    public ResultSet getColumnsForODBC(String string, String string2, String string3, String string4) throws SQLException {
        return this.doGetCols(string, string2, string3, string4, "odbc_getColumns");
    }

    private ResultSet doGetCols(String string, String string2, String string3, String string4, String string5) throws SQLException {
        PreparedStatement preparedStatement = this.getPreparedQuery(string5);
        preparedStatement.setString(1, EmbedDatabaseMetaData.swapNull(string));
        preparedStatement.setString(2, EmbedDatabaseMetaData.swapNull(string2));
        preparedStatement.setString(3, EmbedDatabaseMetaData.swapNull(string3));
        preparedStatement.setString(4, EmbedDatabaseMetaData.swapNull(string4));
        return preparedStatement.executeQuery();
    }

    @Override
    public ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        if (string3 == null) {
            throw Util.generateCsSQLException("XJ103.S", new Object[0]);
        }
        PreparedStatement preparedStatement = this.getPreparedQuery("getColumnPrivileges");
        preparedStatement.setString(1, EmbedDatabaseMetaData.swapNull(string));
        preparedStatement.setString(2, EmbedDatabaseMetaData.swapNull(string2));
        preparedStatement.setString(3, string3);
        preparedStatement.setString(4, EmbedDatabaseMetaData.swapNull(string4));
        return preparedStatement.executeQuery();
    }

    @Override
    public ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        PreparedStatement preparedStatement = this.getPreparedQuery("getTablePrivileges");
        preparedStatement.setString(1, EmbedDatabaseMetaData.swapNull(string));
        preparedStatement.setString(2, EmbedDatabaseMetaData.swapNull(string2));
        preparedStatement.setString(3, EmbedDatabaseMetaData.swapNull(string3));
        return preparedStatement.executeQuery();
    }

    @Override
    public ResultSet getBestRowIdentifier(String string, String string2, String string3, int n2, boolean bl) throws SQLException {
        return this.doGetBestRowId(string, string2, string3, n2, bl, "");
    }

    public ResultSet getBestRowIdentifierForODBC(String string, String string2, String string3, int n2, boolean bl) throws SQLException {
        return this.doGetBestRowId(string, string2, string3, n2, bl, "odbc_");
    }

    private ResultSet doGetBestRowId(String string, String string2, String string3, int n2, boolean bl, String string4) throws SQLException {
        if (string3 == null) {
            throw Util.generateCsSQLException("XJ103.S", new Object[0]);
        }
        int n3 = 0;
        if (bl) {
            n3 = 1;
        }
        if (string == null) {
            string = "%";
        }
        if (string2 == null) {
            string2 = "%";
        }
        if (n2 < 0 || n2 > 2) {
            throw EmbedDatabaseMetaData.newSQLException("42XAT", n2);
        }
        PreparedStatement preparedStatement = this.getPreparedQuery("getBestRowIdentifierPrimaryKey");
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string2);
        preparedStatement.setString(3, string3);
        ResultSet resultSet = preparedStatement.executeQuery();
        boolean bl2 = resultSet.next();
        String string5 = "";
        if (bl2) {
            string5 = resultSet.getString(1);
        }
        resultSet.close();
        preparedStatement.close();
        if (bl2) {
            preparedStatement = this.getPreparedQuery(string4 + "getBestRowIdentifierPrimaryKeyColumns");
            preparedStatement.setString(1, string5);
            preparedStatement.setString(2, string5);
            return preparedStatement.executeQuery();
        }
        preparedStatement = this.getPreparedQuery("getBestRowIdentifierUniqueConstraint");
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string2);
        preparedStatement.setString(3, string3);
        resultSet = preparedStatement.executeQuery();
        bl2 = resultSet.next();
        if (bl2) {
            string5 = resultSet.getString(1);
        }
        resultSet.close();
        preparedStatement.close();
        if (bl2) {
            preparedStatement = this.getPreparedQuery(string4 + "getBestRowIdentifierUniqueKeyColumns");
            preparedStatement.setString(1, string5);
            preparedStatement.setString(2, string5);
            preparedStatement.setInt(3, n3);
            return preparedStatement.executeQuery();
        }
        preparedStatement = this.getPreparedQuery("getBestRowIdentifierUniqueIndex");
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string2);
        preparedStatement.setString(3, string3);
        resultSet = preparedStatement.executeQuery();
        bl2 = resultSet.next();
        long l2 = 0L;
        if (bl2) {
            l2 = resultSet.getLong(1);
        }
        resultSet.close();
        preparedStatement.close();
        if (bl2) {
            preparedStatement = this.getPreparedQuery(string4 + "getBestRowIdentifierUniqueIndexColumns");
            preparedStatement.setLong(1, l2);
            preparedStatement.setInt(2, n3);
            return preparedStatement.executeQuery();
        }
        preparedStatement = this.getPreparedQuery(string4 + "getBestRowIdentifierAllColumns");
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string2);
        preparedStatement.setString(3, string3);
        preparedStatement.setInt(4, n2);
        preparedStatement.setInt(5, n3);
        return preparedStatement.executeQuery();
    }

    @Override
    public ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        return this.doGetVersionCols(string, string2, string3, "getVersionColumns");
    }

    public ResultSet getVersionColumnsForODBC(String string, String string2, String string3) throws SQLException {
        return this.doGetVersionCols(string, string2, string3, "odbc_getVersionColumns");
    }

    private ResultSet doGetVersionCols(String string, String string2, String string3, String string4) throws SQLException {
        if (string3 == null) {
            throw Util.generateCsSQLException("XJ103.S", new Object[0]);
        }
        PreparedStatement preparedStatement = this.getPreparedQuery(string4);
        preparedStatement.setString(1, EmbedDatabaseMetaData.swapNull(string));
        preparedStatement.setString(2, EmbedDatabaseMetaData.swapNull(string2));
        preparedStatement.setString(3, string3);
        return preparedStatement.executeQuery();
    }

    private boolean notInSoftUpgradeMode() throws SQLException {
        boolean bl;
        if (this.getEmbedConnection().isClosed()) {
            throw Util.noCurrentConnection();
        }
        LanguageConnectionContext languageConnectionContext = this.getLanguageConnectionContext();
        try {
            bl = languageConnectionContext.getDataDictionary().checkVersion(-1, null);
            InterruptStatus.restoreIntrFlagIfSeen();
        }
        catch (Throwable throwable) {
            throw this.handleException(throwable);
        }
        return bl;
    }

    @Override
    public ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        PreparedStatement preparedStatement = this.getPreparedQuery("getPrimaryKeys");
        if (string3 == null) {
            throw Util.generateCsSQLException("XJ103.S", new Object[0]);
        }
        preparedStatement.setString(1, EmbedDatabaseMetaData.swapNull(string));
        preparedStatement.setString(2, EmbedDatabaseMetaData.swapNull(string2));
        preparedStatement.setString(3, string3);
        return preparedStatement.executeQuery();
    }

    @Override
    public ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        if (string3 == null) {
            throw Util.generateCsSQLException("XJ103.S", new Object[0]);
        }
        PreparedStatement preparedStatement = this.getPreparedQuery("getImportedKeys");
        preparedStatement.setString(1, EmbedDatabaseMetaData.swapNull(string));
        preparedStatement.setString(2, EmbedDatabaseMetaData.swapNull(string2));
        preparedStatement.setString(3, string3);
        return preparedStatement.executeQuery();
    }

    @Override
    public ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        if (string3 == null) {
            throw Util.generateCsSQLException("XJ103.S", new Object[0]);
        }
        PreparedStatement preparedStatement = this.getPreparedQuery("getCrossReference");
        preparedStatement.setString(1, EmbedDatabaseMetaData.swapNull(string));
        preparedStatement.setString(2, EmbedDatabaseMetaData.swapNull(string2));
        preparedStatement.setString(3, string3);
        preparedStatement.setString(4, EmbedDatabaseMetaData.swapNull(null));
        preparedStatement.setString(5, EmbedDatabaseMetaData.swapNull(null));
        preparedStatement.setString(6, EmbedDatabaseMetaData.swapNull(null));
        return preparedStatement.executeQuery();
    }

    @Override
    public ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        if (string3 == null || string6 == null) {
            throw Util.generateCsSQLException("XJ103.S", new Object[0]);
        }
        PreparedStatement preparedStatement = this.getPreparedQuery("getCrossReference");
        preparedStatement.setString(1, EmbedDatabaseMetaData.swapNull(string));
        preparedStatement.setString(2, EmbedDatabaseMetaData.swapNull(string2));
        preparedStatement.setString(3, string3);
        preparedStatement.setString(4, EmbedDatabaseMetaData.swapNull(string4));
        preparedStatement.setString(5, EmbedDatabaseMetaData.swapNull(string5));
        preparedStatement.setString(6, string6);
        return preparedStatement.executeQuery();
    }

    public ResultSet getCrossReferenceForODBC(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        PreparedStatement preparedStatement = this.getPreparedQuery("odbc_getCrossReference");
        preparedStatement.setString(1, EmbedDatabaseMetaData.swapNull(string));
        preparedStatement.setString(2, EmbedDatabaseMetaData.swapNull(string2));
        preparedStatement.setString(3, EmbedDatabaseMetaData.swapNull(string3));
        preparedStatement.setString(4, EmbedDatabaseMetaData.swapNull(string4));
        preparedStatement.setString(5, EmbedDatabaseMetaData.swapNull(string5));
        preparedStatement.setString(6, EmbedDatabaseMetaData.swapNull(string6));
        return preparedStatement.executeQuery();
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        return this.getTypeInfoMinion("getTypeInfo");
    }

    public ResultSet getTypeInfoForODBC() throws SQLException {
        return this.getTypeInfoMinion("odbc_getTypeInfo");
    }

    private ResultSet getTypeInfoMinion(String string) throws SQLException {
        try {
            boolean bl = this.getLanguageConnectionContext().getDataDictionary().checkVersion(190, null);
            PreparedStatement preparedStatement = this.getPreparedQuery(string);
            preparedStatement.setBoolean(1, bl);
            return preparedStatement.executeQuery();
        }
        catch (StandardException standardException) {
            throw this.handleException(standardException);
        }
    }

    @Override
    public ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        return this.doGetIndexInfo(string, string2, string3, bl, bl2, "getIndexInfo");
    }

    public ResultSet getIndexInfoForODBC(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        return this.doGetIndexInfo(string, string2, string3, bl, bl2, "odbc_getIndexInfo");
    }

    private ResultSet doGetIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2, String string4) throws SQLException {
        if (string3 == null) {
            throw Util.generateCsSQLException("XJ103.S", new Object[0]);
        }
        int n2 = 0;
        if (bl2) {
            n2 = 1;
        }
        PreparedStatement preparedStatement = this.getPreparedQuery(string4);
        preparedStatement.setString(1, EmbedDatabaseMetaData.swapNull(string));
        preparedStatement.setString(2, EmbedDatabaseMetaData.swapNull(string2));
        preparedStatement.setString(3, string3);
        preparedStatement.setBoolean(4, bl);
        preparedStatement.setInt(5, n2);
        return preparedStatement.executeQuery();
    }

    @Override
    public boolean supportsResultSetType(int n2) {
        return n2 == 1003 || n2 == 1004;
    }

    @Override
    public boolean supportsResultSetConcurrency(int n2, int n3) {
        return n2 != 1005;
    }

    @Override
    public boolean ownUpdatesAreVisible(int n2) {
        return n2 == 1004;
    }

    @Override
    public boolean ownDeletesAreVisible(int n2) {
        return n2 == 1004;
    }

    @Override
    public boolean ownInsertsAreVisible(int n2) {
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int n2) {
        return n2 == 1003;
    }

    @Override
    public boolean othersDeletesAreVisible(int n2) {
        return n2 == 1003;
    }

    @Override
    public boolean othersInsertsAreVisible(int n2) {
        return n2 == 1003;
    }

    @Override
    public boolean updatesAreDetected(int n2) {
        return n2 == 1004;
    }

    @Override
    public boolean deletesAreDetected(int n2) {
        return n2 == 1004;
    }

    @Override
    public boolean insertsAreDetected(int n2) {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() {
        return true;
    }

    @Override
    public ResultSet getUDTs(String string, String string2, String string3, int[] nArray) throws SQLException {
        int n2 = 0;
        if (nArray == null) {
            n2 = 2000;
        } else if (nArray.length > 0) {
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                if (nArray[i2] != 2000) continue;
                n2 = 2000;
            }
        }
        PreparedStatement preparedStatement = this.getPreparedQuery("getUDTs");
        preparedStatement.setInt(1, 2000);
        preparedStatement.setString(2, EmbedDatabaseMetaData.swapNull(string));
        preparedStatement.setString(3, EmbedDatabaseMetaData.swapNull(string2));
        preparedStatement.setString(4, EmbedDatabaseMetaData.swapNull(string3));
        preparedStatement.setInt(5, n2);
        return preparedStatement.executeQuery();
    }

    @Override
    public Connection getConnection() {
        return this.getEmbedConnection().getApplicationConnection();
    }

    @Override
    public boolean supportsStatementPooling() {
        return false;
    }

    @Override
    public boolean supportsSavepoints() {
        return true;
    }

    @Override
    public boolean supportsNamedParameters() {
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() {
        return true;
    }

    @Override
    public boolean supportsGetGeneratedKeys() {
        return false;
    }

    @Override
    public boolean supportsResultSetHoldability(int n2) {
        return true;
    }

    @Override
    public int getResultSetHoldability() {
        return 1;
    }

    @Override
    public int getDatabaseMajorVersion() {
        ProductVersionHolder productVersionHolder = EmbedConnection.getMonitor().getEngineVersion();
        if (productVersionHolder == null) {
            return -1;
        }
        return productVersionHolder.getMajorVersion();
    }

    @Override
    public int getDatabaseMinorVersion() {
        ProductVersionHolder productVersionHolder = EmbedConnection.getMonitor().getEngineVersion();
        if (productVersionHolder == null) {
            return -1;
        }
        return productVersionHolder.getMinorVersion();
    }

    @Override
    public int getJDBCMajorVersion() {
        return 4;
    }

    @Override
    public int getJDBCMinorVersion() {
        return JVMInfo.jdbcMinorVersion();
    }

    @Override
    public int getSQLStateType() {
        return 2;
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        return true;
    }

    @Override
    public ResultSet getSuperTypes(String string, String string2, String string3) throws SQLException {
        return this.getSimpleQuery("getSuperTypes");
    }

    @Override
    public ResultSet getSuperTables(String string, String string2, String string3) throws SQLException {
        return this.getSimpleQuery("getSuperTables");
    }

    @Override
    public ResultSet getAttributes(String string, String string2, String string3, String string4) throws SQLException {
        return this.getSimpleQuery("getAttributes");
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        return this.getSimpleQuery("getClientInfoProperties");
    }

    @Override
    public ResultSet getSchemas(String string, String string2) throws SQLException {
        PreparedStatement preparedStatement = this.getPreparedQuery("getSchemas");
        preparedStatement.setString(1, EmbedDatabaseMetaData.swapNull(string));
        preparedStatement.setString(2, EmbedDatabaseMetaData.swapNull(string2));
        return preparedStatement.executeQuery();
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        return RowIdLifetime.ROWID_UNSUPPORTED;
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        return true;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        return true;
    }

    @Override
    public final boolean isWrapperFor(Class<?> clazz) {
        return clazz.isInstance(this);
    }

    @Override
    public final <T> T unwrap(Class<T> clazz) throws SQLException {
        try {
            return clazz.cast(this);
        }
        catch (ClassCastException classCastException) {
            throw EmbedDatabaseMetaData.newSQLException("XJ128.S", clazz);
        }
    }

    @Override
    public boolean generatedKeyAlwaysReturned() {
        return true;
    }

    @Override
    public ResultSet getPseudoColumns(String string, String string2, String string3, String string4) throws SQLException {
        return this.getSimpleQuery("getPseudoColumns");
    }

    public ResultSet getClientCachedMetaData() throws SQLException {
        return this.getSimpleQuery("METADATA", true);
    }

    private ResultSet getSimpleQuery(String string, boolean bl) throws SQLException {
        PreparedStatement preparedStatement = this.getPreparedQuery(string, bl);
        if (preparedStatement == null) {
            return null;
        }
        return preparedStatement.executeQuery();
    }

    protected ResultSet getSimpleQuery(String string) throws SQLException {
        return this.getSimpleQuery(string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PreparedStatement getPreparedQueryUsingSystemTables(String string, boolean bl) throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack();
            PreparedStatement preparedStatement = null;
            try {
                String string2 = this.getQueryDescriptions(bl).getProperty(string);
                if (string2 == null) {
                    throw Util.notImplemented(string);
                }
                preparedStatement = this.prepareSPS(string, string2, bl);
                InterruptStatus.restoreIntrFlagIfSeen(this.getLanguageConnectionContext());
            }
            catch (Throwable throwable) {
                throw this.handleException(throwable);
            }
            finally {
                this.restoreContextStack();
            }
            return preparedStatement;
        }
    }

    private PreparedStatement getPreparedQuery(String string, boolean bl) throws SQLException {
        PreparedStatement preparedStatement;
        if (this.notInSoftUpgradeMode() && !this.isReadOnly()) {
            preparedStatement = this.getPreparedQueryUsingSystemTables(string, bl);
        } else {
            try {
                String string2 = this.getQueryFromDescription(string, bl);
                preparedStatement = this.getEmbedConnection().prepareMetaDataStatement(string2);
            }
            catch (Throwable throwable) {
                throw this.handleException(throwable);
            }
        }
        return preparedStatement;
    }

    protected PreparedStatement getPreparedQuery(String string) throws SQLException {
        return this.getPreparedQuery(string, false);
    }

    private String getQueryFromDescription(String string, boolean bl) throws StandardException {
        DataDictionary dataDictionary = this.getLanguageConnectionContext().getDataDictionary();
        if (!dataDictionary.checkVersion(140, null)) {
            if (string.equals("getColumnPrivileges")) {
                string = "getColumnPrivileges_10_1";
            }
            if (string.equals("getTablePrivileges")) {
                string = "getTablePrivileges_10_1";
            }
        }
        return this.getQueryDescriptions(bl).getProperty(string);
    }

    private PreparedStatement prepareSPS(String string, String string2, boolean bl) throws StandardException, SQLException {
        LanguageConnectionContext languageConnectionContext = this.getLanguageConnectionContext();
        languageConnectionContext.beginNestedTransaction(true);
        DataDictionary dataDictionary = this.getLanguageConnectionContext().getDataDictionary();
        SPSDescriptor sPSDescriptor = dataDictionary.getSPSDescriptor(string, bl ? dataDictionary.getSysIBMSchemaDescriptor() : dataDictionary.getSystemSchemaDescriptor());
        languageConnectionContext.commitNestedTransaction();
        if (sPSDescriptor == null) {
            throw Util.notImplemented(string);
        }
        String string3 = "EXECUTE STATEMENT " + (bl ? "SYSIBM" : "SYS") + ".\"" + string + "\"";
        return this.getEmbedConnection().prepareMetaDataStatement(string3);
    }

    protected static final String swapNull(String string) {
        return string == null ? "%" : string;
    }

    private LanguageConnectionContext getLanguageConnectionContext() {
        return AccessController.doPrivileged(new PrivilegedAction<LanguageConnectionContext>(){

            @Override
            public LanguageConnectionContext run() {
                return EmbedDatabaseMetaData.this.getEmbedConnection().getLanguageConnection();
            }
        });
    }

    private void loadQueryDescriptions() {
        AccessController.doPrivileged(this);
    }

    @Override
    public final Object run() {
        this.PBloadQueryDescriptions();
        return null;
    }
}

