/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.io.StorageFile;
import org.apache.derby.io.StorageRandomAccessFile;

class LOBFile {
    private final StorageFile storageFile;
    private final StorageRandomAccessFile randomAccessFile;

    LOBFile(StorageFile storageFile) throws FileNotFoundException {
        this.storageFile = storageFile;
        this.randomAccessFile = storageFile.getRandomAccessFile("rw");
    }

    StorageFile getStorageFile() {
        return this.storageFile;
    }

    long length() throws IOException {
        return this.randomAccessFile.length();
    }

    void seek(long l2) throws IOException {
        this.randomAccessFile.seek(l2);
    }

    void write(int n2) throws IOException, StandardException {
        this.randomAccessFile.write(n2);
    }

    long getFilePointer() throws IOException {
        return this.randomAccessFile.getFilePointer();
    }

    void write(byte[] byArray, int n2, int n3) throws IOException, StandardException {
        this.randomAccessFile.write(byArray, n2, n3);
    }

    int readByte() throws IOException, StandardException {
        return this.randomAccessFile.readByte();
    }

    int read(byte[] byArray, int n2, int n3) throws IOException, StandardException {
        return this.randomAccessFile.read(byArray, n2, n3);
    }

    void close() throws IOException {
        this.randomAccessFile.close();
    }

    void setLength(long l2) throws IOException, StandardException {
        this.randomAccessFile.setLength(l2);
    }

    void write(byte[] byArray) throws IOException, StandardException {
        this.randomAccessFile.write(byArray);
    }
}

