/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.SQLException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.CharacterStreamDescriptor;
import org.apache.derby.iapi.util.UTF8Util;
import org.apache.derby.impl.jdbc.ClobUtf8Writer;
import org.apache.derby.impl.jdbc.ConnectionChild;
import org.apache.derby.impl.jdbc.InternalClob;
import org.apache.derby.impl.jdbc.LOBStreamControl;
import org.apache.derby.impl.jdbc.UTF8Reader;
import org.apache.derby.impl.jdbc.Util;

final class TemporaryClob
implements InternalClob {
    private ConnectionChild conChild;
    private final LOBStreamControl bytes;
    private boolean released = false;
    private long cachedCharLength;
    private UTF8Reader internalReader;
    private FilterReader unclosableInternalReader;
    private final CharToBytePositionCache posCache = new CharToBytePositionCache();

    static InternalClob cloneClobContent(String string, ConnectionChild connectionChild, InternalClob internalClob) throws IOException, SQLException {
        TemporaryClob temporaryClob = new TemporaryClob(connectionChild);
        temporaryClob.copyClobContent(internalClob);
        return temporaryClob;
    }

    static InternalClob cloneClobContent(String string, ConnectionChild connectionChild, InternalClob internalClob, long l2) throws IOException, SQLException {
        TemporaryClob temporaryClob = new TemporaryClob(connectionChild);
        temporaryClob.copyClobContent(internalClob, l2);
        return temporaryClob;
    }

    TemporaryClob(ConnectionChild connectionChild) {
        if (connectionChild == null) {
            throw new NullPointerException("conChild cannot be <null>");
        }
        this.conChild = connectionChild;
        this.bytes = new LOBStreamControl(connectionChild.getEmbedConnection());
    }

    @Override
    public synchronized void release() throws IOException {
        if (!this.released) {
            this.released = true;
            this.bytes.free();
            if (this.internalReader != null) {
                this.internalReader.close();
                this.internalReader = null;
                this.unclosableInternalReader = null;
            }
        }
    }

    @Override
    public synchronized InputStream getRawByteStream() throws IOException {
        this.checkIfValid();
        return this.bytes.getInputStream(0L);
    }

    TemporaryClob(String string, ConnectionChild connectionChild) throws IOException, StandardException {
        if (connectionChild == null) {
            throw new NullPointerException("conChild cannot be <null>");
        }
        this.conChild = connectionChild;
        this.bytes = new LOBStreamControl(connectionChild.getEmbedConnection(), this.getByteFromString(string));
        this.cachedCharLength = string.length();
    }

    private long getBytePosition(long l2) throws IOException {
        long l3;
        if (l2 == this.posCache.getCharPos()) {
            l3 = this.posCache.getBytePos();
        } else {
            long l4 = 0L;
            long l5 = l2 - 1L;
            if (l2 > this.posCache.getCharPos()) {
                l4 = this.posCache.getBytePos();
                l5 -= this.posCache.getCharPos() - 1L;
            }
            InputStream inputStream = this.bytes.getInputStream(l4);
            l3 = l4 + UTF8Util.skipFully(new BufferedInputStream(inputStream), l5);
            this.posCache.updateCachedPos(l2, l3);
        }
        return l3;
    }

    @Override
    public long getUpdateCount() {
        return this.bytes.getUpdateCount();
    }

    @Override
    public synchronized Writer getWriter(long l2) throws IOException, SQLException {
        this.checkIfValid();
        if (l2 < this.posCache.getCharPos()) {
            this.posCache.reset();
        }
        return new ClobUtf8Writer(this, l2);
    }

    @Override
    public synchronized Reader getReader(long l2) throws IOException, SQLException {
        long l3;
        this.checkIfValid();
        if (l2 < 1L) {
            throw new IllegalArgumentException("Position must be positive: " + l2);
        }
        UTF8Reader uTF8Reader = new UTF8Reader(this.getCSD(), this.conChild, this.conChild.getConnectionSynchronization());
        for (long i2 = l2 - 1L; i2 > 0L; i2 -= l3) {
            l3 = ((Reader)uTF8Reader).skip(i2);
            if (l3 > 0L) continue;
            throw new EOFException("Reached end-of-stream prematurely");
        }
        return uTF8Reader;
    }

    @Override
    public Reader getInternalReader(long l2) throws IOException, SQLException {
        if (this.internalReader == null) {
            this.internalReader = new UTF8Reader(this.getCSD(), this.conChild, this.conChild.getConnectionSynchronization());
            this.unclosableInternalReader = new FilterReader(this.internalReader){

                @Override
                public void close() {
                }
            };
        }
        try {
            this.internalReader.reposition(l2);
        }
        catch (StandardException standardException) {
            throw Util.generateCsSQLException(standardException);
        }
        return this.unclosableInternalReader;
    }

    @Override
    public synchronized long getCharLength() throws IOException {
        this.checkIfValid();
        if (this.cachedCharLength == 0L) {
            this.cachedCharLength = UTF8Util.skipUntilEOF(new BufferedInputStream(this.getRawByteStream()));
        }
        return this.cachedCharLength;
    }

    @Override
    public synchronized long getCharLengthIfKnown() {
        this.checkIfValid();
        return this.cachedCharLength == 0L ? -1L : this.cachedCharLength;
    }

    public synchronized long getByteLength() throws IOException {
        this.checkIfValid();
        return this.bytes.getLength();
    }

    @Override
    public synchronized long insertString(String string, long l2) throws IOException, SQLException {
        long l3;
        this.checkIfValid();
        if (l2 < 1L) {
            throw new IllegalArgumentException("Position must be positive: " + l2);
        }
        long l4 = this.cachedCharLength;
        this.updateInternalState(l2);
        long l5 = this.getBytePosition(l2);
        long l6 = this.bytes.getLength();
        byte[] byArray = this.getByteFromString(string);
        if (l5 == l6) {
            try {
                this.bytes.write(byArray, 0, byArray.length, l5);
            }
            catch (StandardException standardException) {
                throw Util.generateCsSQLException(standardException);
            }
        }
        try {
            l3 = this.getBytePosition(l2 + (long)string.length());
            this.posCache.updateCachedPos(l2, l5);
        }
        catch (EOFException eOFException) {
            l3 = l6;
        }
        try {
            this.bytes.replaceBytes(byArray, l5, l3);
        }
        catch (StandardException standardException) {
            throw Util.generateCsSQLException(standardException);
        }
        if (l4 != 0L) {
            long l7 = l2 - 1L + (long)string.length();
            this.cachedCharLength = l7 > l4 ? l7 : l4;
        }
        return string.length();
    }

    @Override
    public synchronized boolean isReleased() {
        return this.released;
    }

    @Override
    public boolean isWritable() {
        return true;
    }

    @Override
    public synchronized void truncate(long l2) throws IOException, SQLException {
        this.checkIfValid();
        try {
            long l3 = UTF8Util.skipFully(new BufferedInputStream(this.getRawByteStream()), l2);
            this.bytes.truncate(l3);
            this.updateInternalState(l2);
            this.cachedCharLength = l2;
        }
        catch (StandardException standardException) {
            throw Util.generateCsSQLException(standardException);
        }
    }

    private byte[] getByteFromString(String string) {
        byte[] byArray = new byte[3 * string.length()];
        int n2 = 0;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 >= '\u0001' && c2 <= '\u007f') {
                byArray[n2++] = (byte)c2;
                continue;
            }
            if (c2 > '\u07ff') {
                byArray[n2++] = (byte)(0xE0 | c2 >> 12 & 0xF);
                byArray[n2++] = (byte)(0x80 | c2 >> 6 & 0x3F);
                byArray[n2++] = (byte)(0x80 | c2 >> 0 & 0x3F);
                continue;
            }
            byArray[n2++] = (byte)(0xC0 | c2 >> 6 & 0x1F);
            byArray[n2++] = (byte)(0x80 | c2 >> 0 & 0x3F);
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        return byArray2;
    }

    private void copyClobContent(InternalClob internalClob) throws IOException, SQLException {
        try {
            long l2 = internalClob.getCharLengthIfKnown();
            if (l2 == -1L) {
                this.cachedCharLength = this.bytes.copyUtf8Data(internalClob.getRawByteStream(), Long.MAX_VALUE);
            } else {
                this.cachedCharLength = l2;
                this.bytes.copyData(internalClob.getRawByteStream(), Long.MAX_VALUE);
            }
        }
        catch (StandardException standardException) {
            throw Util.generateCsSQLException(standardException);
        }
    }

    private void copyClobContent(InternalClob internalClob, long l2) throws IOException, SQLException {
        block4: {
            try {
                long l3 = internalClob.getCharLengthIfKnown();
                if (l3 > l2 || l3 == -1L) {
                    this.cachedCharLength = this.bytes.copyUtf8Data(internalClob.getRawByteStream(), l2);
                    break block4;
                }
                if (l3 == l2) {
                    this.cachedCharLength = l3;
                    this.bytes.copyData(internalClob.getRawByteStream(), Long.MAX_VALUE);
                    break block4;
                }
                throw new EOFException();
            }
            catch (StandardException standardException) {
                throw Util.generateCsSQLException(standardException);
            }
        }
    }

    private final void checkIfValid() {
        if (this.released) {
            throw new IllegalStateException("The Clob has been released and is not valid");
        }
    }

    private final void updateInternalState(long l2) {
        if (this.internalReader != null) {
            this.internalReader.close();
            this.internalReader = null;
            this.unclosableInternalReader = null;
        }
        if (l2 < this.posCache.getCharPos()) {
            this.posCache.reset();
        }
        this.cachedCharLength = 0L;
    }

    private final CharacterStreamDescriptor getCSD() throws IOException {
        return new CharacterStreamDescriptor.Builder().positionAware(true).maxCharLength(Integer.MAX_VALUE).stream(this.bytes.getInputStream(0L)).bufferable(this.bytes.getLength() > 4096L).byteLength(this.bytes.getLength()).charLength(this.cachedCharLength).build();
    }

    private static class CharToBytePositionCache {
        private long charPos = 1L;
        private long bytePos = 0L;

        CharToBytePositionCache() {
        }

        long getBytePos() {
            return this.bytePos;
        }

        long getCharPos() {
            return this.charPos;
        }

        void updateCachedPos(long l2, long l3) {
            if (l2 - 1L > l3) {
                throw new IllegalArgumentException("(charPos -1) cannot be greater than bytePos; " + (l2 - 1L) + " > " + l3);
            }
            this.charPos = l2;
            this.bytePos = l3;
        }

        void reset() {
            this.charPos = 1L;
            this.bytePos = 0L;
        }
    }
}

