/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import org.apache.derby.iapi.services.io.InputStreamUtil;
import org.apache.derby.impl.jdbc.EmbedBlob;
import org.apache.derby.impl.jdbc.Util;

class UpdatableBlobStream
extends InputStream {
    private boolean materialized;
    private InputStream stream;
    private long pos;
    private final EmbedBlob blob;
    private final long maxPos;

    UpdatableBlobStream(EmbedBlob embedBlob, InputStream inputStream) throws IOException {
        this(embedBlob, inputStream, 0L, Long.MAX_VALUE);
    }

    UpdatableBlobStream(EmbedBlob embedBlob, InputStream inputStream, long l2, long l3) throws IOException {
        this.blob = embedBlob;
        this.stream = inputStream;
        this.maxPos = l2 + l3;
        if (l2 > 0L) {
            this.skip(l2);
        }
    }

    private void updateIfRequired() throws IOException {
        if (this.materialized) {
            return;
        }
        if (this.blob.isMaterialized()) {
            this.materialized = true;
            try {
                this.stream = this.blob.getBinaryStream();
            }
            catch (SQLException sQLException) {
                throw Util.newIOException(sQLException);
            }
            InputStreamUtil.skipFully(this.stream, this.pos);
        }
    }

    @Override
    public int read() throws IOException {
        this.updateIfRequired();
        if (this.pos >= this.maxPos) {
            return -1;
        }
        int n2 = this.stream.read();
        if (n2 >= 0) {
            ++this.pos;
        }
        return n2;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        this.updateIfRequired();
        long l2 = this.maxPos - this.pos;
        if (l2 == 0L && n3 > 0) {
            return -1;
        }
        int n4 = (int)Math.min((long)n3, l2);
        int n5 = this.stream.read(byArray, n2, n4);
        if (n5 > 0) {
            this.pos += (long)n5;
        }
        return n5;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public long skip(long l2) throws IOException {
        this.updateIfRequired();
        long l3 = this.stream.skip(l2);
        if (l3 > 0L) {
            this.pos += l3;
        }
        return l3;
    }
}

