/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.bytecode;

import org.apache.derby.impl.services.bytecode.BCJava;

class BCMethodDescriptor {
    static final String[] EMPTY = new String[0];
    private final String[] vmParameterTypes;
    private final String vmReturnType;
    private final String vmDescriptor;

    BCMethodDescriptor(String[] stringArray, String string, BCJava bCJava) {
        this.vmParameterTypes = stringArray;
        this.vmReturnType = string;
        this.vmDescriptor = bCJava.vmType(this);
    }

    static String get(String[] stringArray, String string, BCJava bCJava) {
        return new BCMethodDescriptor(stringArray, string, bCJava).toString();
    }

    String buildMethodDescriptor() {
        int n2 = this.vmParameterTypes.length;
        int n3 = 30 * (n2 + 1);
        StringBuffer stringBuffer = new StringBuffer(n3);
        stringBuffer.append('(');
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuffer.append(this.vmParameterTypes[i2]);
        }
        stringBuffer.append(')');
        stringBuffer.append(this.vmReturnType);
        return stringBuffer.toString();
    }

    public String toString() {
        return this.vmDescriptor;
    }

    public int hashCode() {
        return this.vmParameterTypes.length | this.vmReturnType.hashCode() & 0xFFFFFF00;
    }

    public boolean equals(Object object) {
        if (!(object instanceof BCMethodDescriptor)) {
            return false;
        }
        BCMethodDescriptor bCMethodDescriptor = (BCMethodDescriptor)object;
        if (bCMethodDescriptor.vmParameterTypes.length != this.vmParameterTypes.length) {
            return false;
        }
        for (int i2 = 0; i2 < this.vmParameterTypes.length; ++i2) {
            if (this.vmParameterTypes[i2].equals(bCMethodDescriptor.vmParameterTypes[i2])) continue;
            return false;
        }
        return this.vmReturnType.equals(bCMethodDescriptor.vmReturnType);
    }
}

