/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.bytecode;

import java.io.IOException;
import java.util.Arrays;
import org.apache.derby.iapi.services.classfile.CONSTANT_Index_info;
import org.apache.derby.iapi.services.classfile.CONSTANT_Utf8_info;
import org.apache.derby.iapi.services.classfile.ClassFormatOutput;
import org.apache.derby.iapi.services.classfile.ClassHolder;
import org.apache.derby.iapi.services.classfile.ClassMember;
import org.apache.derby.iapi.services.io.ArrayOutputStream;
import org.apache.derby.impl.services.bytecode.BCClass;
import org.apache.derby.impl.services.bytecode.BCMethod;

final class CodeChunk {
    private static final int CODE_OFFSET = 8;
    static final short[] LOAD_VARIABLE = new short[]{21, 21, 21, 22, 23, 24, 21, 25};
    static final short[] LOAD_VARIABLE_FAST = new short[]{26, 26, 26, 30, 34, 38, 26, 42};
    static final short[] STORE_VARIABLE = new short[]{54, 54, 54, 55, 56, 57, 54, 58};
    static final short[] STORE_VARIABLE_FAST = new short[]{59, 59, 59, 63, 67, 71, 59, 75};
    static final short[] ARRAY_ACCESS = new short[]{51, 53, 46, 47, 48, 49, 52, 50};
    static final short[] ARRAY_STORE = new short[]{84, 86, 79, 80, 81, 82, 85, 83};
    static final short[] RETURN_OPCODE = new short[]{172, 172, 172, 173, 174, 175, 172, 176};
    static final short[][][] CAST_CONVERSION_INFO = new short[][][]{new short[][]{{0, 0}, {0, 1}, {0, 2}, {0, 2}, {0, 2}, {0, 2}, {0, 6}, {-999, 7}}, new short[][]{{0, 0}, {0, 1}, {0, 2}, {0, 2}, {0, 2}, {0, 2}, {0, 6}, {-999, 7}}, new short[][]{{145, 0}, {147, 1}, {0, 2}, {133, 3}, {134, 4}, {135, 5}, {145, 6}, {-999, 7}}, new short[][]{{136, 2}, {136, 2}, {136, 2}, {0, 3}, {137, 4}, {138, 5}, {136, 2}, {-999, 7}}, new short[][]{{139, 2}, {139, 2}, {139, 2}, {140, 3}, {0, 4}, {141, 5}, {139, 2}, {-999, 7}}, new short[][]{{142, 2}, {142, 2}, {142, 2}, {143, 3}, {144, 4}, {0, 5}, {142, 2}, {-999, 7}}, new short[][]{{0, 0}, {0, 1}, {0, 2}, {0, 2}, {0, 2}, {0, 2}, {0, 6}, {-999, 7}}, new short[][]{{-999, 0}, {-999, 1}, {-999, 2}, {-999, 3}, {-999, 4}, {-999, 5}, {-999, 6}, {0, 7}}};
    private static final byte[] push1_1i = new byte[]{1, 1};
    private static final byte[] push2_1i = new byte[]{2, 1};
    private static final byte[] NS = new byte[]{0, -1};
    private static final byte VARIABLE_STACK = -128;
    private static final byte[][] OPCODE_ACTION = new byte[][]{{0, 1}, push1_1i, push1_1i, push1_1i, push1_1i, push1_1i, push1_1i, push1_1i, push1_1i, push2_1i, push2_1i, push1_1i, push1_1i, push1_1i, push2_1i, push2_1i, {1, 2}, {1, 3}, {1, 2}, {1, 3}, {2, 3}, {1, 2}, {2, 2}, {1, 2}, {2, 2}, {1, 2}, push1_1i, push1_1i, push1_1i, push1_1i, push2_1i, push2_1i, push2_1i, push2_1i, push1_1i, push1_1i, push1_1i, push1_1i, push2_1i, push2_1i, push2_1i, push2_1i, push1_1i, push1_1i, push1_1i, push1_1i, {-1, 1}, {0, 1}, {-1, 1}, {0, 1}, {-1, 1}, {-1, 1}, {-1, 1}, {-1, 1}, {-1, 2}, {-2, 2}, {-1, 2}, {-2, 2}, {-1, 2}, {-1, 1}, {-1, 1}, {-1, 1}, {-1, 1}, {-2, 1}, {-2, 1}, {-2, 1}, {-2, 1}, {-1, 1}, {-1, 1}, {-1, 1}, {-1, 1}, {-2, 1}, {-2, 1}, {-2, 1}, {-2, 1}, {-1, 1}, {-1, 1}, {-1, 1}, {-1, 1}, {-3, 1}, {-4, 1}, {-3, 1}, {-4, 1}, {-3, 1}, {-3, 1}, {-3, 1}, {-3, 1}, {-1, 1}, {-2, 1}, push1_1i, push1_1i, push1_1i, push2_1i, push2_1i, push2_1i, {0, 1}, NS, NS, {-1, 1}, {-2, 1}, NS, NS, {-1, 1}, {-2, 1}, NS, NS, {-1, 1}, {-2, 1}, NS, NS, {-1, 1}, {-2, 1}, {-1, 1}, {-2, 1}, {-1, 1}, {-2, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {-1, 1}, NS, NS, NS, NS, NS, {-1, 1}, NS, {-1, 1}, NS, NS, NS, NS, push1_1i, {0, 1}, push1_1i, {-1, 1}, {-1, 1}, {0, 1}, {0, 1}, push2_1i, push1_1i, {-1, 1}, {0, 1}, {-1, 1}, {0, 1}, {0, 1}, {0, 1}, NS, {-1, 1}, {-1, 1}, {-3, 1}, {-3, 1}, {-1, 3}, {-1, 3}, {-1, 3}, {-1, 3}, {-1, 3}, {-1, 3}, NS, NS, NS, NS, NS, NS, NS, NS, {0, 3}, NS, NS, NS, NS, {-1, 1}, {-2, 1}, {-1, 1}, {-2, 1}, {-1, 1}, {0, 1}, {-128, 3}, {-128, 3}, {-128, 3}, {-128, 3}, {-128, 3}, {-128, 3}, {-128, 3}, {-128, 5}, NS, {1, 3}, {0, 2}, {0, 3}, {0, 1}, NS, {0, 3}, {0, 3}, NS, NS, NS, NS, {-1, 3}, {-1, 3}, {0, 5}, NS, NS};
    private final int pcDelta;
    final BCClass cb;
    private final ClassFormatOutput cout;

    private void limitHit(IOException iOException) {
        this.cb.addLimitExceeded(iOException.toString());
    }

    void addInstr(short s2) {
        try {
            this.cout.putU1(s2);
        }
        catch (IOException iOException) {
            this.limitHit(iOException);
        }
    }

    void addInstrU2(short s2, int n2) {
        try {
            this.cout.putU1(s2);
            this.cout.putU2(n2);
        }
        catch (IOException iOException) {
            this.limitHit(iOException);
        }
    }

    void addInstrU4(short s2, int n2) {
        try {
            this.cout.putU1(s2);
            this.cout.putU4(n2);
        }
        catch (IOException iOException) {
            this.limitHit(iOException);
        }
    }

    void addInstrU1(short s2, int n2) {
        try {
            this.cout.putU1(s2);
            this.cout.putU1(n2);
        }
        catch (IOException iOException) {
            this.limitHit(iOException);
        }
    }

    void addInstrCPE(short s2, int n2) {
        if (n2 < 256) {
            this.addInstrU1(s2, n2);
        } else {
            this.addInstrU2((short)(s2 + 1), n2);
        }
    }

    void addInstrWide(short s2, int n2) {
        if (n2 < 256) {
            this.addInstrU1(s2, n2);
        } else {
            this.addInstr((short)196);
            this.addInstrU2(s2, n2);
        }
    }

    void addInstrU2U1U1(short s2, int n2, short s3, short s4) {
        try {
            this.cout.putU1(s2);
            this.cout.putU2(n2);
            this.cout.putU1(s3);
            this.cout.putU1(s4);
        }
        catch (IOException iOException) {
            this.limitHit(iOException);
        }
    }

    int getPC() {
        return this.cout.size() + this.pcDelta;
    }

    private static int instructionLength(short s2) {
        byte by = OPCODE_ACTION[s2][1];
        return by;
    }

    CodeChunk(BCClass bCClass) {
        this.cb = bCClass;
        this.cout = new ClassFormatOutput();
        try {
            this.cout.putU2(0);
            this.cout.putU2(0);
            this.cout.putU4(0);
        }
        catch (IOException iOException) {
            this.limitHit(iOException);
        }
        this.pcDelta = -8;
    }

    private CodeChunk(CodeChunk codeChunk, int n2, int n3) {
        this.cb = codeChunk.cb;
        ArrayOutputStream arrayOutputStream = new ArrayOutputStream(codeChunk.cout.getData());
        try {
            arrayOutputStream.setPosition(8 + n2);
            arrayOutputStream.setLimit(n3);
        }
        catch (IOException iOException) {
            this.limitHit(iOException);
        }
        this.cout = new ClassFormatOutput(arrayOutputStream);
        this.pcDelta = n2;
    }

    private void fixLengths(BCMethod bCMethod, int n2, int n3, int n4) {
        byte[] byArray = this.cout.getData();
        if (bCMethod != null && n2 > 65535) {
            this.cb.addLimitExceeded(bCMethod, "max_stack", 65535, n2);
        }
        byArray[0] = (byte)(n2 >> 8);
        byArray[1] = (byte)n2;
        if (bCMethod != null && n3 > 65535) {
            this.cb.addLimitExceeded(bCMethod, "max_locals", 65535, n3);
        }
        byArray[2] = (byte)(n3 >> 8);
        byArray[3] = (byte)n3;
        if (bCMethod != null && n4 > 65535) {
            this.cb.addLimitExceeded(bCMethod, "code_length", 65535, n4);
        }
        byArray[4] = (byte)(n4 >> 24);
        byArray[5] = (byte)(n4 >> 16);
        byArray[6] = (byte)(n4 >> 8);
        byArray[7] = (byte)n4;
    }

    void complete(BCMethod bCMethod, ClassHolder classHolder, ClassMember classMember, int n2, int n3) {
        int n4 = this.getPC();
        ClassFormatOutput classFormatOutput = this.cout;
        try {
            classFormatOutput.putU2(0);
            classFormatOutput.putU2(0);
        }
        catch (IOException iOException) {
            this.limitHit(iOException);
        }
        this.fixLengths(bCMethod, n2, n3, n4);
        classMember.addAttribute("Code", classFormatOutput);
    }

    short getOpcode(int n2) {
        return (short)(this.cout.getData()[8 + n2] & 0xFF);
    }

    private int getU2(int n2) {
        byte[] byArray = this.cout.getData();
        int n3 = 8 + n2 + 1;
        return (byArray[n3] & 0xFF) << 8 | byArray[n3 + 1] & 0xFF;
    }

    private int getU4(int n2) {
        byte[] byArray = this.cout.getData();
        int n3 = 8 + n2 + 1;
        return (byArray[n3] & 0xFF) << 24 | (byArray[n3 + 1] & 0xFF) << 16 | (byArray[n3 + 2] & 0xFF) << 8 | byArray[n3 + 3] & 0xFF;
    }

    CodeChunk insertCodeSpace(int n2, int n3) {
        short s2 = this.getOpcode(n2);
        int n4 = CodeChunk.instructionLength(s2);
        if (n3 > 0) {
            int n5 = this.getPC() - n2 - n4;
            for (int i2 = 0; i2 < n3; ++i2) {
                this.addInstr((short)0);
            }
            byte[] byArray = this.cout.getData();
            int n6 = 8 + n2 + n4;
            System.arraycopy(byArray, n6, byArray, n6 + n3, n5);
            Arrays.fill(byArray, n6, n6 + n3, (byte)0);
        }
        return new CodeChunk(this, n2, n3 += n4);
    }

    private int findMaxStack(ClassHolder classHolder, int n2, int n3) {
        int n4 = n2 + n3;
        int n5 = 0;
        int n6 = 0;
        while (n2 < n4) {
            int[] nArray;
            short s2 = this.getOpcode(n2);
            int n7 = this.stackWordDelta(classHolder, n2, s2);
            if ((n5 += n7) > n6) {
                n6 = n5;
            }
            if ((nArray = this.findConditionalPCs(n2, s2)) != null && nArray[3] != -1) {
                int n8 = this.findMaxStack(classHolder, nArray[1], nArray[2]);
                if (n5 + n8 > n6) {
                    n6 = n5 + n8;
                }
                n2 = nArray[3];
                continue;
            }
            n2 += CodeChunk.instructionLength(s2);
        }
        return n6;
    }

    private int stackWordDelta(ClassHolder classHolder, int n2, short s2) {
        int n3 = OPCODE_ACTION[s2][0];
        if (n3 == -128) {
            n3 = this.getVariableStackDelta(classHolder, n2, s2);
        }
        return n3;
    }

    private String getTypeDescriptor(ClassHolder classHolder, int n2) {
        int n3 = this.getU2(n2);
        CONSTANT_Index_info cONSTANT_Index_info = (CONSTANT_Index_info)classHolder.getEntry(n3);
        int n4 = cONSTANT_Index_info.getI2();
        cONSTANT_Index_info = (CONSTANT_Index_info)classHolder.getEntry(n4);
        int n5 = cONSTANT_Index_info.getI2();
        CONSTANT_Utf8_info cONSTANT_Utf8_info = (CONSTANT_Utf8_info)classHolder.getEntry(n5);
        String string = cONSTANT_Utf8_info.toString();
        return string;
    }

    private static int getDescriptorWordCount(String string) {
        int n2;
        if ("D".equals(string)) {
            n2 = 2;
        } else if ("J".equals(string)) {
            n2 = 2;
        } else if (string.charAt(0) == '(') {
            switch (string.charAt(string.length() - 1)) {
                case 'D': 
                case 'J': {
                    n2 = 2;
                    break;
                }
                case 'V': {
                    n2 = 0;
                    break;
                }
                default: {
                    n2 = 1;
                    break;
                }
            }
        } else {
            n2 = 1;
        }
        return n2;
    }

    private int getVariableStackDelta(ClassHolder classHolder, int n2, int n3) {
        String string = this.getTypeDescriptor(classHolder, n2);
        int n4 = CodeChunk.getDescriptorWordCount(string);
        int n5 = 0;
        switch (n3) {
            case 178: {
                n5 = n4;
                break;
            }
            case 180: {
                n5 = n4 - 1;
                break;
            }
            case 179: {
                n5 = -n4;
                break;
            }
            case 181: {
                n5 = -n4 - 1;
                break;
            }
            case 182: 
            case 183: {
                n5 = -1;
            }
            case 184: {
                n5 += n4 - CodeChunk.parameterWordCount(string);
                break;
            }
            case 185: {
                n5 = n4 - this.getOpcode(n2 + 3);
                break;
            }
            default: {
                System.out.println("WHO IS THIS ");
            }
        }
        return n5;
    }

    private static int parameterWordCount(String string) {
        int n2 = 0;
        int n3 = 1;
        while (true) {
            switch (string.charAt(n3)) {
                case ')': {
                    return n2;
                }
                case 'D': 
                case 'J': {
                    n2 += 2;
                    break;
                }
                case '[': {
                    while (string.charAt(++n3) == '[') {
                    }
                    if (string.charAt(n3) != 'L') {
                        ++n2;
                        break;
                    }
                }
                case 'L': {
                    while (string.charAt(++n3) != ';') {
                    }
                    ++n2;
                    break;
                }
                default: {
                    ++n2;
                }
            }
            ++n3;
        }
    }

    private int[] findConditionalPCs(int n2, short s2) {
        int[] nArray;
        int n3;
        int n4;
        int n5;
        switch (s2) {
            default: {
                return null;
            }
            case 153: 
            case 154: 
            case 198: 
            case 199: 
        }
        int n6 = this.getU2(n2);
        if (n6 == 8 && this.getOpcode(n2 + 3) == 200) {
            n5 = n2 + 3 + 5;
            n4 = n2 + 3 + this.getU4(n2 + 3);
        } else {
            n5 = n2 + 3;
            n4 = n2 + n6;
        }
        int n7 = -1;
        int n8 = n5;
        while (n8 < n4) {
            n3 = this.getOpcode(n8);
            nArray = this.findConditionalPCs(n8, (short)n3);
            if (nArray != null) {
                n8 = nArray[5];
                continue;
            }
            if (n3 == 167) {
                if (n8 != n4 - 3) continue;
                n7 = n8 + this.getU2(n8);
                break;
            }
            if (n3 == 200) {
                if (n8 != n4 - 5) continue;
                n7 = n8 + this.getU4(n8);
                break;
            }
            n8 += CodeChunk.instructionLength((short)n3);
        }
        if (n7 == -1) {
            n7 = n4;
            n4 = -1;
            n3 = n7 - n5;
            n8 = -1;
        } else {
            n3 = n4 - n5;
            n8 = n7 - n4;
        }
        nArray = new int[]{n2, n5, n3, n4, n8, n7};
        return nArray;
    }

    final int splitZeroStack(BCMethod bCMethod, ClassHolder classHolder, int n2, int n3) {
        int n4 = CodeChunk.splitMinLength(bCMethod);
        int n5 = 0;
        int n6 = -1;
        int n7 = -1;
        int n8 = this.getPC();
        int n9 = n2;
        while (n9 < n8) {
            short s2 = this.getOpcode(n9);
            int n10 = this.stackWordDelta(classHolder, n9, s2);
            n5 += n10;
            int[] nArray = this.findConditionalPCs(n9, s2);
            if (nArray != null) {
                if (nArray[3] != -1) {
                    n9 = nArray[3];
                    continue;
                }
                if (n7 == -1) {
                    n7 = nArray[5];
                }
            }
            n9 += CodeChunk.instructionLength(s2);
            if (n7 != -1) {
                if (n9 <= n7) continue;
                n7 = -1;
                continue;
            }
            if (n5 != 0) continue;
            int n11 = n9 - n2;
            if (n11 < n3) {
                n6 = n11;
                continue;
            }
            if (n11 > 65534) {
                n11 = -1;
            } else if (CodeChunk.isReturn(s2)) {
                n11 = -1;
            }
            if (n11 == -1) {
                if (n6 == -1) {
                    return -1;
                }
                if (n6 <= n4) {
                    return -1;
                }
                n11 = n6;
            }
            BCMethod bCMethod2 = this.startSubMethod(bCMethod, "void", n2, n11);
            return this.splitCodeIntoSubMethod(bCMethod, classHolder, bCMethod2, n2, n11);
        }
        return -1;
    }

    private BCMethod startSubMethod(BCMethod bCMethod, String string, int n2, int n3) {
        boolean bl = this.usesParameters(bCMethod, n2, n3);
        return bCMethod.getNewSubMethod(string, bl);
    }

    private boolean usesParameters(BCMethod bCMethod, int n2, int n3) {
        if (bCMethod.parameters == null) {
            return false;
        }
        boolean bl = (bCMethod.myEntry.getModifier() & 8) != 0;
        int n4 = n2 + n3;
        while (n2 < n4) {
            short s2 = this.getOpcode(n2);
            switch (s2) {
                case 26: 
                case 30: 
                case 34: 
                case 38: {
                    return true;
                }
                case 42: {
                    if (!bl) break;
                    return true;
                }
                case 27: 
                case 31: 
                case 35: 
                case 39: 
                case 43: {
                    return true;
                }
                case 28: 
                case 32: 
                case 36: 
                case 40: 
                case 44: {
                    return true;
                }
                case 29: 
                case 33: 
                case 37: 
                case 41: 
                case 45: {
                    return true;
                }
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    return true;
                }
            }
            n2 += CodeChunk.instructionLength(s2);
        }
        return false;
    }

    private int splitCodeIntoSubMethod(BCMethod bCMethod, ClassHolder classHolder, BCMethod bCMethod2, int n2, int n3) {
        CodeChunk codeChunk = bCMethod2.myCode;
        byte[] byArray = this.cout.getData();
        try {
            codeChunk.cout.write(byArray, 8 + n2, n3);
        }
        catch (IOException iOException) {
            this.limitHit(iOException);
        }
        if (bCMethod2.myReturnType.equals("void")) {
            codeChunk.addInstr((short)177);
        } else {
            codeChunk.addInstr((short)176);
        }
        if (this.cb.limitMsg != null) {
            return -1;
        }
        bCMethod2.maxStack = codeChunk.findMaxStack(classHolder, 0, codeChunk.getPC());
        bCMethod2.complete();
        return this.removePushedCode(bCMethod, classHolder, bCMethod2, n2, n3);
    }

    private int removePushedCode(BCMethod bCMethod, ClassHolder classHolder, BCMethod bCMethod2, int n2, int n3) {
        CodeChunk codeChunk;
        int n4 = this.getPC();
        bCMethod.myCode = codeChunk = new CodeChunk(bCMethod.cb);
        bCMethod.maxStack = 0;
        byte[] byArray = this.cout.getData();
        if (n2 != 0) {
            try {
                codeChunk.cout.write(byArray, 8, n2);
            }
            catch (IOException iOException) {
                this.limitHit(iOException);
            }
        }
        bCMethod.callSubMethod(bCMethod2);
        int n5 = codeChunk.getPC();
        int n6 = n2 + n3;
        int n7 = n4 - n3 - n2;
        try {
            codeChunk.cout.write(byArray, 8 + n6, n7);
        }
        catch (IOException iOException) {
            this.limitHit(iOException);
        }
        if (this.cb.limitMsg != null) {
            return -1;
        }
        bCMethod.maxStack = codeChunk.findMaxStack(classHolder, 0, codeChunk.getPC());
        return n5;
    }

    final int splitExpressionOut(BCMethod bCMethod, ClassHolder classHolder, int n2, int n3) {
        int n4 = -1;
        int n5 = -1;
        String string = null;
        int n6 = CodeChunk.splitMinLength(bCMethod);
        int[] nArray = new int[n3 + 1];
        int n7 = 0;
        int n8 = -1;
        int n9 = this.getPC();
        int n10 = 0;
        block10: while (n10 < n9) {
            int n11;
            int n12;
            int n13;
            int n14;
            String string2;
            short s2 = this.getOpcode(n10);
            int n15 = this.stackWordDelta(classHolder, n10, s2);
            n7 += n15;
            int[] nArray2 = this.findConditionalPCs(n10, s2);
            if (nArray2 != null) {
                return -1;
            }
            n10 += CodeChunk.instructionLength(s2);
            if (n8 != -1) {
                if (n10 <= n8) continue;
                n8 = -1;
                continue;
            }
            int n16 = n10 - CodeChunk.instructionLength(s2);
            switch (s2) {
                default: {
                    Arrays.fill(nArray, 0, n7 + 1, -1);
                    continue block10;
                }
                case 0: 
                case 119: 
                case 139: 
                case 143: 
                case 190: 
                case 192: {
                    continue block10;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 11: 
                case 12: 
                case 13: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 23: 
                case 25: 
                case 42: 
                case 43: 
                case 44: 
                case 45: {
                    nArray[n7] = n16;
                    continue block10;
                }
                case 9: 
                case 10: 
                case 14: 
                case 15: 
                case 20: 
                case 22: 
                case 30: 
                case 31: 
                case 32: 
                case 33: {
                    nArray[n7 - 1] = nArray[n7] = n16;
                    continue block10;
                }
                case 87: 
                case 88: {
                    continue block10;
                }
                case 95: {
                    nArray[n7] = nArray[n7 - 1];
                    continue block10;
                }
                case 133: {
                    nArray[n7] = nArray[n7 - 1];
                    continue block10;
                }
                case 180: {
                    string2 = this.getTypeDescriptor(classHolder, n16);
                    n14 = CodeChunk.getDescriptorWordCount(string2);
                    if (n14 != 2) continue block10;
                    nArray[n7] = nArray[n7 - 1];
                    continue block10;
                }
                case 182: 
                case 185: 
            }
            string2 = this.getTypeDescriptor(classHolder, n16);
            n14 = CodeChunk.getDescriptorWordCount(string2);
            if (n14 == 0) {
                n13 = -1;
            } else if (n14 == 1) {
                n13 = nArray[n7];
            } else {
                n13 = -1;
                nArray[n7] = nArray[n7 - 1];
            }
            if (n13 == -1 || (n12 = n10 - n13) <= n6 || n12 > 65534 || string2.charAt((n11 = string2.lastIndexOf(41)) + 1) != 'L') continue;
            String string3 = string2.substring(n11 + 2, string2.length() - 1);
            string3 = string3.replace('/', '.');
            if (n12 >= n2) {
                BCMethod bCMethod2 = this.startSubMethod(bCMethod, string3, n13, n12);
                return this.splitCodeIntoSubMethod(bCMethod, classHolder, bCMethod2, n13, n12);
            }
            if (n12 <= n5) continue;
            n4 = n13;
            n5 = n12;
            string = string3;
        }
        if (n5 != -1) {
            BCMethod bCMethod3 = this.startSubMethod(bCMethod, string, n4, n5);
            return this.splitCodeIntoSubMethod(bCMethod, classHolder, bCMethod3, n4, n5);
        }
        return -1;
    }

    private static boolean isReturn(short s2) {
        switch (s2) {
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: {
                return true;
            }
        }
        return false;
    }

    private static int splitMinLength(BCMethod bCMethod) {
        int n2 = 4;
        if (bCMethod.parameters != null) {
            int n3 = bCMethod.parameters.length;
            n2 += n3;
            if (n3 > 3) {
                n2 += n3 - 3;
            }
        }
        return n2;
    }
}

