/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.jce;

import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.crypto.CipherProvider;
import org.apache.derby.impl.services.jce.JCECipherFactory;

class JCECipherProvider
implements CipherProvider {
    private Cipher cipher;
    private int mode;
    private boolean ivUsed = true;
    private final IvParameterSpec ivspec;
    private final int encryptionBlockSize;
    private boolean sunjce;
    private SecretKey cryptixKey;

    JCECipherProvider(int n2, SecretKey secretKey, byte[] byArray, String string, String string2) throws StandardException {
        GeneralSecurityException generalSecurityException;
        this.ivspec = new IvParameterSpec(byArray);
        try {
            block28: {
                if (string2 == null) {
                    this.cipher = Cipher.getInstance(string);
                    if ("SunJCE".equals(this.cipher.getProvider().getName())) {
                        this.sunjce = true;
                    }
                } else {
                    if (string2.equals("SunJCE")) {
                        this.sunjce = true;
                    } else if (string2.equals("BouncyCastleProvider")) {
                        string2 = "BC";
                    }
                    this.cipher = Cipher.getInstance(string, string2);
                }
                this.encryptionBlockSize = this.cipher.getBlockSize();
                this.mode = n2;
                try {
                    if (n2 == 1) {
                        if (string.indexOf("/ECB") > -1) {
                            this.cipher.init(1, secretKey);
                        } else {
                            this.cipher.init(1, (Key)secretKey, this.ivspec);
                        }
                        break block28;
                    }
                    if (n2 == 2) {
                        if (string.indexOf("/ECB") > -1) {
                            this.cipher.init(2, secretKey);
                        } else {
                            this.cipher.init(2, (Key)secretKey, this.ivspec);
                        }
                        break block28;
                    }
                    throw StandardException.newException("XBCX1.S", new Object[0]);
                }
                catch (InvalidKeyException invalidKeyException) {
                    if (string.startsWith("DES")) {
                        SecretKeyFactory secretKeyFactory = string2 == null ? SecretKeyFactory.getInstance(secretKey.getAlgorithm()) : SecretKeyFactory.getInstance(secretKey.getAlgorithm(), string2);
                        secretKey = secretKeyFactory.translateKey(new SecretKeySpec(secretKey.getEncoded(), secretKey.getAlgorithm()));
                        if (n2 == 1) {
                            if (string.indexOf("/ECB") > -1) {
                                this.cipher.init(1, secretKey);
                            } else {
                                this.cipher.init(1, (Key)secretKey, this.ivspec);
                            }
                        } else if (n2 == 2) {
                            if (string.indexOf("/ECB") > -1) {
                                this.cipher.init(2, secretKey);
                            } else {
                                this.cipher.init(2, (Key)secretKey, this.ivspec);
                            }
                        }
                    }
                    throw StandardException.newException("XBCX0.S", invalidKeyException, new Object[0]);
                }
            }
            this.cryptixKey = secretKey;
            if (this.cipher.getIV() == null) {
                this.ivUsed = false;
            }
            return;
        }
        catch (InvalidKeyException invalidKeyException) {
            generalSecurityException = invalidKeyException;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw StandardException.newException("XBCXC.S", string, JCECipherFactory.providerErrorName(string2));
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw StandardException.newException("XBCXG.S", JCECipherFactory.providerErrorName(string2));
        }
        catch (GeneralSecurityException generalSecurityException2) {
            generalSecurityException = generalSecurityException2;
        }
        throw StandardException.newException("XBCX0.S", generalSecurityException, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int encrypt(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws StandardException {
        int n5 = 0;
        try {
            JCECipherProvider jCECipherProvider = this;
            synchronized (jCECipherProvider) {
                if (!this.sunjce) {
                    try {
                        if (this.mode == 1) {
                            if (this.ivUsed) {
                                this.cipher.init(1, (Key)this.cryptixKey, this.ivspec);
                            } else {
                                this.cipher.init(1, this.cryptixKey);
                            }
                        } else if (this.mode == 2) {
                            if (this.ivUsed) {
                                this.cipher.init(2, (Key)this.cryptixKey, this.ivspec);
                            } else {
                                this.cipher.init(2, this.cryptixKey);
                            }
                        }
                    }
                    catch (InvalidKeyException invalidKeyException) {
                        System.out.println("A " + invalidKeyException);
                        throw StandardException.newException("XBCX0.S", invalidKeyException, new Object[0]);
                    }
                }
                n5 = this.cipher.doFinal(byArray, n2, n3, byArray2, n4);
            }
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (GeneralSecurityException generalSecurityException) {
            System.out.println("B " + generalSecurityException);
            throw StandardException.newException("XBCX0.S", generalSecurityException, new Object[0]);
        }
        return n5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int decrypt(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws StandardException {
        int n5 = 0;
        try {
            JCECipherProvider jCECipherProvider = this;
            synchronized (jCECipherProvider) {
                if (!this.sunjce) {
                    try {
                        if (this.mode == 1) {
                            if (this.ivUsed) {
                                this.cipher.init(1, (Key)this.cryptixKey, this.ivspec);
                            } else {
                                this.cipher.init(1, this.cryptixKey);
                            }
                        } else if (this.mode == 2) {
                            if (this.ivUsed) {
                                this.cipher.init(2, (Key)this.cryptixKey, this.ivspec);
                            } else {
                                this.cipher.init(2, this.cryptixKey);
                            }
                        }
                    }
                    catch (InvalidKeyException invalidKeyException) {
                        System.out.println("C " + invalidKeyException);
                        throw StandardException.newException("XBCX0.S", invalidKeyException, new Object[0]);
                    }
                }
                n5 = this.cipher.doFinal(byArray, n2, n3, byArray2, n4);
            }
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (GeneralSecurityException generalSecurityException) {
            System.out.println("D " + generalSecurityException);
            throw StandardException.newException("XBCX0.S", generalSecurityException, new Object[0]);
        }
        return n5;
    }

    boolean verifyIV(byte[] byArray) {
        byte[] byArray2 = this.cipher.getIV();
        if (byArray2 == null) {
            return !this.ivUsed;
        }
        if (byArray2.length != byArray.length) {
            return false;
        }
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if (byArray2[i2] == byArray[i2]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getEncryptionBlockSize() {
        return this.encryptionBlockSize;
    }
}

