/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.locks;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.locks.CompatibilitySpace;
import org.apache.derby.iapi.services.locks.Latch;
import org.apache.derby.iapi.services.locks.Lockable;
import org.apache.derby.impl.services.locks.AbstractPool;
import org.apache.derby.impl.services.locks.ActiveLock;
import org.apache.derby.impl.services.locks.Control;
import org.apache.derby.impl.services.locks.Deadlock;
import org.apache.derby.impl.services.locks.Lock;
import org.apache.derby.impl.services.locks.LockControl;
import org.apache.derby.impl.services.locks.LockTable;
import org.apache.derby.impl.services.locks.Timeout;

final class ConcurrentLockSet
implements LockTable {
    private final AbstractPool factory;
    private final ConcurrentHashMap<Lockable, Entry> locks;
    private ArrayList<Entry> seenByDeadlockDetection;
    private int deadlockTimeout = 20000;
    private int waitTimeout = 60000;
    private boolean deadlockTrace;
    private final AtomicInteger blockCount;

    ConcurrentLockSet(AbstractPool abstractPool) {
        this.factory = abstractPool;
        this.blockCount = new AtomicInteger();
        this.locks = new ConcurrentHashMap();
    }

    private Entry getEntry(Lockable lockable) {
        Entry entry = this.locks.get(lockable);
        while (true) {
            Entry entry2;
            if (entry != null) {
                entry.lock();
                if (entry.control != null) {
                    return entry;
                }
            } else {
                entry = new Entry();
                entry.lock();
            }
            if ((entry2 = this.locks.putIfAbsent(lockable, entry)) == null) {
                return entry;
            }
            entry.unlock();
            entry = entry2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] checkDeadlock(Entry entry, ActiveLock activeLock, byte by) {
        LockControl lockControl = (LockControl)entry.control;
        entry.enterDeadlockDetection();
        Class<Deadlock> clazz = Deadlock.class;
        synchronized (Deadlock.class) {
            Object[] objectArray;
            try {
                objectArray = Deadlock.look(this.factory, this, lockControl, activeLock, by);
            }
            catch (Throwable throwable) {
                for (Entry entry2 : this.seenByDeadlockDetection) {
                    entry2.unlock();
                }
                this.seenByDeadlockDetection = null;
                entry.exitDeadlockDetection();
                throw throwable;
            }
            for (Entry entry3 : this.seenByDeadlockDetection) {
                entry3.unlock();
            }
            this.seenByDeadlockDetection = null;
            entry.exitDeadlockDetection();
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return objectArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Lock lockObject(CompatibilitySpace compatibilitySpace, Lockable lockable, Object object, int n2) throws StandardException {
        int n3;
        Lock lock;
        LockControl lockControl;
        Object var7_5 = null;
        boolean bl = false;
        Entry entry = this.getEntry(lockable);
        try {
            Control control = entry.control;
            if (control == null) {
                Lock lock2 = new Lock(compatibilitySpace, lockable, object);
                lock2.grant();
                entry.control = lock2;
                Lock lock3 = lock2;
                return lock3;
            }
            lockControl = control.getLockControl();
            if (lockControl != control) {
                entry.control = lockControl;
            }
            if ((lock = lockControl.addLock(this, compatibilitySpace, object)).getCount() != 0) {
                Lock lock4 = lock;
                return lock4;
            }
            boolean bl2 = bl = n2 == 0 && compatibilitySpace.getOwner().isNestedOwner() && lockControl.blockedByParent(lock);
            if (AbstractPool.noLockWait(n2, compatibilitySpace) || bl) {
                lockControl.giveUpWait(lock, this);
                Lock lock5 = null;
                return lock5;
            }
        }
        finally {
            entry.unlock();
            if (bl) {
                throw StandardException.newException("40XL2", new Object[0]);
            }
        }
        boolean bl3 = false;
        if (n2 == -1) {
            bl3 = true;
            n3 = this.deadlockTimeout;
            if (n3 == -1) {
                n3 = 20000;
            }
        } else {
            if (n2 == -2) {
                n2 = n3 = this.waitTimeout;
            } else {
                n3 = n2;
            }
            if (this.deadlockTimeout >= 0) {
                if (n3 < 0) {
                    bl3 = true;
                    n3 = this.deadlockTimeout;
                } else if (this.deadlockTimeout < n3) {
                    bl3 = true;
                    n3 = this.deadlockTimeout;
                    n2 -= this.deadlockTimeout;
                }
            }
        }
        ActiveLock activeLock = (ActiveLock)lock;
        lock = null;
        int n4 = 0;
        long l2 = 0L;
        while (true) {
            long l3;
            byte by = 0;
            ActiveLock activeLock2 = null;
            Object[] objectArray = null;
            try {
                boolean bl4;
                try {
                    by = activeLock.waitForGrant(n3);
                }
                catch (StandardException standardException) {
                    activeLock2 = lockControl.getNextWaiter(activeLock, true, this);
                    throw standardException;
                }
                Enumeration enumeration = null;
                l3 = 0L;
                entry.lock();
                try {
                    if (lockControl.isGrantable(lockControl.firstWaiter() == activeLock, compatibilitySpace, object)) {
                        lockControl.grant(activeLock);
                        activeLock2 = lockControl.getNextWaiter(activeLock, true, this);
                        ActiveLock activeLock3 = activeLock;
                        return activeLock3;
                    }
                    activeLock.clearPotentiallyGranted();
                    boolean bl5 = bl4 = by != 1;
                    if (by == 0 && bl3 || by == 2) {
                        objectArray = this.checkDeadlock(entry, activeLock, by);
                        if (objectArray == null) {
                            bl3 = false;
                            n3 = n2;
                            l2 = 0L;
                            bl4 = false;
                        } else {
                            bl4 = true;
                        }
                    }
                    activeLock2 = lockControl.getNextWaiter(activeLock, bl4, this);
                }
                finally {
                    entry.unlock();
                }
                if (bl4) {
                    if (this.deadlockTrace && objectArray == null) {
                        l3 = System.currentTimeMillis();
                        enumeration = this.factory.makeVirtualLockTable();
                    }
                    if (objectArray == null) {
                        if (by == 3) {
                            throw StandardException.newException("08000", new Object[0]);
                        }
                        if (this.deadlockTrace) {
                            throw Timeout.buildException(activeLock, enumeration, l3);
                        }
                        StandardException standardException = StandardException.newException("40XL1", new Object[0]);
                        throw standardException;
                    }
                    throw Deadlock.buildException(this.factory, objectArray);
                }
            }
            finally {
                if (activeLock2 != null) {
                    activeLock2.wakeUp((byte)1);
                    activeLock2 = null;
                }
            }
            if (n3 == -1) continue;
            if (by != 0) {
                ++n4;
            }
            if (n4 <= 5) continue;
            long l4 = System.currentTimeMillis();
            if (l2 != 0L) {
                l3 = l4 - l2;
                n3 = (int)((long)n3 - l3);
            }
            l2 = l4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock(Latch latch, int n2) {
        Entry entry = this.locks.get(latch.getLockable());
        entry.lock();
        try {
            this.unlock(entry, latch, n2);
        }
        finally {
            entry.unlock();
        }
    }

    private void unlock(Entry entry, Latch latch, int n2) {
        boolean bl = false;
        ActiveLock activeLock = null;
        Control control = entry.control;
        bl = control.unlock(latch, n2);
        latch = null;
        boolean bl2 = true;
        if (bl && (activeLock = control.firstWaiter()) != null) {
            bl2 = false;
            if (!activeLock.setPotentiallyGranted()) {
                activeLock = null;
            }
        }
        if (bl2) {
            if (control.isEmpty()) {
                this.locks.remove(control.getLockable());
                entry.control = null;
            }
            return;
        }
        if (bl && activeLock != null) {
            activeLock.wakeUp((byte)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Lock unlockReference(CompatibilitySpace compatibilitySpace, Lockable lockable, Object object, Map map) {
        Entry entry = this.locks.get(lockable);
        if (entry == null) {
            return null;
        }
        entry.lock();
        try {
            Control control = entry.control;
            if (control == null) {
                Lock lock = null;
                return lock;
            }
            Lock lock = control.getLock(compatibilitySpace, object);
            if (lock == null) {
                Lock lock2 = null;
                return lock2;
            }
            Lock lock3 = (Lock)map.remove(lock);
            if (lock3 != null) {
                this.unlock(entry, lock3, 1);
            }
            Lock lock4 = lock3;
            return lock4;
        }
        finally {
            entry.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean zeroDurationLockObject(CompatibilitySpace compatibilitySpace, Lockable lockable, Object object, int n2) throws StandardException {
        Control control;
        Entry entry = this.locks.get(lockable);
        if (entry == null) {
            return true;
        }
        entry.lock();
        try {
            control = entry.control;
            if (control == null) {
                boolean bl = true;
                return bl;
            }
            if (control.isGrantable(true, compatibilitySpace, object)) {
                boolean bl = true;
                return bl;
            }
            if (AbstractPool.noLockWait(n2, compatibilitySpace)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            entry.unlock();
        }
        control = this.lockObject(compatibilitySpace, lockable, object, n2);
        this.unlock((Latch)((Object)control), 1);
        return true;
    }

    @Override
    public void setDeadlockTimeout(int n2) {
        this.deadlockTimeout = n2;
    }

    @Override
    public void setWaitTimeout(int n2) {
        this.waitTimeout = n2;
    }

    @Override
    public int getWaitTimeout() {
        return this.waitTimeout;
    }

    @Override
    public void setDeadlockTrace(boolean bl) {
        this.deadlockTrace = bl;
    }

    private String toDebugString() {
        return null;
    }

    @Override
    public void addWaiters(Map<Object, Object> map) {
        this.seenByDeadlockDetection = new ArrayList(this.locks.size());
        for (Entry entry : this.locks.values()) {
            this.seenByDeadlockDetection.add(entry);
            entry.lockForDeadlockDetection();
            if (entry.control == null) continue;
            entry.control.addWaiters(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Lockable, Control> shallowClone() {
        HashMap<Lockable, Control> hashMap = new HashMap<Lockable, Control>();
        for (Entry entry : this.locks.values()) {
            entry.lock();
            try {
                Control control = entry.control;
                if (control == null) continue;
                hashMap.put(control.getLockable(), control.shallowClone());
            }
            finally {
                entry.unlock();
            }
        }
        return hashMap;
    }

    @Override
    public void oneMoreWaiter() {
        this.blockCount.incrementAndGet();
    }

    @Override
    public void oneLessWaiter() {
        this.blockCount.decrementAndGet();
    }

    @Override
    public boolean anyoneBlocked() {
        int n2 = this.blockCount.get();
        return n2 != 0;
    }

    private static final class Entry {
        Control control;
        private final ReentrantLock mutex = new ReentrantLock();
        private Condition deadlockDetection;

        private Entry() {
        }

        void lock() {
            this.mutex.lock();
            while (this.deadlockDetection != null) {
                this.deadlockDetection.awaitUninterruptibly();
            }
        }

        void unlock() {
            this.mutex.unlock();
        }

        void lockForDeadlockDetection() {
            this.mutex.lock();
        }

        void enterDeadlockDetection() {
            this.deadlockDetection = this.mutex.newCondition();
            this.mutex.unlock();
        }

        void exitDeadlockDetection() {
            this.mutex.lock();
            this.deadlockDetection.signalAll();
            this.deadlockDetection = null;
        }
    }
}

