/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.uuid;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StringReader;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.io.Formatable;

public class BasicUUID
implements UUID,
Formatable {
    private long majorId;
    private long timemillis;
    private int sequence;

    public BasicUUID(long l2, long l3, int n2) {
        this.majorId = l2;
        this.timemillis = l3;
        this.sequence = n2;
    }

    public BasicUUID(String string) {
        StringReader stringReader = new StringReader(string);
        this.sequence = (int)BasicUUID.readMSB(stringReader);
        long l2 = BasicUUID.readMSB(stringReader) << 32;
        l2 += BasicUUID.readMSB(stringReader) << 16;
        this.timemillis = l2 += BasicUUID.readMSB(stringReader);
        this.majorId = BasicUUID.readMSB(stringReader);
    }

    public BasicUUID() {
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeLong(this.majorId);
        objectOutput.writeLong(this.timemillis);
        objectOutput.writeInt(this.sequence);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        this.majorId = objectInput.readLong();
        this.timemillis = objectInput.readLong();
        this.sequence = objectInput.readInt();
    }

    @Override
    public int getTypeFormatId() {
        return 131;
    }

    private static void writeMSB(char[] cArray, int n2, long l2, int n3) {
        for (int i2 = n3 - 1; i2 >= 0; --i2) {
            long l3 = (l2 & 255L << 8 * i2) >>> 8 * i2;
            int n4 = (int)((l3 & 0xF0L) >> 4);
            cArray[n2++] = (char)(n4 < 10 ? n4 + 48 : n4 - 10 + 97);
            n4 = (int)(l3 & 0xFL);
            cArray[n2++] = (char)(n4 < 10 ? n4 + 48 : n4 - 10 + 97);
        }
    }

    private static long readMSB(StringReader stringReader) {
        long l2 = 0L;
        try {
            int n2;
            while ((n2 = stringReader.read()) != -1 && n2 != 45) {
                l2 <<= 4;
                int n3 = n2 <= 57 ? n2 - 48 : (n2 <= 70 ? n2 - 65 + 10 : n2 - 97 + 10);
                l2 += (long)n3;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return l2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof BasicUUID)) {
            return false;
        }
        BasicUUID basicUUID = (BasicUUID)object;
        return this.sequence == basicUUID.sequence && this.timemillis == basicUUID.timemillis && this.majorId == basicUUID.majorId;
    }

    public int hashCode() {
        long l2 = this.majorId ^ this.timemillis;
        return this.sequence ^ (int)(l2 >> 4);
    }

    public String toString() {
        return this.stringWorkhorse('-');
    }

    @Override
    public String toANSIidentifier() {
        return "U" + this.stringWorkhorse('X');
    }

    public String stringWorkhorse(char c2) {
        char[] cArray = new char[36];
        BasicUUID.writeMSB(cArray, 0, this.sequence, 4);
        int n2 = 8;
        if (c2 != '\u0000') {
            cArray[n2++] = c2;
        }
        long l2 = this.timemillis;
        BasicUUID.writeMSB(cArray, n2, (l2 & 0xFFFF00000000L) >>> 32, 2);
        n2 += 4;
        if (c2 != '\u0000') {
            cArray[n2++] = c2;
        }
        BasicUUID.writeMSB(cArray, n2, (l2 & 0xFFFF0000L) >>> 16, 2);
        n2 += 4;
        if (c2 != '\u0000') {
            cArray[n2++] = c2;
        }
        BasicUUID.writeMSB(cArray, n2, l2 & 0xFFFFL, 2);
        n2 += 4;
        if (c2 != '\u0000') {
            cArray[n2++] = c2;
        }
        BasicUUID.writeMSB(cArray, n2, this.majorId, 6);
        return new String(cArray, 0, n2 += 12);
    }

    @Override
    public UUID cloneMe() {
        return new BasicUUID(this.majorId, this.timemillis, this.sequence);
    }
}

