/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.sql.ResultSetMetaData;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.derby.iapi.services.io.ArrayUtil;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.sql.GenericColumnDescriptor;

public final class GenericResultDescription
implements ResultDescription,
Formatable {
    private ResultColumnDescriptor[] columns;
    private String statementType;
    private transient ResultSetMetaData metaData;
    private Map<String, Integer> columnNameMap;

    public GenericResultDescription() {
    }

    public GenericResultDescription(ResultColumnDescriptor[] resultColumnDescriptorArray, String string) {
        this.columns = ArrayUtil.copy(resultColumnDescriptorArray);
        this.statementType = string;
    }

    public GenericResultDescription(ResultDescription resultDescription, int[] nArray) {
        this.columns = new ResultColumnDescriptor[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            this.columns[i2] = resultDescription.getColumnDescriptor(nArray[i2]);
        }
        this.statementType = resultDescription.getStatementType();
    }

    @Override
    public String getStatementType() {
        return this.statementType;
    }

    @Override
    public int getColumnCount() {
        return this.columns == null ? 0 : this.columns.length;
    }

    @Override
    public ResultColumnDescriptor[] getColumnInfo() {
        return ArrayUtil.copy(this.columns);
    }

    @Override
    public ResultColumnDescriptor getColumnInfo(int n2) {
        return this.columns[n2];
    }

    @Override
    public ResultColumnDescriptor getColumnDescriptor(int n2) {
        return this.columns[n2 - 1];
    }

    @Override
    public ResultDescription truncateColumns(int n2) {
        ResultColumnDescriptor[] resultColumnDescriptorArray = new ResultColumnDescriptor[n2 - 1];
        System.arraycopy(this.columns, 0, resultColumnDescriptorArray, 0, resultColumnDescriptorArray.length);
        return new GenericResultDescription(resultColumnDescriptorArray, this.statementType);
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n2 = this.columns == null ? 0 : this.columns.length;
        objectOutput.writeObject(this.statementType);
        objectOutput.writeInt(n2);
        while (n2-- > 0) {
            if (!(this.columns[n2] instanceof GenericColumnDescriptor)) {
                this.columns[n2] = new GenericColumnDescriptor(this.columns[n2]);
            }
            objectOutput.writeObject(this.columns[n2]);
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.columns = null;
        this.statementType = (String)objectInput.readObject();
        int n2 = objectInput.readInt();
        if (n2 > 0) {
            this.columns = new GenericColumnDescriptor[n2];
            while (n2-- > 0) {
                this.columns[n2] = (ResultColumnDescriptor)objectInput.readObject();
            }
        }
    }

    @Override
    public int getTypeFormatId() {
        return 228;
    }

    public String toString() {
        return "";
    }

    @Override
    public synchronized void setMetaData(ResultSetMetaData resultSetMetaData) {
        if (this.metaData == null) {
            this.metaData = resultSetMetaData;
        }
    }

    @Override
    public synchronized ResultSetMetaData getMetaData() {
        return this.metaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int findColumnInsenstive(String string) {
        Map<String, Integer> map;
        Serializable serializable = this;
        synchronized (serializable) {
            if (this.columnNameMap == null) {
                HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                for (int i2 = this.getColumnCount(); i2 >= 1; --i2) {
                    String string2 = StringUtil.SQLToUpperCase(this.getColumnDescriptor(i2).getName());
                    Integer n2 = i2;
                    hashMap.put(string2, n2);
                }
                this.columnNameMap = Collections.unmodifiableMap(hashMap);
            }
            map = this.columnNameMap;
        }
        serializable = map.get(string);
        if (serializable == null) {
            serializable = map.get(StringUtil.SQLToUpperCase(string));
        }
        if (serializable == null) {
            return -1;
        }
        return (Integer)serializable;
    }
}

