/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.dictionary.SystemColumn;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;

class SystemColumnImpl
implements SystemColumn {
    private final String name;
    private final DataTypeDescriptor type;

    static SystemColumn getColumn(String string, int n2, boolean bl) {
        return new SystemColumnImpl(string, DataTypeDescriptor.getBuiltInDataTypeDescriptor(n2, bl));
    }

    static SystemColumn getColumn(String string, int n2, boolean bl, int n3) {
        return new SystemColumnImpl(string, DataTypeDescriptor.getBuiltInDataTypeDescriptor(n2, bl, n3));
    }

    static SystemColumn getIdentifierColumn(String string, boolean bl) {
        return new SystemColumnImpl(string, DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, bl, 128));
    }

    static SystemColumn getUUIDColumn(String string, boolean bl) {
        return new SystemColumnImpl(string, DataTypeDescriptor.getBuiltInDataTypeDescriptor(1, bl, 36));
    }

    static SystemColumn getIndicatorColumn(String string) {
        return new SystemColumnImpl(string, DataTypeDescriptor.getBuiltInDataTypeDescriptor(1, false, 1));
    }

    static SystemColumn getJavaColumn(String string, String string2, boolean bl) throws StandardException {
        TypeId typeId = TypeId.getUserDefinedTypeId(string2);
        DataTypeDescriptor dataTypeDescriptor = new DataTypeDescriptor(typeId, bl);
        return new SystemColumnImpl(string, dataTypeDescriptor);
    }

    private SystemColumnImpl(String string, DataTypeDescriptor dataTypeDescriptor) {
        this.name = string;
        this.type = dataTypeDescriptor;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DataTypeDescriptor getType() {
        return this.type;
    }
}

