/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.catalog.types.DefaultInfoImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.Parser;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.DefaultDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.CursorNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.UntypedNullConstantNode;
import org.apache.derby.impl.sql.compile.ValueNode;

public class DefaultNode
extends ValueNode {
    private String columnName;
    private String defaultText;
    private ValueNode defaultTree;

    DefaultNode(ContextManager contextManager) {
        super(contextManager);
    }

    DefaultNode(ValueNode valueNode, String string, ContextManager contextManager) {
        super(contextManager);
        this.defaultTree = valueNode;
        this.defaultText = string;
    }

    DefaultNode(String string, ContextManager contextManager) {
        super(contextManager);
        this.columnName = string;
    }

    public String getDefaultText() {
        return this.defaultText;
    }

    ValueNode getDefaultTree() {
        return this.defaultTree;
    }

    @Override
    public String toString() {
        return "";
    }

    @Override
    void printSubNodes(int n2) {
    }

    @Override
    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> list) throws StandardException {
        TableDescriptor tableDescriptor = ((FromBaseTable)fromList.elementAt(0)).getTableDescriptor();
        ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(this.columnName);
        DefaultInfoImpl defaultInfoImpl = (DefaultInfoImpl)columnDescriptor.getDefaultInfo();
        if (defaultInfoImpl != null) {
            String string = defaultInfoImpl.getDefaultText();
            ValueNode valueNode = DefaultNode.parseDefault(string, this.getLanguageConnectionContext(), this.getCompilerContext());
            DefaultDescriptor defaultDescriptor = columnDescriptor.getDefaultDescriptor(this.getDataDictionary());
            this.getCompilerContext().createDependency(defaultDescriptor);
            return valueNode.bindExpression(fromList, subqueryList, list);
        }
        return new UntypedNullConstantNode(this.getContextManager());
    }

    public static ValueNode parseDefault(String string, LanguageConnectionContext languageConnectionContext, CompilerContext compilerContext) throws StandardException {
        String string2 = "VALUES " + string;
        CompilerContext compilerContext2 = languageConnectionContext.pushCompilerContext();
        Parser parser = compilerContext2.getParser();
        Visitable visitable = parser.parseStatement(string2);
        ValueNode valueNode = ((ResultColumn)((CursorNode)visitable).getResultSetNode().getResultColumns().elementAt(0)).getExpression();
        languageConnectionContext.popCompilerContext(compilerContext2);
        return valueNode;
    }

    @Override
    void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
    }

    @Override
    boolean isEquivalent(ValueNode valueNode) {
        return false;
    }
}

