/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizableList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.sql.compile.AndNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromSubquery;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.Predicate;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ProjectRestrictNode;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.QueryTreeNodeVector;
import org.apache.derby.impl.sql.compile.RelationalOperator;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.TableOperatorNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.WindowList;

class FromList
extends QueryTreeNodeVector<ResultSetNode>
implements OptimizableList {
    Properties properties;
    boolean fixedJoinOrder = true;
    boolean useStatistics = true;
    private boolean referencesSessionSchema;
    private boolean isTransparent;
    private WindowList windows;

    FromList(ContextManager contextManager) {
        super(ResultSetNode.class, contextManager);
        this.isTransparent = false;
    }

    FromList(boolean bl, ContextManager contextManager) {
        super(ResultSetNode.class, contextManager);
        this.constructorMinion(bl);
    }

    FromList(boolean bl, FromTable fromTable, ContextManager contextManager) throws StandardException {
        super(ResultSetNode.class, contextManager);
        this.constructorMinion(bl);
        this.addFromTable(fromTable);
    }

    private void constructorMinion(boolean bl) {
        this.fixedJoinOrder = !bl;
        this.isTransparent = false;
    }

    @Override
    public Optimizable getOptimizable(int n2) {
        return (Optimizable)this.elementAt(n2);
    }

    @Override
    public void setOptimizable(int n2, Optimizable optimizable) {
        this.setElementAt((FromTable)optimizable, n2);
    }

    @Override
    public void verifyProperties(DataDictionary dataDictionary) throws StandardException {
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            ((Optimizable)this.elementAt(i2)).verifyProperties(dataDictionary);
        }
    }

    final void addFromTable(FromTable fromTable) throws StandardException {
        if (!(fromTable instanceof TableOperatorNode)) {
            int n2 = this.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                TableName tableName;
                TableName tableName2 = fromTable.getTableName();
                if ((FromTable)this.elementAt(i2) instanceof TableOperatorNode || !tableName2.equals(tableName = ((FromTable)this.elementAt(i2)).getTableName())) continue;
                throw StandardException.newException("42X09", fromTable.getExposedName());
            }
        }
        this.addElement(fromTable);
    }

    boolean referencesTarget(String string, boolean bl) throws StandardException {
        boolean bl2 = false;
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            FromTable fromTable = (FromTable)this.elementAt(i2);
            if (!fromTable.referencesTarget(string, bl)) continue;
            bl2 = true;
            break;
        }
        return bl2;
    }

    @Override
    public boolean referencesSessionSchema() throws StandardException {
        boolean bl = false;
        if (this.referencesSessionSchema) {
            return true;
        }
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            FromTable fromTable = (FromTable)this.elementAt(i2);
            if (!fromTable.referencesSessionSchema()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    FromTable getFromTableByName(String string, String string2, boolean bl) throws StandardException {
        FromTable fromTable = null;
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            FromTable fromTable2 = (FromTable)this.elementAt(i2);
            fromTable = fromTable2.getFromTableByName(string, string2, bl);
            if (fromTable == null) continue;
            return fromTable;
        }
        return fromTable;
    }

    void isJoinColumnForRightOuterJoin(ResultColumn resultColumn) {
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            FromTable fromTable = (FromTable)this.elementAt(i2);
            fromTable.isJoinColumnForRightOuterJoin(resultColumn);
        }
    }

    void bindTables(DataDictionary dataDictionary, FromList fromList) throws StandardException {
        FromTable fromTable;
        FromTable fromTable2;
        int n2;
        boolean bl = this.getCompilerContext().skipTypePrivileges(true);
        int n3 = this.size();
        for (n2 = 0; n2 < n3; ++n2) {
            fromTable2 = (FromTable)this.elementAt(n2);
            fromTable = (FromTable)fromTable2.bindNonVTITables(dataDictionary, fromList);
            if (fromTable2.referencesSessionSchema()) {
                this.referencesSessionSchema = true;
            }
            fromTable.setMergeTableID(fromTable2.getMergeTableID());
            this.setElementAt(fromTable, n2);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            fromTable2 = (FromTable)this.elementAt(n2);
            fromTable = (FromTable)fromTable2.bindVTITables(fromList);
            if (fromTable2.referencesSessionSchema()) {
                this.referencesSessionSchema = true;
            }
            fromTable.setMergeTableID(fromTable2.getMergeTableID());
            this.setElementAt(fromTable, n2);
        }
        CompilerContext compilerContext = this.getCompilerContext();
        compilerContext.pushCurrentPrivType(8);
        for (int i2 = 0; i2 < n3; ++i2) {
            fromTable2 = (FromTable)this.elementAt(i2);
            if (!fromTable2.isPrivilegeCollectionRequired() || !fromTable2.isBaseTable() || fromTable2.forUpdate()) continue;
            compilerContext.addRequiredColumnPriv(fromTable2.getTableDescriptor().getColumnDescriptor(1));
        }
        compilerContext.popCurrentPrivType();
        this.getCompilerContext().skipTypePrivileges(bl);
    }

    void bindExpressions(FromList fromList) throws StandardException {
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            FromTable fromTable = (FromTable)this.elementAt(i2);
            fromTable.bindExpressions(this.isTransparent ? fromList : this);
        }
    }

    void bindResultColumns(FromList fromList) throws StandardException {
        int n2 = fromList.size();
        int n3 = this.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            FromTable fromTable = (FromTable)this.elementAt(i2);
            if (fromTable.needsSpecialRCLBinding()) {
                fromTable.bindResultColumns(fromList);
            }
            fromList.insertElementAt(fromTable, 0);
        }
        while (fromList.size() > n2) {
            fromList.removeElementAt(0);
        }
    }

    ResultColumnList expandAll(TableName tableName) throws StandardException {
        FromTable fromTable;
        ResultColumnList resultColumnList = null;
        boolean bl = false;
        int n2 = ((FromTable)this.elementAt(0)).getLevel();
        int n3 = this.size();
        for (int i2 = 0; i2 < n3 && n2 == (fromTable = (FromTable)this.elementAt(i2)).getLevel(); ++i2) {
            ResultColumnList resultColumnList2 = fromTable.getAllResultColumns(tableName);
            if (resultColumnList2 == null) continue;
            if (resultColumnList == null) {
                resultColumnList = resultColumnList2;
            } else {
                resultColumnList.nondestructiveAppend(resultColumnList2);
            }
            if (tableName == null) continue;
            bl = true;
        }
        if (resultColumnList == null) {
            throw StandardException.newException("42X10", tableName);
        }
        return resultColumnList;
    }

    ResultColumn bindColumnReference(ColumnReference columnReference) throws StandardException {
        boolean bl = false;
        boolean bl2 = false;
        FromTable fromTable = null;
        FromTable fromTable2 = null;
        int n2 = -1;
        ResultColumn resultColumn = null;
        String string = columnReference.getTableName();
        int n3 = this.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            fromTable = (FromTable)this.elementAt(i2);
            if (fromTable.getMergeTableID() != 0 && columnReference.getMergeTableID() != 0 && fromTable.getMergeTableID() != columnReference.getMergeTableID()) continue;
            int n4 = fromTable.getLevel();
            if (n2 != n4 && (bl || bl2)) break;
            n2 = n4;
            ResultColumn resultColumn2 = fromTable.getMatchingColumn(columnReference);
            if (resultColumn2 != null) {
                if (!bl) {
                    resultColumn = resultColumn2;
                    columnReference.setSource(resultColumn2);
                    columnReference.setNestingLevel(((FromTable)this.elementAt(0)).getLevel());
                    columnReference.setSourceLevel(n4);
                    bl = true;
                    if (fromTable.isPrivilegeCollectionRequired()) {
                        this.getCompilerContext().addRequiredColumnPriv(resultColumn2.getTableColumnDescriptor());
                    }
                    fromTable2 = fromTable;
                } else {
                    throw StandardException.newException("42X03", columnReference.getSQLColumnName());
                }
            }
            bl2 = bl2 || string != null && string.equals(fromTable.getExposedName());
        }
        if (fromTable2 != null && resultColumn != null && columnReference.getTableName() == null) {
            FromBaseTable fromBaseTable;
            TableName tableName = fromTable2.getTableName();
            if (fromTable2 instanceof FromBaseTable && (fromBaseTable = (FromBaseTable)fromTable2).getExposedTableName() != null) {
                tableName = fromBaseTable.getExposedTableName();
            }
            columnReference.setQualifiedTableName(tableName);
        }
        return resultColumn;
    }

    void rejectParameters() throws StandardException {
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            FromTable fromTable = (FromTable)this.elementAt(i2);
            fromTable.rejectParameters();
        }
    }

    boolean LOJ_reorderable(int n2) throws StandardException {
        boolean bl = false;
        if (this.size() > 1) {
            return bl;
        }
        FromTable fromTable = (FromTable)this.elementAt(0);
        bl = fromTable.LOJ_reorderable(n2);
        return bl;
    }

    void preprocess(int n2, GroupByList groupByList, ValueNode valueNode) throws StandardException {
        int n3 = this.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            FromTable fromTable = (FromTable)this.elementAt(i2);
            fromTable = fromTable.transformOuterJoins(valueNode, n2);
            this.setElementAt(fromTable.preprocess(n2, groupByList, this), i2);
        }
    }

    void flattenFromTables(ResultColumnList resultColumnList, PredicateList predicateList, SubqueryList subqueryList, GroupByList groupByList, ValueNode valueNode) throws StandardException {
        QueryTreeNode queryTreeNode;
        FromTable fromTable;
        int n2;
        boolean bl = true;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        while (bl) {
            bl = false;
            for (n2 = 0; n2 < this.size() && !bl; ++n2) {
                fromTable = (FromTable)this.elementAt(n2);
                if (!(fromTable instanceof FromSubquery) && !fromTable.isFlattenableJoinNode()) continue;
                arrayList.add(fromTable.getTableNumber());
                queryTreeNode = fromTable.flatten(resultColumnList, predicateList, subqueryList, groupByList, valueNode);
                if (queryTreeNode != null) {
                    this.setElementAt(((QueryTreeNodeVector)queryTreeNode).elementAt(0), n2);
                    int n3 = ((QueryTreeNodeVector)queryTreeNode).size();
                    for (int i2 = 1; i2 < n3; ++i2) {
                        this.insertElementAt(((QueryTreeNodeVector)queryTreeNode).elementAt(i2), n2 + i2);
                    }
                } else {
                    this.removeElementAt(n2);
                }
                bl = true;
            }
        }
        if (!arrayList.isEmpty()) {
            for (n2 = 0; n2 < this.size(); ++n2) {
                fromTable = (FromTable)this.elementAt(n2);
                if (!(fromTable instanceof ProjectRestrictNode) || !((queryTreeNode = ((ProjectRestrictNode)fromTable).getChildResult()) instanceof FromBaseTable)) continue;
                ((FromBaseTable)queryTreeNode).clearDependency(arrayList);
            }
        }
    }

    void pushPredicates(PredicateList predicateList) throws StandardException {
        predicateList.categorize();
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            FromTable fromTable = (FromTable)this.elementAt(i2);
            fromTable.pushExpressions(predicateList);
        }
    }

    void setLevel(int n2) {
        int n3 = this.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            FromTable fromTable = (FromTable)this.elementAt(i2);
            fromTable.setLevel(n2);
        }
    }

    FromTable getFromTableByResultColumn(ResultColumn resultColumn) {
        FromTable fromTable = null;
        int n2 = this.size();
        for (int i2 = 0; i2 < n2 && (fromTable = (FromTable)this.elementAt(i2)).getResultColumns().indexOf(resultColumn) == -1; ++i2) {
        }
        return fromTable;
    }

    void setProperties(Properties properties) throws StandardException {
        this.properties = properties;
        Enumeration<Object> enumeration = this.properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)this.properties.get(string);
            if (string.equals("joinOrder")) {
                if (StringUtil.SQLEqualsIgnoreCase(string2, "fixed")) {
                    this.fixedJoinOrder = true;
                    continue;
                }
                if (StringUtil.SQLEqualsIgnoreCase(string2, "unfixed")) {
                    this.fixedJoinOrder = false;
                    continue;
                }
                throw StandardException.newException("42X17", string2);
            }
            if (string.equals("useStatistics")) {
                if (StringUtil.SQLEqualsIgnoreCase(string2, "true")) {
                    this.useStatistics = true;
                    continue;
                }
                if (StringUtil.SQLEqualsIgnoreCase(string2, "false")) {
                    this.useStatistics = false;
                    continue;
                }
                throw StandardException.newException("42X64", string2);
            }
            throw StandardException.newException("42X41", string, string2);
        }
    }

    @Override
    public void reOrder(int[] nArray) {
        int n2;
        FromTable[] fromTableArray = new FromTable[nArray.length];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            fromTableArray[n2] = (ResultSetNode)this.elementAt(nArray[n2]);
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            this.setElementAt(fromTableArray[n2], n2);
        }
    }

    @Override
    public boolean useStatistics() {
        return this.useStatistics;
    }

    @Override
    public boolean optimizeJoinOrder() {
        return !this.fixedJoinOrder;
    }

    @Override
    public boolean legalJoinOrder(int n2) {
        JBitSet jBitSet = new JBitSet(n2);
        int n3 = this.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            FromTable fromTable = (FromTable)this.elementAt(i2);
            jBitSet.or(fromTable.getReferencedTableMap());
            if (fromTable.legalJoinOrder(jBitSet)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void initAccessPaths(Optimizer optimizer) {
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            FromTable fromTable = (FromTable)this.elementAt(i2);
            fromTable.initAccessPaths(optimizer);
        }
    }

    void bindUntypedNullsToResultColumns(ResultColumnList resultColumnList) throws StandardException {
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            FromTable fromTable = (FromTable)this.elementAt(i2);
            fromTable.bindUntypedNullsToResultColumns(resultColumnList);
        }
    }

    void decrementLevel(int n2) {
        int n3 = this.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            FromTable fromTable = (FromTable)this.elementAt(i2);
            fromTable.decrementLevel(n2);
            ProjectRestrictNode projectRestrictNode = (ProjectRestrictNode)fromTable;
            PredicateList predicateList = projectRestrictNode.getRestrictionList();
            if (predicateList == null) continue;
            predicateList.decrementLevel(this, n2);
        }
    }

    boolean returnsAtMostSingleRow(ResultColumnList resultColumnList, ValueNode valueNode, PredicateList predicateList, DataDictionary dataDictionary) throws StandardException {
        int n2;
        Object object;
        Object object2;
        boolean bl = false;
        ColumnReference columnReference = null;
        PredicateList predicateList2 = new PredicateList(this.getContextManager());
        Object object3 = predicateList.iterator();
        while (object3.hasNext()) {
            Predicate predicate = (Predicate)object3.next();
            predicateList2.addPredicate(predicate);
        }
        if (resultColumnList != null && ((ResultColumn)(object3 = (ResultColumn)resultColumnList.elementAt(0))).getExpression() instanceof ColumnReference) {
            columnReference = (ColumnReference)((ResultColumn)object3).getExpression();
        }
        int n3 = this.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            object2 = (FromTable)this.elementAt(i2);
            if (!(object2 instanceof ProjectRestrictNode)) {
                return false;
            }
            ProjectRestrictNode projectRestrictNode = (ProjectRestrictNode)object2;
            if (!(projectRestrictNode.getChildResult() instanceof FromBaseTable)) {
                return false;
            }
            FromBaseTable fromBaseTable = (FromBaseTable)projectRestrictNode.getChildResult();
            if (!fromBaseTable.getExistsBaseTable()) continue;
            int n4 = fromBaseTable.getTableNumber();
            block2: for (int i3 = predicateList2.size() - 1; i3 >= 0; --i3) {
                AndNode andNode = ((Predicate)predicateList2.elementAt(i3)).getAndNode();
                object = andNode;
                while (object instanceof AndNode) {
                    JBitSet jBitSet;
                    AndNode andNode2 = (AndNode)object;
                    if (andNode2.getLeftOperand().isRelationalOperator() && ((RelationalOperator)((Object)andNode2.getLeftOperand())).getOperator() == 1 && (jBitSet = andNode2.getLeftOperand().getTablesReferenced()).get(n4)) {
                        predicateList2.removeElementAt(i3);
                        continue block2;
                    }
                    object = ((AndNode)object).getRightOperand();
                }
            }
        }
        int[] nArray = this.getTableNumbers();
        JBitSet[][] jBitSetArray = new JBitSet[n3][n3];
        object2 = new boolean[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            ProjectRestrictNode projectRestrictNode = (ProjectRestrictNode)this.elementAt(n2);
            FromBaseTable fromBaseTable = (FromBaseTable)projectRestrictNode.getChildResult();
            if (fromBaseTable.getExistsBaseTable()) {
                object2[n2] = true;
                continue;
            }
            int n5 = fromBaseTable.getTableDescriptor().getNumberOfColumns();
            object = new boolean[n5 + 1];
            int n6 = fromBaseTable.getTableNumber();
            boolean bl2 = false;
            for (int i4 = 0; i4 < n3; ++i4) {
                jBitSetArray[n2][i4] = new JBitSet(n5 + 1);
            }
            if (columnReference != null && columnReference.getTableNumber() == n6) {
                resultColumnList.recordColumnReferences((boolean[])object, jBitSetArray[n2], n2);
                bl2 = true;
            }
            if (valueNode != null) {
                valueNode.checkTopPredicatesForEqualsConditions(n6, (boolean[])object, nArray, jBitSetArray[n2], bl2);
            }
            predicateList2.checkTopPredicatesForEqualsConditions(n6, (boolean[])object, nArray, jBitSetArray[n2], bl2);
            if (projectRestrictNode.getRestrictionList() != null) {
                projectRestrictNode.getRestrictionList().checkTopPredicatesForEqualsConditions(n6, (boolean[])object, nArray, jBitSetArray[n2], bl2);
            }
            if (!fromBaseTable.supersetOfUniqueIndex(jBitSetArray[n2])) {
                return false;
            }
            boolean bl3 = fromBaseTable.supersetOfUniqueIndex((boolean[])object);
            if (!bl3) continue;
            object2[n2] = true;
            bl = true;
        }
        if (bl) {
            n2 = 1;
            while (n2 != 0) {
                n2 = 0;
                for (int i5 = 0; i5 < n3; ++i5) {
                    if (object2[i5] == false) continue;
                    for (int i6 = 0; i6 < n3; ++i6) {
                        if (object2[i6] != false || !jBitSetArray[i6][i5].get(0)) continue;
                        object2[i6] = true;
                        n2 = 1;
                    }
                }
            }
            for (int i7 = 0; i7 < n3; ++i7) {
                if (object2[i7] != false) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    int[] getTableNumbers() {
        int n2 = this.size();
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            ProjectRestrictNode projectRestrictNode = (ProjectRestrictNode)this.elementAt(i2);
            if (!(projectRestrictNode.getChildResult() instanceof FromTable)) continue;
            FromTable fromTable = (FromTable)projectRestrictNode.getChildResult();
            nArray[i2] = fromTable.getTableNumber();
        }
        return nArray;
    }

    void genExistsBaseTables(JBitSet jBitSet, FromList fromList, boolean bl) throws StandardException {
        int n2;
        JBitSet jBitSet2 = (JBitSet)jBitSet.clone();
        int n3 = this.size();
        for (n2 = 0; n2 < n3; ++n2) {
            ResultSetNode resultSetNode = ((ProjectRestrictNode)this.elementAt(n2)).getChildResult();
            if (!(resultSetNode instanceof FromTable)) continue;
            jBitSet2.clear(((FromTable)resultSetNode).getTableNumber());
        }
        if (jBitSet2.getFirstSetBit() == -1) {
            n2 = fromList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                jBitSet2.or(((FromTable)fromList.elementAt(i2)).getReferencedTableMap());
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            ProjectRestrictNode projectRestrictNode;
            FromTable fromTable = (FromTable)this.elementAt(n2);
            if (!(fromTable instanceof ProjectRestrictNode) || !((projectRestrictNode = (ProjectRestrictNode)fromTable).getChildResult() instanceof FromBaseTable)) continue;
            FromBaseTable fromBaseTable = (FromBaseTable)projectRestrictNode.getChildResult();
            fromBaseTable.setExistsBaseTable(true, (JBitSet)jBitSet2.clone(), bl);
        }
    }

    boolean tableNumberIsNotExists(int n2) throws StandardException {
        int n3 = this.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            FromTable fromTable;
            ProjectRestrictNode projectRestrictNode = (ProjectRestrictNode)this.elementAt(i2);
            if (!(projectRestrictNode.getChildResult() instanceof FromTable) || (fromTable = (FromTable)projectRestrictNode.getChildResult()).getTableNumber() != n2) continue;
            return fromTable.isNotExists();
        }
        return false;
    }

    int updateTargetLockMode() {
        return ((ResultSetNode)this.elementAt(0)).updateTargetLockMode();
    }

    boolean hashJoinSpecified() {
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            FromTable fromTable = (FromTable)this.elementAt(i2);
            String string = fromTable.getUserSpecifiedJoinStrategy();
            if (string == null || !StringUtil.SQLToUpperCase(string).equals("HASH")) continue;
            return true;
        }
        return false;
    }

    void markAsTransparent() {
        this.isTransparent = true;
    }

    void setWindows(WindowList windowList) {
        this.windows = windowList;
    }

    WindowList getWindows() {
        return this.windows;
    }
}

