/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.impl.sql.compile.QueryTreeNode;

public class TableName
extends QueryTreeNode {
    String tableName;
    String schemaName;
    private boolean hasSchema;

    TableName(String string, String string2, ContextManager contextManager) {
        super(contextManager);
        this.hasSchema = string != null;
        this.schemaName = string;
        this.tableName = string2;
    }

    TableName(String string, String string2, int n2, int n3, ContextManager contextManager) {
        this(string, string2, contextManager);
        this.setBeginOffset(n2);
        this.setEndOffset(n3);
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean hasSchema() {
        return this.hasSchema;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    void setSchemaName(String string) {
        this.schemaName = string;
    }

    String getFullTableName() {
        if (this.schemaName != null) {
            return this.schemaName + "." + this.tableName;
        }
        return this.tableName;
    }

    public String getFullSQLName() {
        return IdUtil.mkQualifiedName(this.schemaName, this.tableName);
    }

    @Override
    public String toString() {
        if (this.hasSchema) {
            return this.getFullTableName();
        }
        return this.tableName;
    }

    boolean equals(TableName tableName) {
        if (tableName == null) {
            return false;
        }
        String string = this.getFullTableName();
        if (string == null) {
            return true;
        }
        if (this.schemaName == null || tableName.getSchemaName() == null) {
            return this.tableName.equals(tableName.getTableName());
        }
        return string.equals(tableName.getFullTableName());
    }

    boolean equals(String string, String string2) {
        String string3 = this.getFullTableName();
        if (string3 == null) {
            return true;
        }
        if (this.schemaName == null || string == null) {
            return this.tableName.equals(string2);
        }
        return string3.equals(string + "." + string2);
    }

    public TableName cloneMe() {
        return new TableName(this.schemaName, this.tableName, this.getContextManager());
    }

    void bind() throws StandardException {
        this.schemaName = this.getSchemaDescriptor(this.schemaName).getSchemaName();
    }

    public int hashCode() {
        return this.getFullTableName().hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof TableName)) {
            return false;
        }
        TableName tableName = (TableName)object;
        return this.getFullTableName().equals(tableName.getFullTableName());
    }
}

