/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.TypeCompiler;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.AndNode;
import org.apache.derby.impl.sql.compile.BinaryRelationalOperatorNode;
import org.apache.derby.impl.sql.compile.BooleanConstantNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.IsNullNode;
import org.apache.derby.impl.sql.compile.JavaToSQLValueNode;
import org.apache.derby.impl.sql.compile.JavaValueNode;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.ReferencedTablesVisitor;
import org.apache.derby.impl.sql.compile.RelationalOperator;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.SQLToJavaValueNode;
import org.apache.derby.impl.sql.compile.SubqueryList;

public abstract class ValueNode
extends QueryTreeNode {
    private DataTypeDescriptor dataTypeServices;
    boolean transformed;

    ValueNode(ContextManager contextManager) {
        super(contextManager);
    }

    final void setType(TypeId typeId, boolean bl, int n2) throws StandardException {
        this.setType(new DataTypeDescriptor(typeId, bl, n2));
    }

    final void setType(TypeId typeId, int n2, int n3, boolean bl, int n4) throws StandardException {
        this.setType(new DataTypeDescriptor(typeId, n2, n3, bl, n4));
    }

    @Override
    public String toString() {
        return "";
    }

    DataTypeDescriptor getTypeServices() {
        return this.dataTypeServices;
    }

    public void setNullability(boolean bl) throws StandardException {
        this.setType(this.getTypeServices().getNullabilityType(bl));
    }

    public void setCollationInfo(DataTypeDescriptor dataTypeDescriptor) throws StandardException {
        this.setCollationInfo(dataTypeDescriptor.getCollationType(), dataTypeDescriptor.getCollationDerivation());
    }

    public void setCollationInfo(int n2, int n3) throws StandardException {
        this.setType(this.getTypeServices().getCollatedType(n2, n3));
    }

    TypeId getTypeId() throws StandardException {
        DataTypeDescriptor dataTypeDescriptor = this.getTypeServices();
        if (dataTypeDescriptor != null) {
            return dataTypeDescriptor.getTypeId();
        }
        return null;
    }

    protected final DataValueFactory getDataValueFactory() {
        return this.getLanguageConnectionContext().getDataValueFactory();
    }

    final TypeCompiler getTypeCompiler() throws StandardException {
        return this.getTypeCompiler(this.getTypeId());
    }

    void setType(DataTypeDescriptor dataTypeDescriptor) throws StandardException {
        if (dataTypeDescriptor != null) {
            dataTypeDescriptor = this.bindUserType(dataTypeDescriptor);
        }
        this.dataTypeServices = dataTypeDescriptor;
        if (dataTypeDescriptor != null) {
            this.createTypeDependency(dataTypeDescriptor);
        }
    }

    protected final void setCollationUsingCompilationSchema() throws StandardException {
        this.setCollationUsingCompilationSchema(1);
    }

    protected final void setCollationUsingCompilationSchema(int n2) throws StandardException {
        this.setCollationInfo(this.getSchemaDescriptor(null, false).getCollationType(), n2);
    }

    ResultColumn getSourceResultColumn() {
        return null;
    }

    void setTransformed() {
        this.transformed = true;
    }

    boolean getTransformed() {
        return this.transformed;
    }

    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> list) throws StandardException {
        return this.bindExpression(fromList, subqueryList, list, false);
    }

    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> list, boolean bl) throws StandardException {
        return this;
    }

    ValueNode genSQLJavaSQLTree() throws StandardException {
        ContextManager contextManager = this.getContextManager();
        SQLToJavaValueNode sQLToJavaValueNode = new SQLToJavaValueNode(this, contextManager);
        JavaToSQLValueNode javaToSQLValueNode = new JavaToSQLValueNode(sQLToJavaValueNode, contextManager);
        DataTypeDescriptor dataTypeDescriptor = this.getTypeServices() != null && this.getTypeId().userType() ? this.getTypeServices() : DataTypeDescriptor.getSQLDataTypeDescriptor(((JavaValueNode)sQLToJavaValueNode).getJavaTypeName());
        javaToSQLValueNode.setType(dataTypeDescriptor);
        return javaToSQLValueNode;
    }

    ValueNode preprocess(int n2, FromList fromList, SubqueryList subqueryList, PredicateList predicateList) throws StandardException {
        return this;
    }

    ValueNode evaluateConstantExpressions() throws StandardException {
        return this;
    }

    ValueNode eliminateNots(boolean bl) throws StandardException {
        if (!bl) {
            return this;
        }
        return this.genEqualsFalseTree();
    }

    ValueNode genEqualsFalseTree() throws StandardException {
        BooleanConstantNode booleanConstantNode = new BooleanConstantNode(false, this.getContextManager());
        BinaryRelationalOperatorNode binaryRelationalOperatorNode = new BinaryRelationalOperatorNode(0, this, booleanConstantNode, false, this.getContextManager());
        boolean bl = this.getTypeServices().isNullable();
        binaryRelationalOperatorNode.setType(new DataTypeDescriptor(TypeId.BOOLEAN_ID, bl));
        return binaryRelationalOperatorNode;
    }

    ValueNode genIsNullTree(boolean bl) throws StandardException {
        IsNullNode isNullNode = new IsNullNode(this, bl, this.getContextManager());
        isNullNode.setType(new DataTypeDescriptor(TypeId.BOOLEAN_ID, false));
        return isNullNode;
    }

    boolean verifyEliminateNots() {
        return true;
    }

    ValueNode putAndsOnTop() throws StandardException {
        BooleanConstantNode booleanConstantNode = new BooleanConstantNode(true, this.getContextManager());
        AndNode andNode = new AndNode(this, booleanConstantNode, this.getContextManager());
        andNode.postBindFixup();
        return andNode;
    }

    boolean verifyPutAndsOnTop() {
        return true;
    }

    ValueNode changeToCNF(boolean bl) throws StandardException {
        return this;
    }

    boolean verifyChangeToCNF() {
        return true;
    }

    boolean categorize(JBitSet jBitSet, boolean bl) throws StandardException {
        return true;
    }

    String getSchemaName() throws StandardException {
        return null;
    }

    String getTableName() {
        return null;
    }

    public boolean updatableByCursor() {
        return false;
    }

    String getColumnName() {
        return null;
    }

    JBitSet getTablesReferenced() throws StandardException {
        ReferencedTablesVisitor referencedTablesVisitor = new ReferencedTablesVisitor(new JBitSet(0));
        this.accept(referencedTablesVisitor);
        return referencedTablesVisitor.getTableMap();
    }

    boolean isCloneable() {
        return false;
    }

    ValueNode getClone() throws StandardException {
        return null;
    }

    void copyFields(ValueNode valueNode) throws StandardException {
        this.dataTypeServices = valueNode.getTypeServices();
    }

    ValueNode remapColumnReferencesToExpressions() throws StandardException {
        return this;
    }

    boolean isConstantExpression() {
        return false;
    }

    boolean constantExpression(PredicateList predicateList) {
        return false;
    }

    protected int getOrderableVariantType() throws StandardException {
        return 0;
    }

    public ValueNode checkIsBoolean() throws StandardException {
        ValueNode valueNode = this;
        TypeId typeId = valueNode.getTypeId();
        if (typeId.userType()) {
            valueNode = valueNode.genSQLJavaSQLTree();
            typeId = valueNode.getTypeId();
        }
        if (!typeId.equals(TypeId.BOOLEAN_ID)) {
            throw StandardException.newException("42X19.S.1", typeId.getSQLTypeName());
        }
        return valueNode;
    }

    Object getConstantValueAsObject() throws StandardException {
        return null;
    }

    @Override
    final void generate(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        this.generateExpression(activationClassBuilder, methodBuilder);
    }

    public double selectivity(Optimizable optimizable) throws StandardException {
        if (this.transformed) {
            return 1.0;
        }
        return 0.5;
    }

    void checkTopPredicatesForEqualsConditions(int n2, boolean[] blArray, int[] nArray, JBitSet[] jBitSetArray, boolean bl) throws StandardException {
        ValueNode valueNode = this;
        while (valueNode instanceof AndNode) {
            AndNode andNode = (AndNode)valueNode;
            if (andNode.getLeftOperand().isRelationalOperator() && ((RelationalOperator)((Object)andNode.getLeftOperand())).getOperator() == 1) {
                int n3;
                BinaryRelationalOperatorNode binaryRelationalOperatorNode = (BinaryRelationalOperatorNode)andNode.getLeftOperand();
                ValueNode valueNode2 = binaryRelationalOperatorNode.getLeftOperand();
                ValueNode valueNode3 = binaryRelationalOperatorNode.getRightOperand();
                if (bl) {
                    for (n3 = 0; n3 < nArray.length && nArray[n3] != n2; ++n3) {
                    }
                } else {
                    n3 = -1;
                }
                if (valueNode2 instanceof ColumnReference && ((ColumnReference)valueNode2).getTableNumber() == n2) {
                    this.updateMaps(jBitSetArray, blArray, nArray, n2, n3, valueNode3, valueNode2);
                } else if (valueNode3 instanceof ColumnReference && ((ColumnReference)valueNode3).getTableNumber() == n2) {
                    this.updateMaps(jBitSetArray, blArray, nArray, n2, n3, valueNode2, valueNode3);
                }
            }
            valueNode = ((AndNode)valueNode).getRightOperand();
        }
    }

    boolean isBooleanTrue() {
        return false;
    }

    boolean isBooleanFalse() {
        return false;
    }

    void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
    }

    private void updateMaps(JBitSet[] jBitSetArray, boolean[] blArray, int[] nArray, int n2, int n3, ValueNode valueNode, ValueNode valueNode2) throws StandardException {
        if (valueNode instanceof ConstantNode || valueNode.requiresTypeFromContext()) {
            this.setValueCols(jBitSetArray, blArray, ((ColumnReference)valueNode2).getColumnNumber(), n3);
        } else if (valueNode instanceof ColumnReference && ((ColumnReference)valueNode).getTableNumber() != n2) {
            int n4;
            int n5 = ((ColumnReference)valueNode).getTableNumber();
            int n6 = ((ColumnReference)valueNode2).getColumnNumber();
            for (n4 = 0; n4 < nArray.length && n5 != nArray[n4]; ++n4) {
            }
            if (n4 == nArray.length) {
                this.setValueCols(jBitSetArray, blArray, n6, n3);
            } else if (jBitSetArray != null) {
                jBitSetArray[n4].set(n6);
            }
        } else {
            int n7;
            JBitSet jBitSet = valueNode.getTablesReferenced();
            int n8 = ((ColumnReference)valueNode2).getColumnNumber();
            for (n7 = 0; n7 < nArray.length && !jBitSet.get(nArray[n7]); ++n7) {
            }
            if (n7 == nArray.length) {
                this.setValueCols(jBitSetArray, blArray, n8, n3);
            } else if (jBitSetArray != null && !jBitSet.get(n2)) {
                jBitSetArray[n7].set(n8);
            }
        }
    }

    private void setValueCols(JBitSet[] jBitSetArray, boolean[] blArray, int n2, int n3) {
        if (blArray != null) {
            blArray[n2] = true;
        }
        if (jBitSetArray != null) {
            if (n3 == -1) {
                for (int i2 = 0; i2 < jBitSetArray.length; ++i2) {
                    jBitSetArray[i2].set(n2);
                }
            } else {
                jBitSetArray[n3].set(n2);
            }
        }
    }

    boolean isRelationalOperator() {
        return false;
    }

    boolean isBinaryEqualsOperatorNode() {
        return false;
    }

    boolean isInListProbeNode() {
        return false;
    }

    boolean optimizableEqualityNode(Optimizable optimizable, int n2, boolean bl) throws StandardException {
        return false;
    }

    boolean requiresTypeFromContext() {
        return false;
    }

    boolean isParameterNode() {
        return false;
    }

    abstract boolean isEquivalent(ValueNode var1) throws StandardException;

    boolean isSameNodeKind(ValueNode valueNode) {
        return valueNode != null && valueNode.getClass().equals(this.getClass());
    }
}

