/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.UnaryOperatorNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.WindowDefinitionNode;
import org.apache.derby.impl.sql.compile.WindowList;
import org.apache.derby.impl.sql.compile.WindowNode;
import org.apache.derby.impl.sql.compile.WindowReferenceNode;

public abstract class WindowFunctionNode
extends UnaryOperatorNode {
    private WindowNode window;
    private ResultColumn generatedRC;
    private ColumnReference generatedRef;

    WindowFunctionNode(ValueNode valueNode, String string, WindowNode windowNode, ContextManager contextManager) throws StandardException {
        super(valueNode, string, null, contextManager);
        this.window = windowNode;
    }

    @Override
    public boolean isConstantExpression() {
        return false;
    }

    @Override
    boolean constantExpression(PredicateList predicateList) {
        return false;
    }

    WindowNode getWindow() {
        return this.window;
    }

    void setWindow(WindowDefinitionNode windowDefinitionNode) {
        this.window = windowDefinitionNode;
    }

    @Override
    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> list) throws StandardException {
        if (this.window instanceof WindowReferenceNode) {
            WindowDefinitionNode windowDefinitionNode = this.definedWindow(fromList.getWindows(), this.window.getName());
            if (windowDefinitionNode != null) {
                this.window = windowDefinitionNode;
            } else {
                throw StandardException.newException("42ZC0", this.window.getName());
            }
        }
        return this;
    }

    private WindowDefinitionNode definedWindow(WindowList windowList, String string) {
        for (WindowDefinitionNode windowDefinitionNode : windowList) {
            if (!windowDefinitionNode.getName().equals(string)) continue;
            return windowDefinitionNode;
        }
        return null;
    }

    @Override
    public void printSubNodes(int n2) {
    }

    ValueNode replaceCallsWithColumnReferences(ResultColumnList resultColumnList, int n2) throws StandardException {
        if (this.generatedRef == null) {
            CompilerContext compilerContext = this.getCompilerContext();
            String string = "SQLCol" + compilerContext.getNextColumnNumber();
            this.generatedRC = new ResultColumn(string, (ValueNode)this, this.getContextManager());
            this.generatedRC.markGenerated();
            this.generatedRef = new ColumnReference(this.generatedRC.getName(), null, this.getContextManager());
            this.generatedRef.setSource(this.generatedRC);
            this.generatedRef.setNestingLevel(0);
            this.generatedRef.setSourceLevel(0);
            if (n2 != -1) {
                this.generatedRef.setTableNumber(n2);
            }
            resultColumnList.addResultColumn(this.generatedRC);
            this.generatedRef.markGeneratedToReplaceWindowFunctionCall();
        } else {
            resultColumnList.addResultColumn(this.generatedRC);
        }
        return this.generatedRef;
    }

    ColumnReference getGeneratedRef() {
        return this.generatedRef;
    }

    ValueNode getNewNullResultExpression() throws StandardException {
        return this.getNullNode(this.getTypeServices());
    }
}

