/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.depend.ProviderInfo;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.dictionary.ViewDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.ColumnInfo;
import org.apache.derby.impl.sql.execute.DDLConstantAction;

class CreateViewConstantAction
extends DDLConstantAction {
    private final String tableName;
    private final String schemaName;
    private final String viewText;
    private final int tableType;
    private final int checkOption;
    private final ColumnInfo[] columnInfo;
    private final ProviderInfo[] providerInfo;
    private final UUID compSchemaId;

    CreateViewConstantAction(String string, String string2, int n2, String string3, int n3, ColumnInfo[] columnInfoArray, ProviderInfo[] providerInfoArray, UUID uUID) {
        this.schemaName = string;
        this.tableName = string2;
        this.tableType = n2;
        this.viewText = string3;
        this.checkOption = n3;
        this.columnInfo = columnInfoArray;
        this.providerInfo = providerInfoArray;
        this.compSchemaId = uUID;
    }

    public String toString() {
        return this.constructToString("CREATE VIEW ", this.tableName);
    }

    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        int n2;
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        DependencyManager dependencyManager = dataDictionary.getDependencyManager();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        dataDictionary.startWriting(languageConnectionContext);
        SchemaDescriptor schemaDescriptor = DDLConstantAction.getSchemaDescriptorForCreate(dataDictionary, activation, this.schemaName);
        DataDescriptorGenerator dataDescriptorGenerator = dataDictionary.getDataDescriptorGenerator();
        TableDescriptor tableDescriptor = dataDescriptorGenerator.newTableDescriptor(this.tableName, schemaDescriptor, this.tableType, 'R');
        dataDictionary.addDescriptor(tableDescriptor, schemaDescriptor, 1, false, transactionController);
        UUID uUID = tableDescriptor.getUUID();
        TupleDescriptor[] tupleDescriptorArray = new ColumnDescriptor[this.columnInfo.length];
        int n3 = 1;
        for (int i2 = 0; i2 < this.columnInfo.length; ++i2) {
            ColumnDescriptor columnDescriptor = new ColumnDescriptor(this.columnInfo[i2].name, n3++, this.columnInfo[i2].dataType, this.columnInfo[i2].defaultValue, this.columnInfo[i2].defaultInfo, tableDescriptor, null, this.columnInfo[i2].autoincStart, this.columnInfo[i2].autoincInc, this.columnInfo[i2].autoincCycle);
            tupleDescriptorArray[i2] = columnDescriptor;
        }
        dataDictionary.addDescriptorArray(tupleDescriptorArray, tableDescriptor, 2, false, transactionController);
        ColumnDescriptorList columnDescriptorList = tableDescriptor.getColumnDescriptorList();
        for (n2 = 0; n2 < tupleDescriptorArray.length; ++n2) {
            columnDescriptorList.add(tupleDescriptorArray[n2]);
        }
        ViewDescriptor viewDescriptor = dataDescriptorGenerator.newViewDescriptor(uUID, this.tableName, this.viewText, this.checkOption, this.compSchemaId == null ? languageConnectionContext.getDefaultSchema().getUUID() : this.compSchemaId);
        for (n2 = 0; n2 < this.providerInfo.length; ++n2) {
            Provider provider = (Provider)this.providerInfo[n2].getDependableFinder().getDependable(dataDictionary, this.providerInfo[n2].getObjectId());
            dependencyManager.addDependency(viewDescriptor, provider, languageConnectionContext.getContextManager());
        }
        this.storeViewTriggerDependenciesOnPrivileges(activation, viewDescriptor);
        dataDictionary.addDescriptor(viewDescriptor, schemaDescriptor, 8, true, transactionController);
    }
}

