/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.ForeignKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ReferencedKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.ConstraintConstantAction;
import org.apache.derby.impl.sql.execute.IndexConstantAction;

public class DropConstraintConstantAction
extends ConstraintConstantAction {
    private boolean cascade;
    private String constraintSchemaName;
    private int verifyType;

    DropConstraintConstantAction(String string, String string2, String string3, UUID uUID, String string4, IndexConstantAction indexConstantAction, int n2, int n3) {
        super(string, 5, string3, uUID, string4, indexConstantAction);
        this.cascade = n2 == 0;
        this.constraintSchemaName = string2;
        this.verifyType = n3;
    }

    public String toString() {
        if (this.constraintName == null) {
            return "DROP PRIMARY KEY";
        }
        String string = this.constraintSchemaName == null ? this.schemaName : this.constraintSchemaName;
        return "DROP CONSTRAINT " + string + "." + this.constraintName;
    }

    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        boolean bl;
        ConstraintDescriptor constraintDescriptor = null;
        Object var4_3 = null;
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        DependencyManager dependencyManager = dataDictionary.getDependencyManager();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        dataDictionary.startWriting(languageConnectionContext);
        TableDescriptor tableDescriptor = dataDictionary.getTableDescriptor(this.tableId);
        if (tableDescriptor == null) {
            throw StandardException.newException("X0X05.S", this.tableName);
        }
        SchemaDescriptor schemaDescriptor = tableDescriptor.getSchemaDescriptor();
        SchemaDescriptor schemaDescriptor2 = this.constraintSchemaName == null ? schemaDescriptor : dataDictionary.getSchemaDescriptor(this.constraintSchemaName, transactionController, true);
        constraintDescriptor = this.constraintName == null ? dataDictionary.getConstraintDescriptors(tableDescriptor).getPrimaryKey() : dataDictionary.getConstraintDescriptorByName(tableDescriptor, schemaDescriptor2, this.constraintName, true);
        if (constraintDescriptor == null) {
            String string = this.constraintName == null ? "PRIMARY KEY" : schemaDescriptor2.getSchemaName() + "." + this.constraintName;
            throw StandardException.newException("42X86", string, tableDescriptor.getQualifiedName());
        }
        switch (this.verifyType) {
            case 3: {
                if (constraintDescriptor.getConstraintType() == this.verifyType) break;
                throw StandardException.newException("42Z9E", this.constraintName, "UNIQUE");
            }
            case 4: {
                if (constraintDescriptor.getConstraintType() == this.verifyType) break;
                throw StandardException.newException("42Z9E", this.constraintName, "CHECK");
            }
            case 6: {
                if (constraintDescriptor.getConstraintType() == this.verifyType) break;
                throw StandardException.newException("42Z9E", this.constraintName, "FOREIGN KEY");
            }
        }
        boolean bl2 = bl = this.cascade && constraintDescriptor instanceof ReferencedKeyConstraintDescriptor;
        if (!bl) {
            dependencyManager.invalidateFor(constraintDescriptor, 19, languageConnectionContext);
        }
        this.dropConstraint(constraintDescriptor, activation, languageConnectionContext, !bl);
        if (bl) {
            ReferencedKeyConstraintDescriptor referencedKeyConstraintDescriptor = (ReferencedKeyConstraintDescriptor)constraintDescriptor;
            ConstraintDescriptorList constraintDescriptorList = referencedKeyConstraintDescriptor.getForeignKeyConstraints(3);
            int n2 = constraintDescriptorList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                ForeignKeyConstraintDescriptor foreignKeyConstraintDescriptor = (ForeignKeyConstraintDescriptor)constraintDescriptorList.elementAt(i2);
                dependencyManager.invalidateFor(foreignKeyConstraintDescriptor, 19, languageConnectionContext);
                this.dropConstraint(foreignKeyConstraintDescriptor, activation, languageConnectionContext, true);
            }
            dependencyManager.invalidateFor(constraintDescriptor, 19, languageConnectionContext);
            dependencyManager.clearDependencies(languageConnectionContext, constraintDescriptor);
        }
    }
}

