/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.catalog.types.ReferencedColumnsDescriptorImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecRowBuilder;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.DynamicCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.GenericPreparedStatement;
import org.apache.derby.impl.sql.execute.NoPutResultSetImpl;

class IndexRowToBaseRowResultSet
extends NoPutResultSetImpl
implements CursorResultSet {
    public NoPutResultSet source;
    private GeneratedMethod restriction;
    public FormatableBitSet accessedHeapCols;
    private FormatableBitSet accessedAllCols;
    public String indexName;
    private int[] indexCols;
    private DynamicCompiledOpenConglomInfo dcoci;
    private StaticCompiledOpenConglomInfo scoci;
    private ConglomerateController baseCC;
    private boolean closeBaseCCHere;
    private boolean forUpdate;
    private DataValueDescriptor[] rowArray;
    RowLocation baseRowLocation;
    boolean copiedFromSource;
    public long restrictionTime;
    private int _baseColumnCount;
    private boolean _includeRowLocation;
    private FormatableBitSet _heapColsWithoutRowLocation;

    IndexRowToBaseRowResultSet(long l2, int n2, Activation activation, NoPutResultSet noPutResultSet, int n3, int n4, String string, int n5, int n6, int n7, int n8, GeneratedMethod generatedMethod, boolean bl, double d2, double d3, int n9) throws StandardException {
        super(activation, n4, d2, d3);
        GenericPreparedStatement genericPreparedStatement = (GenericPreparedStatement)activation.getPreparedStatement();
        this.scoci = (StaticCompiledOpenConglomInfo)genericPreparedStatement.getSavedObject(n2);
        TransactionController transactionController = this.activation.getTransactionController();
        this.dcoci = transactionController.getDynamicCompiledConglomInfo(l2);
        this.source = noPutResultSet;
        this.indexName = string;
        this.forUpdate = bl;
        this.restriction = generatedMethod;
        this._baseColumnCount = n9;
        if (n5 != -1) {
            this.accessedHeapCols = (FormatableBitSet)genericPreparedStatement.getSavedObject(n5);
        }
        if (n6 != -1) {
            this.accessedAllCols = (FormatableBitSet)genericPreparedStatement.getSavedObject(n6);
        }
        this.indexCols = ((ReferencedColumnsDescriptorImpl)genericPreparedStatement.getSavedObject(n8)).getReferencedColumnPositions();
        ExecRow execRow = ((ExecRowBuilder)genericPreparedStatement.getSavedObject(n3)).build(activation.getExecutionFactory());
        this.getCompactRow(execRow, this.accessedAllCols, false);
        if (this.accessedHeapCols == null) {
            this.rowArray = execRow.getRowArray();
        } else {
            DataValueDescriptor[] dataValueDescriptorArray = execRow.getRowArray();
            FormatableBitSet formatableBitSet = (FormatableBitSet)genericPreparedStatement.getSavedObject(n7);
            int n10 = formatableBitSet.getLength();
            this.rowArray = new DataValueDescriptor[n10];
            int n11 = Math.min(dataValueDescriptorArray.length, n10);
            for (int i2 = 0; i2 < n11; ++i2) {
                if (dataValueDescriptorArray[i2] == null || !formatableBitSet.isSet(i2)) continue;
                this.rowArray[i2] = dataValueDescriptorArray[i2];
            }
        }
        boolean bl2 = this._includeRowLocation = this._baseColumnCount < this.accessedHeapCols.getLength();
        if (this._includeRowLocation) {
            this._heapColsWithoutRowLocation = (FormatableBitSet)this.accessedHeapCols.clone();
            this._heapColsWithoutRowLocation.clear(this.accessedHeapCols.getLength() - 1);
        }
        this.recordConstructorTime();
    }

    @Override
    public void openCore() throws StandardException {
        boolean bl = false;
        this.beginTime = this.getCurrentTimeMillis();
        this.source.openCore();
        if (this.source.requiresRelocking()) {
            bl = true;
        }
        TransactionController transactionController = this.activation.getTransactionController();
        int n2 = this.forUpdate ? 4 : 0;
        int n3 = this.source.getScanIsolationLevel();
        if (!bl) {
            n2 |= 0x2000;
        }
        if (this.forUpdate) {
            this.baseCC = this.activation.getHeapConglomerateController();
        }
        if (this.baseCC == null) {
            this.baseCC = transactionController.openCompiledConglomerate(this.activation.getResultSetHoldability(), n2, 6, n3, this.scoci, this.dcoci);
            this.closeBaseCCHere = true;
        }
        this.isOpen = true;
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    @Override
    public void reopenCore() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        this.source.reopenCore();
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        if (this.isXplainOnlyMode()) {
            return null;
        }
        ExecRow execRow = null;
        ExecRow execRow2 = null;
        boolean bl = false;
        long l2 = 0L;
        this.beginTime = this.getCurrentTimeMillis();
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S", "next");
        }
        do {
            if ((execRow = this.source.getNextRowCore()) != null) {
                this.baseRowLocation = (RowLocation)execRow.getColumn(execRow.nColumns());
                boolean bl2 = this.baseCC.fetch(this.baseRowLocation, this.rowArray, this._includeRowLocation ? this._heapColsWithoutRowLocation : this.accessedHeapCols);
                if (bl2) {
                    if (!this.copiedFromSource) {
                        this.copiedFromSource = true;
                        for (int i2 = 0; i2 < this.indexCols.length; ++i2) {
                            if (this.indexCols[i2] == -1) continue;
                            this.compactRow.setColumn(i2 + 1, execRow.getColumn(this.indexCols[i2] + 1));
                        }
                    }
                    this.setCurrentRow(this.compactRow);
                    DataValueDescriptor dataValueDescriptor = (DataValueDescriptor)(this.restriction == null ? null : this.restriction.invoke(this.activation));
                    this.restrictionTime += this.getElapsedMillis(l2);
                    boolean bl3 = bl = dataValueDescriptor == null || !dataValueDescriptor.isNull() && dataValueDescriptor.getBoolean();
                }
                if (!bl || !bl2) {
                    ++this.rowsFiltered;
                    this.clearCurrentRow();
                    this.baseRowLocation = null;
                } else {
                    this.currentRow = this.compactRow;
                }
                if (this._includeRowLocation) {
                    this.currentRow.setColumn(this.currentRow.nColumns(), this.baseRowLocation);
                }
                ++this.rowsSeen;
                execRow2 = this.currentRow;
                continue;
            }
            this.clearCurrentRow();
            this.baseRowLocation = null;
            execRow2 = null;
        } while (execRow != null && !bl);
        this.nextTime += this.getElapsedMillis(this.beginTime);
        return execRow2;
    }

    @Override
    public void close() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            this.clearCurrentRow();
            if (this.closeBaseCCHere && this.baseCC != null) {
                this.baseCC.close();
            }
            this.baseCC = null;
            this.source.close();
            super.close();
        }
        this.closeTime += this.getElapsedMillis(this.beginTime);
    }

    @Override
    public long getTimeSpent(int n2) {
        long l2 = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        if (n2 == 0) {
            return l2 - this.source.getTimeSpent(1);
        }
        return l2;
    }

    @Override
    public RowLocation getRowLocation() throws StandardException {
        return this.baseRowLocation;
    }

    @Override
    public void positionScanAtRowLocation(RowLocation rowLocation) throws StandardException {
        this.baseRowLocation = rowLocation;
        this.source.positionScanAtRowLocation(rowLocation);
    }

    @Override
    public ExecRow getCurrentRow() throws StandardException {
        ExecRow execRow = null;
        if (this.currentRow == null) {
            return null;
        }
        execRow = this.activation.getExecutionFactory().getValueRow(this.indexCols.length);
        execRow.setRowArray(this.rowArray);
        boolean bl = this.baseCC.fetch(this.baseRowLocation, this.rowArray, null);
        if (bl) {
            this.setCurrentRow(execRow);
        } else {
            this.clearCurrentRow();
        }
        return this.currentRow;
    }

    @Override
    public boolean isForUpdate() {
        return this.source.isForUpdate();
    }
}

