/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.sql.execute.NestedLoopJoinResultSet;

class NestedLoopLeftOuterJoinResultSet
extends NestedLoopJoinResultSet {
    protected GeneratedMethod emptyRowFun;
    private boolean wasRightOuterJoin;
    private boolean matchRight = false;
    private boolean returnedEmptyRight = false;
    private ExecRow rightEmptyRow = null;
    public int emptyRightRowsReturned = 0;

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        if (this.isXplainOnlyMode()) {
            return null;
        }
        ExecRow execRow = null;
        boolean bl = false;
        boolean bl2 = false;
        this.beginTime = this.getCurrentTimeMillis();
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S", "next");
        }
        if (this.returnedEmptyRight) {
            this.leftRow = this.leftResultSet.getNextRowCore();
            if (this.leftRow == null) {
                this.closeRight();
            } else {
                ++this.rowsSeenLeft;
                this.openRight();
            }
            this.returnedEmptyRight = false;
        }
        while (this.leftRow != null && !bl) {
            this.rightRow = this.rightResultSet.getNextRowCore();
            if (this.rightRow == null) {
                if (!this.matchRight) {
                    bl = true;
                    this.returnedEmptyRight = true;
                    if (this.rightEmptyRow == null) {
                        this.rightEmptyRow = (ExecRow)this.emptyRowFun.invoke(this.activation);
                    }
                    this.getMergedRow(this.leftRow, this.rightEmptyRow);
                    ++this.emptyRightRowsReturned;
                    continue;
                }
                this.matchRight = false;
                this.leftRow = this.leftResultSet.getNextRowCore();
                if (this.leftRow == null) {
                    this.closeRight();
                    continue;
                }
                ++this.rowsSeenLeft;
                this.openRight();
                continue;
            }
            ++this.rowsSeenRight;
            if (this.restriction != null) {
                DataValueDescriptor dataValueDescriptor = (DataValueDescriptor)this.restriction.invoke(this.activation);
                boolean bl3 = bl2 = !dataValueDescriptor.isNull() && dataValueDescriptor.getBoolean();
                if (!bl2) {
                    ++this.rowsFiltered;
                    continue;
                }
            }
            this.matchRight = true;
            this.getMergedRow(this.leftRow, this.rightRow);
            bl = true;
        }
        if (bl) {
            execRow = this.mergedRow;
            this.setCurrentRow(this.mergedRow);
            ++this.rowsReturned;
        } else {
            this.clearCurrentRow();
        }
        this.nextTime += this.getElapsedMillis(this.beginTime);
        return execRow;
    }

    protected void getMergedRow(ExecRow execRow, ExecRow execRow2) throws StandardException {
        int n2;
        int n3;
        Object object;
        if (this.wasRightOuterJoin) {
            object = execRow;
            execRow = execRow2;
            execRow2 = object;
            n3 = this.rightNumCols;
            n2 = this.leftNumCols;
        } else {
            n3 = this.leftNumCols;
            n2 = this.rightNumCols;
        }
        if (this.mergedRow == null) {
            this.mergedRow = this.getExecutionFactory().getValueRow(n3 + n2);
        }
        int n4 = 1;
        int n5 = 1;
        while (n4 <= n3) {
            object = execRow.getColumn(n4);
            if (object != null && object.hasStream()) {
                object = object.cloneValue(false);
            }
            this.mergedRow.setColumn(n5, (DataValueDescriptor)object);
            ++n4;
            ++n5;
        }
        n4 = 1;
        while (n4 <= n2) {
            object = execRow2.getColumn(n4);
            if (object != null && object.hasStream()) {
                object = object.cloneValue(false);
            }
            this.mergedRow.setColumn(n5, (DataValueDescriptor)object);
            ++n4;
            ++n5;
        }
    }

    @Override
    void clearScanState() {
        this.matchRight = false;
        this.returnedEmptyRight = false;
        this.rightEmptyRow = null;
        this.emptyRightRowsReturned = 0;
        super.clearScanState();
    }

    NestedLoopLeftOuterJoinResultSet(NoPutResultSet noPutResultSet, int n2, NoPutResultSet noPutResultSet2, int n3, Activation activation, GeneratedMethod generatedMethod, int n4, GeneratedMethod generatedMethod2, boolean bl, boolean bl2, boolean bl3, double d2, double d3, String string) {
        super(noPutResultSet, n2, noPutResultSet2, n3, activation, generatedMethod, n4, bl2, bl3, d2, d3, string);
        this.emptyRowFun = generatedMethod2;
        this.wasRightOuterJoin = bl;
    }
}

