/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.sql.execute.RowChanger;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.NoPutResultSetImpl;

class NormalizeResultSet
extends NoPutResultSetImpl
implements CursorResultSet {
    public NoPutResultSet source;
    private ExecRow normalizedRow;
    private int numCols;
    private int startCol;
    private final DataValueDescriptor[] cachedDestinations;
    private ResultDescription resultDescription;
    private DataTypeDescriptor[] desiredTypes;

    public NormalizeResultSet(NoPutResultSet noPutResultSet, Activation activation, int n2, int n3, double d2, double d3, boolean bl) throws StandardException {
        super(activation, n2, d2, d3);
        this.source = noPutResultSet;
        this.resultDescription = (ResultDescription)activation.getPreparedStatement().getSavedObject(n3);
        this.numCols = this.resultDescription.getColumnCount();
        this.startCol = NormalizeResultSet.computeStartColumn(bl, this.resultDescription);
        this.normalizedRow = activation.getExecutionFactory().getValueRow(this.numCols);
        this.cachedDestinations = new DataValueDescriptor[this.numCols];
        this.recordConstructorTime();
    }

    @Override
    public void openCore() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        this.source.openCore();
        this.isOpen = true;
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    @Override
    public void reopenCore() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        this.source.reopenCore();
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        if (this.isXplainOnlyMode()) {
            return null;
        }
        ExecRow execRow = null;
        ExecRow execRow2 = null;
        this.beginTime = this.getCurrentTimeMillis();
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S", "next");
        }
        execRow = this.source.getNextRowCore();
        if (execRow != null) {
            execRow2 = this.normalizeRow(execRow);
            ++this.rowsSeen;
        }
        this.setCurrentRow(execRow2);
        this.nextTime += this.getElapsedMillis(this.beginTime);
        return execRow2;
    }

    @Override
    public void close() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            this.currentRow = null;
            this.source.close();
            super.close();
        }
        this.closeTime += this.getElapsedMillis(this.beginTime);
    }

    @Override
    public long getTimeSpent(int n2) {
        long l2 = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        if (n2 == 0) {
            return l2 - this.source.getTimeSpent(1);
        }
        return l2;
    }

    @Override
    public RowLocation getRowLocation() throws StandardException {
        return ((CursorResultSet)((Object)this.source)).getRowLocation();
    }

    @Override
    public ExecRow getCurrentRow() {
        return this.currentRow;
    }

    public static int computeStartColumn(boolean bl, ResultDescription resultDescription) {
        int n2 = resultDescription.getColumnCount();
        return bl ? (n2 - 1) / 2 + 1 : 1;
    }

    public static DataValueDescriptor normalizeColumn(DataTypeDescriptor dataTypeDescriptor, ExecRow execRow, int n2, DataValueDescriptor dataValueDescriptor, ResultDescription resultDescription) throws StandardException {
        DataValueDescriptor dataValueDescriptor2 = execRow.getColumn(n2);
        try {
            DataValueDescriptor dataValueDescriptor3 = dataTypeDescriptor.normalize(dataValueDescriptor2, dataValueDescriptor);
            return dataValueDescriptor3;
        }
        catch (StandardException standardException) {
            if (standardException.getMessageId().startsWith("23502")) {
                ResultColumnDescriptor resultColumnDescriptor = resultDescription.getColumnDescriptor(n2);
                throw StandardException.newException("23502", resultColumnDescriptor.getName());
            }
            throw standardException;
        }
    }

    private ExecRow normalizeRow(ExecRow execRow) throws StandardException {
        int n2 = this.resultDescription.getColumnCount();
        for (int i2 = 1; i2 <= n2; ++i2) {
            DataValueDescriptor dataValueDescriptor = execRow.getColumn(i2);
            if (dataValueDescriptor == null) continue;
            DataValueDescriptor dataValueDescriptor2 = i2 < this.startCol ? dataValueDescriptor : NormalizeResultSet.normalizeColumn(this.getDesiredType(i2), execRow, i2, this.getCachedDestination(i2), this.resultDescription);
            this.normalizedRow.setColumn(i2, dataValueDescriptor2);
        }
        return this.normalizedRow;
    }

    private DataValueDescriptor getCachedDestination(int n2) throws StandardException {
        int n3 = n2 - 1;
        if (this.cachedDestinations[n3] == null) {
            this.cachedDestinations[n3] = this.getDesiredType(n2).getNull();
        }
        return this.cachedDestinations[n3];
    }

    private DataTypeDescriptor getDesiredType(int n2) {
        if (this.desiredTypes == null) {
            this.desiredTypes = this.fetchResultTypes(this.resultDescription);
        }
        return this.desiredTypes[n2 - 1];
    }

    private DataTypeDescriptor[] fetchResultTypes(ResultDescription resultDescription) {
        int n2 = resultDescription.getColumnCount();
        DataTypeDescriptor[] dataTypeDescriptorArray = new DataTypeDescriptor[n2];
        for (int i2 = 1; i2 <= n2; ++i2) {
            DataTypeDescriptor dataTypeDescriptor;
            ResultColumnDescriptor resultColumnDescriptor = resultDescription.getColumnDescriptor(i2);
            dataTypeDescriptorArray[i2 - 1] = dataTypeDescriptor = resultColumnDescriptor.getType();
        }
        return dataTypeDescriptorArray;
    }

    @Override
    public void updateRow(ExecRow execRow, RowChanger rowChanger) throws StandardException {
        this.source.updateRow(execRow, rowChanger);
    }

    @Override
    public void markRowAsDeleted() throws StandardException {
        this.source.markRowAsDeleted();
    }
}

