/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Enumeration;
import org.apache.derby.catalog.UUID;
import org.apache.derby.catalog.types.ReferencedColumnsDescriptorImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.sql.execute.RowChanger;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.types.SQLRef;
import org.apache.derby.impl.sql.execute.DeferredConstraintsMemory;
import org.apache.derby.impl.sql.execute.NoPutResultSetImpl;
import org.apache.derby.impl.sql.execute.ValidateCheckConstraintResultSet;

class ProjectRestrictResultSet
extends NoPutResultSetImpl
implements CursorResultSet {
    public long restrictionTime;
    public long projectionTime;
    final NoPutResultSet source;
    public GeneratedMethod constantRestriction;
    public GeneratedMethod restriction;
    public boolean doesProjection;
    private GeneratedMethod projection;
    private int[] projectMapping;
    private boolean[] cloneMap;
    private boolean runTimeStatsOn;
    private ExecRow mappedResultRow;
    public boolean reuseResult;
    private boolean shortCircuitOpen;
    private ExecRow projRow;
    private final boolean validatingCheckConstraint;
    private final UUID validatingBaseTableUUID;
    Enumeration<Object> rowLocations;

    ProjectRestrictResultSet(NoPutResultSet noPutResultSet, Activation activation, GeneratedMethod generatedMethod, GeneratedMethod generatedMethod2, int n2, GeneratedMethod generatedMethod3, int n3, int n4, boolean bl, boolean bl2, boolean bl3, UUID uUID, double d2, double d3) throws StandardException {
        super(activation, n2, d2, d3);
        this.source = noPutResultSet;
        this.restriction = generatedMethod;
        this.projection = generatedMethod2;
        this.constantRestriction = generatedMethod3;
        this.projectMapping = ((ReferencedColumnsDescriptorImpl)activation.getPreparedStatement().getSavedObject(n3)).getReferencedColumnPositions();
        this.reuseResult = bl;
        this.doesProjection = bl2;
        this.validatingCheckConstraint = bl3;
        this.validatingBaseTableUUID = uUID;
        if (this.projection == null) {
            this.mappedResultRow = this.activation.getExecutionFactory().getValueRow(this.projectMapping.length);
        }
        this.cloneMap = (boolean[])activation.getPreparedStatement().getSavedObject(n4);
        this.runTimeStatsOn = this.getLanguageConnectionContext().getRunTimeStatisticsMode();
        this.recordConstructorTime();
    }

    @Override
    public void openCore() throws StandardException {
        boolean bl = true;
        this.beginTime = this.getCurrentTimeMillis();
        if (this.constantRestriction != null) {
            DataValueDescriptor dataValueDescriptor = (DataValueDescriptor)this.constantRestriction.invoke(this.activation);
            boolean bl2 = bl = dataValueDescriptor == null || !dataValueDescriptor.isNull() && dataValueDescriptor.getBoolean();
        }
        if (this.validatingCheckConstraint) {
            this.rowLocations = DeferredConstraintsMemory.getDeferredCheckConstraintLocations(this.activation, this.validatingBaseTableUUID);
        }
        if (bl) {
            this.source.openCore();
        } else {
            this.shortCircuitOpen = true;
        }
        this.isOpen = true;
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    @Override
    public void reopenCore() throws StandardException {
        boolean bl = true;
        this.beginTime = this.getCurrentTimeMillis();
        if (this.constantRestriction != null) {
            DataValueDescriptor dataValueDescriptor = (DataValueDescriptor)this.constantRestriction.invoke(this.activation);
            boolean bl2 = bl = dataValueDescriptor == null || !dataValueDescriptor.isNull() && dataValueDescriptor.getBoolean();
        }
        if (bl) {
            this.source.reopenCore();
        } else {
            this.shortCircuitOpen = true;
        }
        this.isOpen = true;
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        Object object;
        if (this.isXplainOnlyMode()) {
            return null;
        }
        ExecRow execRow = null;
        ExecRow execRow2 = null;
        boolean bl = false;
        long l2 = 0L;
        if (this.shortCircuitOpen) {
            return execRow2;
        }
        this.beginTime = this.getCurrentTimeMillis();
        do {
            if (this.validatingCheckConstraint) {
                execRow = null;
                while (this.rowLocations.hasMoreElements() && execRow == null) {
                    object = (DataValueDescriptor[])this.rowLocations.nextElement();
                    RowLocation rowLocation = (RowLocation)((SQLRef)object[0]).getObject();
                    ((ValidateCheckConstraintResultSet)this.source).positionScanAtRowLocation(rowLocation);
                    execRow = this.source.getNextRowCore();
                }
            } else {
                execRow = this.source.getNextRowCore();
            }
            if (execRow == null) continue;
            l2 = this.getCurrentTimeMillis();
            if (this.restriction == null) {
                bl = true;
            } else {
                this.setCurrentRow(execRow);
                DataValueDescriptor dataValueDescriptor = (DataValueDescriptor)this.restriction.invoke(this.activation);
                this.restrictionTime += this.getElapsedMillis(l2);
                boolean bl2 = bl = !dataValueDescriptor.isNull() && dataValueDescriptor.getBoolean();
                if (!bl) {
                    ++this.rowsFiltered;
                }
            }
            ++this.rowsSeen;
        } while (execRow != null && !bl);
        if (execRow != null) {
            l2 = this.getCurrentTimeMillis();
            execRow2 = this.doProjection(execRow);
            this.projectionTime += this.getElapsedMillis(l2);
        } else {
            this.clearCurrentRow();
        }
        this.currentRow = execRow2;
        if (this.runTimeStatsOn) {
            if (!this.isTopResultSet) {
                object = this.activation.getLanguageConnectionContext().getStatementContext();
                this.subqueryTrackingArray = object.getSubqueryTrackingArray();
            }
            this.nextTime += this.getElapsedMillis(this.beginTime);
        }
        return execRow2;
    }

    @Override
    public long getTimeSpent(int n2) {
        long l2 = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        if (n2 == 0) {
            return l2 - this.source.getTimeSpent(1);
        }
        return l2;
    }

    @Override
    public void close() throws StandardException {
        if (this.shortCircuitOpen) {
            this.shortCircuitOpen = false;
            this.source.close();
            super.close();
            return;
        }
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            this.clearCurrentRow();
            this.source.close();
            super.close();
        }
        this.closeTime += this.getElapsedMillis(this.beginTime);
    }

    @Override
    public void finish() throws StandardException {
        this.source.finish();
        this.finishAndRTS();
    }

    @Override
    public RowLocation getRowLocation() throws StandardException {
        return ((CursorResultSet)((Object)this.source)).getRowLocation();
    }

    @Override
    public ExecRow getCurrentRow() throws StandardException {
        ExecRow execRow = null;
        ExecRow execRow2 = null;
        boolean bl = false;
        if (this.currentRow == null) {
            return null;
        }
        execRow = ((CursorResultSet)((Object)this.source)).getCurrentRow();
        if (execRow != null) {
            this.setCurrentRow(execRow);
            DataValueDescriptor dataValueDescriptor = (DataValueDescriptor)(this.restriction == null ? null : this.restriction.invoke(this.activation));
            boolean bl2 = bl = dataValueDescriptor == null || !dataValueDescriptor.isNull() && dataValueDescriptor.getBoolean();
        }
        if (execRow != null && bl) {
            execRow2 = this.doProjection(execRow);
        }
        this.currentRow = execRow2;
        if (execRow2 == null) {
            this.clearCurrentRow();
        }
        return this.currentRow;
    }

    private ExecRow doProjection(ExecRow execRow) throws StandardException {
        if (this.reuseResult && this.projRow != null) {
            this.setCurrentRow(this.projRow);
            return this.projRow;
        }
        ExecRow execRow2 = this.projection != null ? (ExecRow)this.projection.invoke(this.activation) : this.mappedResultRow;
        for (int i2 = 0; i2 < this.projectMapping.length; ++i2) {
            if (this.projectMapping[i2] == -1) continue;
            DataValueDescriptor dataValueDescriptor = execRow.getColumn(this.projectMapping[i2]);
            if (this.cloneMap[i2] && dataValueDescriptor.hasStream()) {
                dataValueDescriptor = dataValueDescriptor.cloneValue(false);
            }
            execRow2.setColumn(i2 + 1, dataValueDescriptor);
        }
        this.setCurrentRow(execRow2);
        if (this.reuseResult) {
            this.projRow = execRow2;
        }
        return execRow2;
    }

    public ExecRow doBaseRowProjection(ExecRow execRow) throws StandardException {
        ExecRow execRow2;
        if (this.source instanceof ProjectRestrictResultSet) {
            ProjectRestrictResultSet projectRestrictResultSet = (ProjectRestrictResultSet)this.source;
            execRow2 = projectRestrictResultSet.doBaseRowProjection(execRow);
        } else {
            execRow2 = execRow.getNewNullRow();
            execRow2.setRowArray(execRow.getRowArray());
        }
        return this.doProjection(execRow2);
    }

    public int[] getBaseProjectMapping() {
        int[] nArray;
        if (this.source instanceof ProjectRestrictResultSet) {
            nArray = new int[this.projectMapping.length];
            ProjectRestrictResultSet projectRestrictResultSet = (ProjectRestrictResultSet)this.source;
            int[] nArray2 = projectRestrictResultSet.getBaseProjectMapping();
            for (int i2 = 0; i2 < this.projectMapping.length; ++i2) {
                if (this.projectMapping[i2] <= 0) continue;
                nArray[i2] = nArray2[this.projectMapping[i2] - 1];
            }
        } else {
            nArray = this.projectMapping;
        }
        return nArray;
    }

    @Override
    public boolean isForUpdate() {
        return this.source.isForUpdate();
    }

    @Override
    public void updateRow(ExecRow execRow, RowChanger rowChanger) throws StandardException {
        this.source.updateRow(execRow, rowChanger);
    }

    @Override
    public void markRowAsDeleted() throws StandardException {
        this.source.markRowAsDeleted();
    }
}

