/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Enumeration;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.StatementUtil;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.BackingStoreHashtable;
import org.apache.derby.iapi.store.access.KeyHasher;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.SQLLongint;
import org.apache.derby.impl.sql.execute.DeferredConstraintsMemory;
import org.apache.derby.impl.sql.execute.FKInfo;
import org.apache.derby.impl.sql.execute.GenericRIChecker;
import org.apache.derby.impl.sql.execute.RowUtil;

public class ReferencedKeyRIChecker
extends GenericRIChecker {
    private ScanController refKeyIndexScan = null;
    private final DataValueDescriptor[] refKey = new DataValueDescriptor[this.numColumns];
    private BackingStoreHashtable deletedKeys = null;

    ReferencedKeyRIChecker(LanguageConnectionContext languageConnectionContext, TransactionController transactionController, FKInfo fKInfo) throws StandardException {
        super(languageConnectionContext, transactionController, fKInfo);
    }

    @Override
    void doCheck(Activation activation, ExecRow execRow, boolean bl, int n2) throws StandardException {
        if (this.isAnyFieldNull(execRow)) {
            return;
        }
        if (this.fkInfo.refConstraintIsDeferrable && this.lcc.isEffectivelyDeferred(this.lcc.getCurrentSQLSessionContext(activation), this.fkInfo.refConstraintID)) {
            if (bl) {
                this.rememberKey(execRow);
                return;
            }
            if (this.isDuplicated(execRow, n2)) {
                return;
            }
        }
        for (int i2 = 0; i2 < this.fkInfo.fkConglomNumbers.length; ++i2) {
            if (bl && this.fkInfo.raRules[i2] != 1) continue;
            ScanController scanController = this.getScanController(this.fkInfo.fkConglomNumbers[i2], this.fkScocis[i2], this.fkDcocis[i2], execRow);
            if (scanController.next()) {
                this.close();
                UUID uUID = this.fkInfo.fkIds[i2];
                if (this.fkInfo.deferrable[i2] && this.fkInfo.raRules[i2] != 1 && this.lcc.isEffectivelyDeferred(this.lcc.getCurrentSQLSessionContext(activation), uUID)) {
                    this.deferredRowsHashTable = DeferredConstraintsMemory.rememberFKViolation(this.lcc, this.deferredRowsHashTable, this.fkInfo.fkIds[i2], this.indexQualifierRow.getRowArray(), this.fkInfo.schemaName, this.fkInfo.tableName);
                } else {
                    StandardException standardException = StandardException.newException("23503", this.fkInfo.fkConstraintNames[i2], this.fkInfo.tableName, StatementUtil.typeName(this.fkInfo.stmtType), RowUtil.toString(execRow, this.fkInfo.colArray));
                    throw standardException;
                }
            }
            scanController.next();
        }
    }

    private void rememberKey(ExecRow execRow) throws StandardException {
        if (this.deletedKeys == null) {
            this.identityMap = new int[this.numColumns];
            for (int i2 = 0; i2 < this.numColumns; ++i2) {
                this.identityMap[i2] = i2;
            }
            this.deletedKeys = new BackingStoreHashtable(this.tc, null, this.identityMap, true, -1L, -1L, -1, -1.0f, false, false);
        }
        DataValueDescriptor[] dataValueDescriptorArray = execRow.getRowArray();
        for (int i3 = 0; i3 < this.numColumns; ++i3) {
            this.refKey[i3] = dataValueDescriptorArray[this.fkInfo.colArray[i3] - 1];
        }
        Object object = KeyHasher.buildHashKey(this.refKey, this.identityMap);
        DataValueDescriptor[] dataValueDescriptorArray2 = (DataValueDescriptor[])this.deletedKeys.remove(object);
        if (dataValueDescriptorArray2 == null) {
            dataValueDescriptorArray2 = new DataValueDescriptor[this.numColumns + 1];
            System.arraycopy(this.refKey, 0, dataValueDescriptorArray2, 0, this.numColumns);
            dataValueDescriptorArray2[this.numColumns] = new SQLLongint(1L);
        } else {
            dataValueDescriptorArray2[this.numColumns] = new SQLLongint(((SQLLongint)dataValueDescriptorArray2[this.numColumns]).getLong() + 1L);
        }
        this.deletedKeys.putRow(false, dataValueDescriptorArray2, null);
    }

    public void postCheck() throws StandardException {
        if (!this.fkInfo.refConstraintIsDeferrable) {
            return;
        }
        int n2 = -1;
        for (int i2 = 0; i2 < this.fkInfo.fkConglomNumbers.length; ++i2) {
            if (this.fkInfo.raRules[i2] != 1) continue;
            n2 = i2;
            break;
        }
        if (n2 == -1) {
            return;
        }
        if (this.deletedKeys != null) {
            Enumeration<Object> enumeration = this.deletedKeys.elements();
            while (enumeration.hasMoreElements()) {
                Object[] objectArray = (DataValueDescriptor[])enumeration.nextElement();
                DataValueDescriptor[] dataValueDescriptorArray = new DataValueDescriptor[objectArray.length - 1];
                System.arraycopy(objectArray, 0, dataValueDescriptorArray, 0, dataValueDescriptorArray.length);
                long l2 = objectArray[objectArray.length - 1].getLong() + 1L;
                if (this.isDuplicated(dataValueDescriptorArray, l2)) continue;
                int[] nArray = new int[this.numColumns];
                for (int i3 = 0; i3 < this.numColumns; ++i3) {
                    nArray[i3] = i3 + 1;
                }
                StandardException standardException = StandardException.newException("23503", this.fkInfo.fkConstraintNames[n2], this.fkInfo.tableName, StatementUtil.typeName(this.fkInfo.stmtType), RowUtil.toString(objectArray, nArray));
                throw standardException;
            }
        }
    }

    private boolean isDuplicated(ExecRow execRow, int n2) throws StandardException {
        DataValueDescriptor[] dataValueDescriptorArray = execRow.getRowArray();
        for (int i2 = 0; i2 < this.numColumns; ++i2) {
            this.refKey[i2] = dataValueDescriptorArray[this.fkInfo.colArray[i2] - 1];
        }
        return this.isDuplicated(this.refKey, (long)n2);
    }

    private boolean isDuplicated(DataValueDescriptor[] dataValueDescriptorArray, long l2) throws StandardException {
        if (this.refKeyIndexScan == null) {
            this.refKeyIndexScan = this.tc.openScan(this.fkInfo.refConglomNumber, false, 0, 6, 4, null, dataValueDescriptorArray, 1, null, dataValueDescriptorArray, -1);
        } else {
            this.refKeyIndexScan.reopenScan(dataValueDescriptorArray, 1, null, dataValueDescriptorArray, -1);
        }
        boolean bl = this.refKeyIndexScan.next();
        while (--l2 > 0L && bl) {
            bl = this.refKeyIndexScan.next();
        }
        return l2 == 0L && bl;
    }

    @Override
    void close() throws StandardException {
        if (this.refKeyIndexScan != null) {
            this.refKeyIndexScan.close();
            this.refKeyIndexScan = null;
        }
        if (this.deletedKeys != null) {
            this.deletedKeys.close();
            this.deletedKeys = null;
        }
        this.identityMap = null;
        super.close();
    }
}

