/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.InvocationTargetException;
import org.apache.derby.agg.Aggregator;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.sql.execute.ExecAggregator;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;

public final class UserDefinedAggregator
implements ExecAggregator {
    private static final int FIRST_VERSION = 0;
    private Aggregator _aggregator;
    private DataTypeDescriptor _resultType;
    private boolean _eliminatedNulls;

    @Override
    public void setup(ClassFactory classFactory, String string, DataTypeDescriptor dataTypeDescriptor) {
        try {
            this.setup(classFactory.loadApplicationClass(string), dataTypeDescriptor);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.logAggregatorInstantiationError(string, classNotFoundException);
        }
    }

    private void setup(Class<?> clazz, DataTypeDescriptor dataTypeDescriptor) {
        String string = clazz.getName();
        try {
            this._aggregator = (Aggregator)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            this._aggregator.init();
        }
        catch (InstantiationException instantiationException) {
            this.logAggregatorInstantiationError(string, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.logAggregatorInstantiationError(string, illegalAccessException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.logAggregatorInstantiationError(string, noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            this.logAggregatorInstantiationError(string, invocationTargetException);
        }
        this._resultType = dataTypeDescriptor;
    }

    @Override
    public boolean didEliminateNulls() {
        return this._eliminatedNulls;
    }

    @Override
    public void accumulate(DataValueDescriptor dataValueDescriptor, Object object) throws StandardException {
        if (dataValueDescriptor == null || dataValueDescriptor.isNull()) {
            this._eliminatedNulls = true;
            return;
        }
        Object object2 = dataValueDescriptor.getObject();
        this._aggregator.accumulate(object2);
    }

    @Override
    public void merge(ExecAggregator execAggregator) throws StandardException {
        UserDefinedAggregator userDefinedAggregator = (UserDefinedAggregator)execAggregator;
        this._aggregator.merge(userDefinedAggregator._aggregator);
    }

    @Override
    public DataValueDescriptor getResult() throws StandardException {
        Object r2 = this._aggregator.terminate();
        if (r2 == null) {
            return null;
        }
        DataValueDescriptor dataValueDescriptor = this._resultType.getNull();
        dataValueDescriptor.setObjectForCast(r2, true, r2.getClass().getName());
        return dataValueDescriptor;
    }

    @Override
    public ExecAggregator newAggregator() {
        UserDefinedAggregator userDefinedAggregator = new UserDefinedAggregator();
        userDefinedAggregator.setup(this._aggregator.getClass(), this._resultType);
        return userDefinedAggregator;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(0);
        objectOutput.writeObject(this._aggregator);
        objectOutput.writeObject(this._resultType);
        objectOutput.writeBoolean(this._eliminatedNulls);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        objectInput.readInt();
        this._aggregator = (Aggregator)objectInput.readObject();
        this._resultType = (DataTypeDescriptor)objectInput.readObject();
        this._eliminatedNulls = objectInput.readBoolean();
    }

    @Override
    public int getTypeFormatId() {
        return 323;
    }

    private void logAggregatorInstantiationError(String string, Throwable throwable) {
        String string2 = MessageService.getTextMessage("C008", string, throwable.getMessage());
        Monitor.getStream().println(string2);
        Exception exception = new Exception(string2, throwable);
        exception.printStackTrace(Monitor.getStream().getPrintWriter());
    }
}

