/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.ExecPreparedStatement;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecRowBuilder;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.sql.execute.NoPutResultSetImpl;

class WindowResultSet
extends NoPutResultSetImpl {
    private GeneratedMethod restriction = null;
    public NoPutResultSet source = null;
    public long restrictionTime;
    private FormatableBitSet referencedColumns;
    private ExecRow allocatedRow;
    private long rownumber;

    WindowResultSet(Activation activation, NoPutResultSet noPutResultSet, int n2, int n3, int n4, GeneratedMethod generatedMethod, double d2, double d3) throws StandardException {
        super(activation, n3, d2, d3);
        this.restriction = generatedMethod;
        this.source = noPutResultSet;
        this.rownumber = 0L;
        ExecPreparedStatement execPreparedStatement = activation.getPreparedStatement();
        this.allocatedRow = ((ExecRowBuilder)execPreparedStatement.getSavedObject(n2)).build(activation.getExecutionFactory());
        if (n4 != -1) {
            this.referencedColumns = (FormatableBitSet)execPreparedStatement.getSavedObject(n4);
        }
        this.recordConstructorTime();
    }

    @Override
    public void openCore() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        this.source.openCore();
        this.isOpen = true;
        this.rownumber = 0L;
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    @Override
    public void reopenCore() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        this.source.reopenCore();
        this.rownumber = 0L;
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        if (this.isXplainOnlyMode()) {
            return null;
        }
        ExecRow execRow = null;
        ExecRow execRow2 = null;
        boolean bl = false;
        long l2 = 0L;
        this.beginTime = this.getCurrentTimeMillis();
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S", "next");
        }
        ExecRow execRow3 = null;
        do {
            if ((execRow = this.source.getNextRowCore()) != null) {
                ++this.rownumber;
                execRow3 = this.getAllocatedRow();
                this.populateFromSourceRow(execRow, execRow3);
                this.setCurrentRow(execRow3);
                DataValueDescriptor dataValueDescriptor = (DataValueDescriptor)(this.restriction == null ? null : this.restriction.invoke(this.activation));
                this.restrictionTime += this.getElapsedMillis(l2);
                boolean bl2 = bl = dataValueDescriptor == null || !dataValueDescriptor.isNull() && dataValueDescriptor.getBoolean();
                if (!bl) {
                    ++this.rowsFiltered;
                    this.clearCurrentRow();
                }
                ++this.rowsSeen;
                execRow2 = this.currentRow;
                continue;
            }
            this.clearCurrentRow();
            execRow2 = null;
        } while (execRow != null && !bl);
        this.nextTime += this.getElapsedMillis(this.beginTime);
        return execRow2;
    }

    @Override
    public void close() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            this.clearCurrentRow();
            this.source.close();
            super.close();
        }
        this.closeTime += this.getElapsedMillis(this.beginTime);
    }

    public void populateFromSourceRow(ExecRow execRow, ExecRow execRow2) throws StandardException {
        int n2 = 1;
        try {
            DataValueDescriptor[] dataValueDescriptorArray = execRow2.getRowArray();
            for (int i2 = 0; i2 < dataValueDescriptorArray.length; ++i2) {
                if (this.referencedColumns != null && !this.referencedColumns.get(i2)) {
                    dataValueDescriptorArray[i2].setValue(this.rownumber);
                    continue;
                }
                execRow2.setColumn(i2 + 1, execRow.getColumn(n2));
                ++n2;
            }
        }
        catch (StandardException standardException) {
            throw standardException;
        }
        catch (Throwable throwable) {
            throw StandardException.unexpectedUserException(throwable);
        }
    }

    @Override
    public long getTimeSpent(int n2) {
        long l2 = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        if (n2 == 0) {
            return l2 - this.source.getTimeSpent(1);
        }
        return l2;
    }

    private ExecRow getAllocatedRow() throws StandardException {
        return this.allocatedRow;
    }
}

