/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.btree;

import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.store.access.StoreCostController;
import org.apache.derby.iapi.store.access.StoreCostResult;
import org.apache.derby.iapi.store.access.conglomerate.Conglomerate;
import org.apache.derby.iapi.store.access.conglomerate.TransactionManager;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.store.access.btree.BTree;
import org.apache.derby.impl.store.access.btree.ControlRow;
import org.apache.derby.impl.store.access.btree.OpenBTree;
import org.apache.derby.impl.store.access.btree.SearchParameters;

public class BTreeCostController
extends OpenBTree
implements StoreCostController {
    private static final double BTREE_CACHED_FETCH_BY_KEY_PER_LEVEL = 0.2705;
    private static final double BTREE_SORTMERGE_FETCH_BY_KEY_PER_LEVEL = 0.716;
    private static final double BTREE_UNCACHED_FETCH_BY_KEY_PER_LEVEL = 1.5715;
    TransactionManager init_xact_manager;
    Transaction init_rawtran;
    Conglomerate init_conglomerate;
    long num_pages;
    long num_rows;
    long page_size;
    int tree_height;

    public void init(TransactionManager transactionManager, BTree bTree, Transaction transaction) throws StandardException {
        super.init(transactionManager, transactionManager, null, transaction, false, 8, 5, null, bTree, null, null);
        this.num_pages = this.container.getEstimatedPageCount(0);
        this.num_rows = this.container.getEstimatedRowCount(0) - this.num_pages;
        Properties properties = new Properties();
        properties.put("derby.storage.pageSize", "");
        this.container.getContainerProperties(properties);
        this.page_size = Integer.parseInt(properties.getProperty("derby.storage.pageSize"));
        this.tree_height = this.getHeight();
    }

    @Override
    public void close() throws StandardException {
        super.close();
    }

    @Override
    public double getFetchFromRowLocationCost(FormatableBitSet formatableBitSet, int n2) throws StandardException {
        throw StandardException.newException("XSCB3.S", new Object[0]);
    }

    @Override
    public double getFetchFromFullKeyCost(FormatableBitSet formatableBitSet, int n2) throws StandardException {
        double d2 = (n2 & 1) == 0 ? 1.5715 : 0.716;
        return d2 *= (double)this.tree_height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getScanCost(int n2, long l2, int n3, boolean bl, FormatableBitSet formatableBitSet, DataValueDescriptor[] dataValueDescriptorArray, DataValueDescriptor[] dataValueDescriptorArray2, int n4, DataValueDescriptor[] dataValueDescriptorArray3, int n5, boolean bl2, int n6, StoreCostResult storeCostResult) throws StandardException {
        ControlRow controlRow = null;
        long l3 = l2 < 0L ? this.num_rows : l2;
        try {
            float f2;
            float f3;
            SearchParameters searchParameters;
            float f4;
            if (dataValueDescriptorArray2 == null) {
                f4 = 0.0f;
            } else {
                searchParameters = new SearchParameters(dataValueDescriptorArray2, n4 == 1 ? 1 : -1, dataValueDescriptorArray, this, true);
                controlRow = ControlRow.get(this, 1L).search(searchParameters);
                controlRow.release();
                controlRow = null;
                f4 = searchParameters.left_fraction;
            }
            if (dataValueDescriptorArray3 == null) {
                f3 = 1.0f;
            } else {
                searchParameters = new SearchParameters(dataValueDescriptorArray3, n5 == 1 ? 1 : -1, dataValueDescriptorArray, this, true);
                controlRow = ControlRow.get(this, 1L).search(searchParameters);
                controlRow.release();
                controlRow = null;
                f3 = searchParameters.left_fraction;
            }
            float f5 = f3 - f4;
            if (f5 < 0.0f) {
                f5 = 0.0f;
            }
            if (f5 > 1.0f) {
                f5 = 1.0f;
            }
            if ((f2 = (float)l3 * f5) < 1.0f) {
                f2 = 1.0f;
            }
            double d2 = this.getFetchFromFullKeyCost(formatableBitSet, n6);
            d2 += (double)((float)this.num_pages * f5) * 1.5;
            long l4 = (long)f2 - this.num_pages;
            if (l4 < 0L) {
                l4 = 0L;
            }
            d2 = n2 == 2 ? (d2 += (double)l4 * 0.12) : (d2 += (double)l4 * 0.14);
            long l5 = l3 == 0L ? 4L : this.num_pages * this.page_size / l3;
            storeCostResult.setEstimatedCost(d2 += (double)(f2 * (float)l5) * 0.004);
            storeCostResult.setEstimatedRowCount(Math.round(f2));
        }
        finally {
            if (controlRow != null) {
                controlRow.release();
            }
        }
    }

    @Override
    public RowLocation newRowLocationTemplate() throws StandardException {
        throw StandardException.newException("XSCB3.S", new Object[0]);
    }
}

