/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.btree;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.daemon.Serviceable;
import org.apache.derby.iapi.store.access.AccessFactory;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.RowUtil;
import org.apache.derby.iapi.store.access.conglomerate.TransactionManager;
import org.apache.derby.iapi.store.raw.FetchDescriptor;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.store.access.btree.BTree;
import org.apache.derby.impl.store.access.btree.BTreeLockingPolicy;
import org.apache.derby.impl.store.access.btree.ControlRow;
import org.apache.derby.impl.store.access.btree.LeafControlRow;
import org.apache.derby.impl.store.access.btree.OpenBTree;

class BTreePostCommit
implements Serviceable {
    private AccessFactory access_factory = null;
    private long page_number = -1L;
    protected BTree btree = null;

    BTreePostCommit(AccessFactory accessFactory, BTree bTree, long l2) {
        this.access_factory = accessFactory;
        this.btree = bTree;
        this.page_number = l2;
    }

    @Override
    public boolean serviceASAP() {
        return true;
    }

    @Override
    public boolean serviceImmediately() {
        return false;
    }

    private final void doShrink(OpenBTree openBTree, DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        ControlRow controlRow = null;
        controlRow = ControlRow.get(openBTree, 1L);
        controlRow.shrinkFor(openBTree, dataValueDescriptorArray);
        controlRow = null;
    }

    private final OpenBTree openIndex(TransactionManager transactionManager, int n2, int n3) throws StandardException {
        OpenBTree openBTree = new OpenBTree();
        ConglomerateController conglomerateController = this.btree.lockTable(transactionManager, 132, n2, 4);
        openBTree.init(null, transactionManager, null, transactionManager.getRawStoreXact(), false, 132, n2, this.btree.getBtreeLockingPolicy(transactionManager.getRawStoreXact(), n2, n3, 4, conglomerateController, openBTree), this.btree, null, null);
        return openBTree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int performWork(ContextManager contextManager) throws StandardException {
        boolean bl = false;
        TransactionManager transactionManager = (TransactionManager)this.access_factory.getAndNameTransaction(contextManager, "SystemTransaction");
        TransactionManager transactionManager2 = transactionManager.getInternalTransaction();
        OpenBTree openBTree = null;
        try {
            openBTree = this.openIndex(transactionManager2, 7, 2);
            DataValueDescriptor[] dataValueDescriptorArray = this.purgeCommittedDeletes(openBTree, this.page_number);
            if (dataValueDescriptorArray != null) {
                this.doShrink(openBTree, dataValueDescriptorArray);
            }
        }
        catch (StandardException standardException) {
            if (standardException.isLockTimeoutOrDeadlock()) {
                try {
                    openBTree = this.openIndex(transactionManager2, 6, 1);
                    this.purgeRowLevelCommittedDeletes(openBTree);
                }
                catch (StandardException standardException2) {
                    if (standardException2.isLockTimeoutOrDeadlock()) {
                        bl = true;
                    }
                }
            }
        }
        finally {
            if (openBTree != null) {
                openBTree.close();
            }
            transactionManager2.commit();
            transactionManager2.destroy();
        }
        return bl ? 2 : 1;
    }

    private final DataValueDescriptor[] getShrinkKey(OpenBTree openBTree, ControlRow controlRow, int n2) throws StandardException {
        Object[] objectArray = openBTree.getConglomerate().createTemplate(openBTree.getRawTran());
        controlRow.page.fetchFromSlot(null, n2, objectArray, null, true);
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final DataValueDescriptor[] purgeCommittedDeletes(OpenBTree openBTree, long l2) throws StandardException {
        ControlRow controlRow = null;
        DataValueDescriptor[] dataValueDescriptorArray = null;
        try {
            controlRow = ControlRow.getNoWait(openBTree, l2);
            if (controlRow != null) {
                Page page = controlRow.page;
                int n2 = page.recordCount() - 1 - page.nonDeletedRecordCount();
                if (n2 > 0) {
                    for (int i2 = page.recordCount() - 1; i2 > 0; --i2) {
                        if (!page.isDeletedAtSlot(i2)) continue;
                        if (page.recordCount() == 2) {
                            dataValueDescriptorArray = this.getShrinkKey(openBTree, controlRow, i2);
                        }
                        page.purgeAtSlot(i2, 1, true);
                        page.setRepositionNeeded();
                    }
                }
                if (page.recordCount() == 1) {
                    // empty if block
                }
            }
        }
        finally {
            if (controlRow != null) {
                controlRow.release();
            }
        }
        return dataValueDescriptorArray;
    }

    private final void purgeRowLevelCommittedDeletes(OpenBTree openBTree) throws StandardException {
        LeafControlRow leafControlRow = null;
        leafControlRow = (LeafControlRow)ControlRow.getNoWait(openBTree, this.page_number);
        if (leafControlRow == null) {
            return;
        }
        BTreeLockingPolicy bTreeLockingPolicy = openBTree.getLockingPolicy();
        int n2 = leafControlRow.page.recordCount() - 1 - leafControlRow.page.nonDeletedRecordCount();
        if (n2 > 0) {
            DataValueDescriptor[] dataValueDescriptorArray = openBTree.getRuntimeMem().get_template(openBTree.getRawTran());
            Page page = leafControlRow.page;
            FetchDescriptor fetchDescriptor = RowUtil.getFetchDescriptorConstant(dataValueDescriptorArray.length - 1);
            for (int i2 = page.recordCount() - 1; i2 > 0; --i2) {
                if (!page.isDeletedAtSlot(i2) || !bTreeLockingPolicy.lockScanCommittedDeletedRow(openBTree, leafControlRow, dataValueDescriptorArray, fetchDescriptor, i2)) continue;
                page.purgeAtSlot(i2, 1, true);
                page.setRepositionNeeded();
            }
        }
    }
}

