/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.conglomerate;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Properties;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.services.io.FormatIdUtil;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.types.DataValueDescriptor;

public final class ConglomerateUtil {
    public static Properties createRawStorePropertySet(Properties properties) {
        properties = ConglomerateUtil.createUserRawStorePropertySet(properties);
        properties.put("derby.storage.reusableRecordId", "");
        return properties;
    }

    public static Properties createUserRawStorePropertySet(Properties properties) {
        if (properties == null) {
            properties = new Properties();
        }
        properties.put("derby.storage.pageSize", "");
        properties.put("derby.storage.minimumRecordSize", "");
        properties.put("derby.storage.pageReservedSpace", "");
        properties.put("derby.storage.initialPages", "");
        return properties;
    }

    public static int[] createFormatIds(DataValueDescriptor[] dataValueDescriptorArray) {
        int[] nArray = new int[dataValueDescriptorArray.length];
        for (int i2 = 0; i2 < dataValueDescriptorArray.length; ++i2) {
            nArray[i2] = dataValueDescriptorArray[i2].getTypeFormatId();
        }
        return nArray;
    }

    public static int[] readFormatIdArray(int n2, ObjectInput objectInput) throws IOException {
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = FormatIdUtil.readFormatIdInteger(objectInput);
        }
        return nArray;
    }

    public static void writeFormatIdArray(int[] nArray, ObjectOutput objectOutput) throws IOException {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            FormatIdUtil.writeFormatIdInteger(objectOutput, nArray[i2]);
        }
    }

    public static int[] createCollationIds(int n2, int[] nArray) {
        int[] nArray2 = new int[n2];
        if (nArray != null) {
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        } else {
            for (int i2 = 0; i2 < nArray2.length; ++i2) {
                nArray2[i2] = 0;
            }
        }
        return nArray2;
    }

    public static void writeCollationIdArray(int[] nArray, ObjectOutput objectOutput) throws IOException {
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (nArray[n2] == 0) continue;
            ++n3;
        }
        CompressedNumber.writeInt(objectOutput, n3);
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (nArray[n2] == 0) continue;
            CompressedNumber.writeInt(objectOutput, n2);
            CompressedNumber.writeInt(objectOutput, nArray[n2]);
        }
    }

    public static boolean readCollationIdArray(int[] nArray, ObjectInput objectInput) throws IOException {
        int n2 = CompressedNumber.readInt(objectInput);
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = CompressedNumber.readInt(objectInput);
            nArray[n3] = CompressedNumber.readInt(objectInput);
        }
        return n2 > 0;
    }

    public static String debugPage(Page page, int n2, boolean bl, DataValueDescriptor[] dataValueDescriptorArray) {
        return null;
    }
}

