/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.sort;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.store.access.SortObserver;
import org.apache.derby.iapi.store.access.conglomerate.TransactionManager;
import org.apache.derby.iapi.store.raw.StreamContainerHandle;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.store.access.sort.MergeSort;
import org.apache.derby.impl.store.access.sort.SortBuffer;
import org.apache.derby.impl.store.access.sort.SortScan;

public class MergeScan
extends SortScan {
    protected SortBuffer sortBuffer;
    protected Vector<Long> mergeRuns;
    protected StreamContainerHandle[] openScans;
    private SortObserver sortObserver;

    MergeScan(MergeSort mergeSort, TransactionManager transactionManager, SortBuffer sortBuffer, Vector<Long> vector, SortObserver sortObserver, boolean bl) {
        super(mergeSort, transactionManager, bl);
        this.sortBuffer = sortBuffer;
        this.mergeRuns = vector;
        this.tran = transactionManager;
        this.sortObserver = sortObserver;
    }

    @Override
    public boolean next() throws StandardException {
        this.current = this.sortBuffer.removeFirst();
        if (this.current != null) {
            this.mergeARow(this.sortBuffer.getLastAux());
        }
        return this.current != null;
    }

    @Override
    public void close() {
        if (this.openScans != null) {
            for (int i2 = 0; i2 < this.openScans.length; ++i2) {
                if (this.openScans[i2] != null) {
                    this.openScans[i2].close();
                }
                this.openScans[i2] = null;
            }
            this.openScans = null;
        }
        if (this.sort != null) {
            this.sort.doneScanning(this, this.sortBuffer, this.mergeRuns);
            this.sortBuffer = null;
            this.mergeRuns = null;
        }
        super.close();
    }

    @Override
    public boolean closeForEndTransaction(boolean bl) {
        if (!this.hold || bl) {
            this.close();
            return true;
        }
        return false;
    }

    public boolean init(TransactionManager transactionManager) throws StandardException {
        this.sortBuffer.reset();
        this.openScans = new StreamContainerHandle[this.mergeRuns.size()];
        if (this.openScans == null) {
            return false;
        }
        int n2 = 0;
        Enumeration<Long> enumeration = this.mergeRuns.elements();
        while (enumeration.hasMoreElements()) {
            long l2 = enumeration.nextElement();
            Transaction transaction = transactionManager.getRawStoreXact();
            int n3 = -1;
            this.openScans[n2++] = transaction.openStreamContainer(n3, l2, this.hold);
        }
        for (n2 = 0; n2 < this.openScans.length; ++n2) {
            this.mergeARow(n2);
        }
        return true;
    }

    void mergeARow(int n2) throws StandardException {
        DataValueDescriptor[] dataValueDescriptorArray;
        do {
            if (!this.openScans[n2].fetchNext(dataValueDescriptorArray = this.sortObserver.getArrayClone())) {
                this.openScans[n2].close();
                this.openScans[n2] = null;
                return;
            }
            this.sortBuffer.setNextAux(n2);
        } while (this.sortBuffer.insert(dataValueDescriptorArray) == 1);
    }
}

