/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.impl.store.raw.data.AllocPage;
import org.apache.derby.impl.store.raw.data.BaseContainerHandle;

public class AllocExtent
implements Externalizable {
    private long extentOffset;
    private long extentStart;
    private long extentEnd;
    private int extentLength;
    int extentStatus;
    private int preAllocLength;
    private int reserved1;
    private long reserved2;
    private long reserved3;
    private static final int HAS_DEALLOCATED = 1;
    private static final int HAS_FREE = 2;
    private static final int ALL_FREE = 4;
    private static final int HAS_UNFILLED_PAGES = 16;
    private static final int KEEP_UNFILLED_PAGES = 0x10000000;
    private static final int NO_DEALLOC_PAGE_MAP = 0x20000000;
    private static final int RETIRED = 8;
    protected static final int ALLOCATED_PAGE = 0;
    protected static final int DEALLOCATED_PAGE = 1;
    protected static final int FREE_PAGE = 2;
    FormatableBitSet freePages;
    FormatableBitSet unFilledPages;

    protected static int MAX_RANGE(int n2) {
        int n3 = 56;
        n2 -= n3;
        if ((n2 /= 3) <= 0) {
            return 0;
        }
        return FormatableBitSet.maxBitsForSpace(n2);
    }

    protected AllocExtent(long l2, long l3, int n2, int n3, int n4) {
        this.extentOffset = l2;
        this.extentStart = l3;
        this.extentEnd = l3 + (long)n4 - 1L;
        this.preAllocLength = this.extentLength = n2;
        this.extentStatus = n2 > 0 ? 6 : 0;
        this.extentStatus |= 0x10000000;
        this.extentStatus |= 0x20000000;
        int n5 = (1 + n2 / 8) * 8;
        if (n5 > n4) {
            n5 = n4;
        }
        this.freePages = new FormatableBitSet(n5);
        this.unFilledPages = new FormatableBitSet(n5);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.freePages.set(i2);
        }
    }

    protected AllocExtent(AllocExtent allocExtent) {
        this.extentOffset = allocExtent.extentOffset;
        this.extentStart = allocExtent.extentStart;
        this.extentEnd = allocExtent.extentEnd;
        this.extentLength = allocExtent.extentLength;
        this.extentStatus = allocExtent.extentStatus;
        this.preAllocLength = allocExtent.preAllocLength;
        this.freePages = new FormatableBitSet(allocExtent.freePages);
        this.unFilledPages = new FormatableBitSet(allocExtent.unFilledPages);
    }

    public AllocExtent() {
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeLong(this.extentOffset);
        objectOutput.writeLong(this.extentStart);
        objectOutput.writeLong(this.extentEnd);
        objectOutput.writeInt(this.extentLength);
        objectOutput.writeInt(this.extentStatus);
        objectOutput.writeInt(this.preAllocLength);
        objectOutput.writeInt(0);
        objectOutput.writeLong(0L);
        objectOutput.writeLong(0L);
        this.freePages.writeExternal(objectOutput);
        this.unFilledPages.writeExternal(objectOutput);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.extentOffset = objectInput.readLong();
        this.extentStart = objectInput.readLong();
        this.extentEnd = objectInput.readLong();
        this.extentLength = objectInput.readInt();
        this.extentStatus = objectInput.readInt();
        this.preAllocLength = objectInput.readInt();
        this.reserved1 = objectInput.readInt();
        this.reserved2 = objectInput.readLong();
        this.reserved3 = objectInput.readLong();
        this.freePages = new FormatableBitSet();
        this.freePages.readExternal(objectInput);
        if ((this.extentStatus & 0x20000000) == 0) {
            FormatableBitSet formatableBitSet = new FormatableBitSet();
            formatableBitSet.readExternal(objectInput);
            this.freePages.or(formatableBitSet);
            this.extentStatus |= 0x20000000;
        }
        if ((this.extentStatus & 0x10000000) == 0x10000000) {
            this.unFilledPages = new FormatableBitSet();
            this.unFilledPages.readExternal(objectInput);
        } else {
            this.unFilledPages = new FormatableBitSet(this.freePages.getLength());
            this.extentStatus |= 0x10000000;
        }
    }

    protected void allocPage(long l2) throws StandardException {
        int n2;
        int n3 = (int)(l2 - this.extentStart);
        if (n3 >= this.freePages.getLength()) {
            n2 = (1 + n3 / 8) * 8;
            if (n2 > (int)(this.extentEnd - this.extentStart + 1L)) {
                n2 = (int)(this.extentEnd - this.extentStart + 1L);
            }
            this.freePages.grow(n2);
            this.unFilledPages.grow(n2);
        }
        if ((n2 = (int)(l2 - this.extentStart + 1L)) > this.extentLength) {
            this.extentLength = n2;
        }
        this.freePages.clear(n3);
    }

    protected void deallocPage(long l2) throws StandardException {
        int n2 = (int)(l2 - this.extentStart);
        this.freePages.set(n2);
        this.unFilledPages.clear(n2);
        this.setExtentFreePageStatus(true);
    }

    protected int compress(BaseContainerHandle baseContainerHandle, RawTransaction rawTransaction, AllocPage allocPage) throws StandardException {
        int n2 = -1;
        int n3 = 0;
        int n4 = this.extentLength - 1;
        while (n4 >= 0 && this.freePages.isSet(n4)) {
            n2 = n4--;
            ++n3;
        }
        n4 = n2 - 1;
        if (n3 > 0) {
            baseContainerHandle.getAllocationActionSet().actionCompressSpaceOperation(rawTransaction, allocPage, n4, n3);
            return n2;
        }
        return -1;
    }

    protected void compressPages(int n2, int n3) {
        if (n2 + 1 >= 0) {
            this.freePages.shrink(n2 + 1);
            this.unFilledPages.shrink(n2 + 1);
            this.preAllocLength = this.extentLength = n2 + 1;
        }
    }

    protected void undoCompressPages(int n2, int n3) {
        if (n2 >= 0) {
            this.freePages.shrink(n2 + 1);
            this.unFilledPages.shrink(n2 + 1);
            this.preAllocLength = this.extentLength = n2 + 1;
        }
    }

    protected long getExtentEnd() {
        return this.extentEnd;
    }

    protected long getFreePageNumber(long l2) {
        if (this.mayHaveFreePage()) {
            int n2;
            int n3 = n2 = l2 < this.extentStart ? this.freePages.anySetBit() : this.freePages.anySetBit((int)(l2 - this.extentStart));
            if (n2 != -1) {
                return (long)n2 + this.extentStart;
            }
            if (l2 < this.extentStart) {
                this.setExtentFreePageStatus(false);
            }
        }
        return this.extentStart + (long)this.extentLength;
    }

    protected long getPageOffset(long l2, int n2, boolean bl) throws StandardException {
        return l2 * (long)n2;
    }

    protected boolean isRetired() {
        return (this.extentStatus & 8) != 0;
    }

    private boolean mayHaveFreePage() {
        return (this.extentStatus & 2) != 0;
    }

    private void setExtentFreePageStatus(boolean bl) {
        this.extentStatus = bl ? (this.extentStatus |= 2) : (this.extentStatus &= 0xFFFFFFFD);
    }

    protected boolean canAddFreePage(long l2) {
        if (this.extentStart + (long)this.extentLength <= this.extentEnd) {
            return true;
        }
        if (!this.mayHaveFreePage()) {
            return false;
        }
        if (l2 < this.extentStart) {
            return this.freePages.anySetBit() != -1;
        }
        return this.freePages.anySetBit((int)(l2 - this.extentStart)) != -1;
    }

    protected int getPageStatus(long l2) {
        int n2 = 0;
        int n3 = (int)(l2 - this.extentStart);
        n2 = this.freePages.isSet(n3) ? 2 : 0;
        return n2;
    }

    protected long getFirstPagenum() {
        return this.extentStart;
    }

    protected long getLastPagenum() {
        return this.extentStart + (long)this.extentLength - 1L;
    }

    protected long getPagenum(int n2) {
        return this.extentStart + (long)n2;
    }

    protected long getLastPreallocPagenum() {
        if (this.extentLength > this.preAllocLength) {
            this.preAllocLength = this.extentLength;
        }
        return this.extentStart + (long)this.preAllocLength - 1L;
    }

    protected void setLastPreallocPagenum(long l2) {
        if (l2 > this.extentEnd) {
            l2 = this.extentEnd;
        }
        this.preAllocLength = (int)(l2 - this.extentStart + 1L);
    }

    protected long getNextValidPageNumber(long l2) {
        int n2;
        long l3;
        long l4 = this.getLastPagenum();
        for (l3 = l2 < this.extentStart ? this.extentStart : l2 + 1L; l3 <= l4 && (n2 = this.getPageStatus(l3)) != 0; ++l3) {
        }
        if (l3 > l4) {
            l3 = -1L;
        }
        return l3;
    }

    protected long getLastValidPageNumber() {
        int n2;
        long l2;
        for (l2 = this.getLastPagenum(); l2 >= this.extentStart && (n2 = this.getPageStatus(l2)) != 0; --l2) {
        }
        if (l2 < this.extentStart) {
            l2 = -1L;
        }
        return l2;
    }

    private void checkInRange(long l2) {
    }

    protected void updateUnfilledPageInfo(AllocExtent allocExtent) {
        this.unFilledPages = allocExtent.unFilledPages;
        this.extentStatus = this.unFilledPages.anySetBit() >= 0 ? (this.extentStatus |= 0x10) : (this.extentStatus &= 0xFFFFFFEF);
    }

    protected boolean trackUnfilledPage(long l2, boolean bl) {
        this.checkInRange(l2);
        int n2 = (int)(l2 - this.extentStart);
        boolean bl2 = this.unFilledPages.isSet(n2);
        if (bl != bl2) {
            if (bl) {
                this.unFilledPages.set(n2);
                this.extentStatus |= 0x10;
            } else {
                this.unFilledPages.clear(n2);
            }
            return true;
        }
        return false;
    }

    protected long getUnfilledPageNumber(long l2) {
        if ((this.extentStatus & 0x10) == 0) {
            return -1L;
        }
        int n2 = this.unFilledPages.anySetBit();
        if (n2 != -1) {
            if ((long)n2 + this.extentStart != l2) {
                return (long)n2 + this.extentStart;
            }
            if ((n2 = this.unFilledPages.anySetBit(n2)) != -1) {
                return (long)n2 + this.extentStart;
            }
        }
        return -1L;
    }

    protected int getAllocatedPageCount() {
        int n2 = this.extentLength;
        if (!this.mayHaveFreePage()) {
            return n2;
        }
        byte[] byArray = this.freePages.getByteArray();
        int n3 = byArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (byArray[i2] == 0) continue;
            for (int i3 = 0; i3 < 8; ++i3) {
                if ((1 << i3 & byArray[i2]) == 0) continue;
                --n2;
            }
        }
        return n2;
    }

    protected int getUnfilledPageCount() {
        int n2 = 0;
        int n3 = this.freePages.size();
        for (int i2 = 0; i2 < this.unFilledPages.size(); ++i2) {
            if (!this.unFilledPages.isSet(i2) || i2 < n3 && this.freePages.isSet(i2)) continue;
            ++n2;
        }
        return n2;
    }

    protected int getTotalPageCount() {
        return this.extentLength;
    }

    protected String toDebugString() {
        return null;
    }
}

