/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.services.io.LimitObjectInput;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.impl.store.raw.data.BasePage;
import org.apache.derby.impl.store.raw.data.PhysicalPageOperation;

public final class InitPageOperation
extends PhysicalPageOperation {
    protected int nextRecordId;
    protected int initFlag;
    protected int pageFormatId;
    protected long pageOffset;
    protected boolean reuse;
    protected boolean overflowPage;

    InitPageOperation(BasePage basePage, int n2, int n3, long l2) throws StandardException {
        super(basePage);
        this.initFlag = n2;
        this.pageFormatId = n3;
        this.pageOffset = l2;
        this.nextRecordId = (this.initFlag & 4) == 0 ? basePage.newRecordId() : 6;
    }

    public InitPageOperation() {
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        CompressedNumber.writeInt(objectOutput, this.nextRecordId);
        CompressedNumber.writeInt(objectOutput, this.initFlag);
        CompressedNumber.writeLong(objectOutput, this.pageOffset);
        objectOutput.writeInt(this.pageFormatId);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.nextRecordId = CompressedNumber.readInt(objectInput);
        this.initFlag = CompressedNumber.readInt(objectInput);
        this.pageOffset = CompressedNumber.readLong(objectInput);
        this.pageFormatId = objectInput.readInt();
    }

    @Override
    public int getTypeFormatId() {
        return 241;
    }

    @Override
    public void doMe(Transaction transaction, LogInstant logInstant, LimitObjectInput limitObjectInput) throws StandardException, IOException {
        boolean bl = (this.initFlag & 2) != 0;
        boolean bl2 = (this.initFlag & 1) != 0;
        this.page.initPage(logInstant, (byte)1, this.nextRecordId, bl, bl2);
    }

    @Override
    protected BasePage getPageForRedoRecovery(Transaction transaction) throws StandardException {
        BasePage basePage = super.getPageForRedoRecovery(transaction);
        if (basePage != null) {
            return basePage;
        }
        basePage = (BasePage)this.containerHdl.reCreatePageForRedoRecovery(this.pageFormatId, this.getPageId().getPageNumber(), this.pageOffset);
        return basePage;
    }

    @Override
    public void undoMe(Transaction transaction, BasePage basePage, LogInstant logInstant, LimitObjectInput limitObjectInput) throws StandardException, IOException {
        basePage.setPageStatus(logInstant, (byte)2);
        basePage.setAuxObject(null);
    }

    @Override
    public void restoreMe(Transaction transaction, BasePage basePage, LogInstant logInstant, LimitObjectInput limitObjectInput) throws StandardException, IOException {
        this.undoMe(transaction, basePage, logInstant, limitObjectInput);
    }

    @Override
    public String toString() {
        return null;
    }
}

