/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.tools.dblook;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derby.impl.tools.dblook.Logs;
import org.apache.derby.tools.dblook;

public class DB_Trigger {
    private static final String TRIGGERNAME = "TRIGGERNAME";
    private static final String SCHEMAID = "SCHEMAID";
    private static final String EVENT = "EVENT";
    private static final String FIRINGTIME = "FIRINGTIME";
    private static final String TYPE = "TYPE";
    private static final String TABLEID = "TABLEID";
    private static final String REFERENCEDCOLUMNS = "REFERENCEDCOLUMNS";
    private static final String TRIGGERDEFINITION = "TRIGGERDEFINITION";
    private static final String REFERENCINGOLD = "REFERENCINGOLD";
    private static final String REFERENCINGNEW = "REFERENCINGNEW";
    private static final String OLDREFERENCINGNAME = "OLDREFERENCINGNAME";
    private static final String NEWREFERENCINGNAME = "NEWREFERENCINGNAME";
    private static final String WHENCLAUSETEXT = "WHENCLAUSETEXT";

    public static void doTriggers(Connection connection, boolean bl) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT * FROM SYS.SYSTRIGGERS WHERE STATE != 'D' ORDER BY CREATIONTIMESTAMP");
        boolean bl2 = true;
        while (resultSet.next()) {
            String string;
            String string2 = dblook.addQuotes(dblook.expandDoubleQuotes(resultSet.getString(TRIGGERNAME)));
            String string3 = dblook.lookupSchemaId(resultSet.getString(SCHEMAID));
            if (dblook.isIgnorableSchema(string3)) continue;
            string2 = string3 + "." + string2;
            String string4 = dblook.lookupTableId(resultSet.getString(TABLEID));
            String string5 = string = bl ? resultSet.getString(WHENCLAUSETEXT) : null;
            if (!dblook.stringContainsTargetTable(resultSet.getString(TRIGGERDEFINITION)) && !dblook.stringContainsTargetTable(string) && dblook.isExcludedTable(string4)) continue;
            if (bl2) {
                Logs.reportString("----------------------------------------------");
                Logs.reportMessage("DBLOOK_TriggersHeader");
                Logs.reportString("----------------------------------------------\n");
            }
            String string6 = DB_Trigger.createTrigger(string2, string4, string, resultSet);
            Logs.writeToNewDDL(string6);
            Logs.writeStmtEndToNewDDL();
            Logs.writeNewlineToNewDDL();
            bl2 = false;
        }
        resultSet.close();
        statement.close();
    }

    private static String createTrigger(String string, String string2, String string3, ResultSet resultSet) throws SQLException {
        StringBuilder stringBuilder = new StringBuilder("CREATE TRIGGER ");
        stringBuilder.append(string);
        if (resultSet.getString(FIRINGTIME).charAt(0) == 'A') {
            stringBuilder.append(" AFTER ");
        } else {
            stringBuilder.append(" NO CASCADE BEFORE ");
        }
        String string4 = resultSet.getString(EVENT);
        switch (string4.charAt(0)) {
            case 'I': {
                stringBuilder.append("INSERT");
                break;
            }
            case 'D': {
                stringBuilder.append("DELETE");
                break;
            }
            case 'U': {
                stringBuilder.append("UPDATE");
                String string5 = resultSet.getString(REFERENCEDCOLUMNS);
                if (resultSet.wasNull() || string5.equals("NULL")) break;
                stringBuilder.append(" OF ");
                stringBuilder.append(dblook.getColumnListFromDescription(resultSet.getString(TABLEID), string5));
                break;
            }
            default: {
                Logs.debug("INTERNAL ERROR: unexpected trigger event: " + string4, (String)null);
            }
        }
        stringBuilder.append(" ON ");
        stringBuilder.append(string2);
        char c2 = resultSet.getString(TYPE).charAt(0);
        String string6 = resultSet.getString(OLDREFERENCINGNAME);
        String string7 = resultSet.getString(NEWREFERENCINGNAME);
        if (string6 != null || string7 != null) {
            stringBuilder.append(" REFERENCING");
            if (resultSet.getBoolean(REFERENCINGOLD)) {
                stringBuilder.append(" OLD");
                if (c2 == 'S') {
                    stringBuilder.append("_TABLE AS ");
                } else {
                    stringBuilder.append(" AS ");
                }
                stringBuilder.append(string6);
            }
            if (resultSet.getBoolean(REFERENCINGNEW)) {
                stringBuilder.append(" NEW");
                if (c2 == 'S') {
                    stringBuilder.append("_TABLE AS ");
                } else {
                    stringBuilder.append(" AS ");
                }
                stringBuilder.append(string7);
            }
        }
        stringBuilder.append(" FOR EACH ");
        if (c2 == 'S') {
            stringBuilder.append("STATEMENT ");
        } else {
            stringBuilder.append("ROW ");
        }
        if (string3 != null) {
            stringBuilder.append("WHEN (");
            stringBuilder.append(dblook.removeNewlines(string3));
            stringBuilder.append(") ");
        }
        stringBuilder.append(dblook.removeNewlines(resultSet.getString(TRIGGERDEFINITION)));
        return stringBuilder.toString();
    }
}

