/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.tools.ij;

import java.io.IOException;
import java.io.Reader;
import org.apache.derby.iapi.tools.i18n.LocalizedInput;
import org.apache.derby.iapi.tools.i18n.LocalizedOutput;
import org.apache.derby.impl.tools.ij.ijException;
import org.apache.derby.impl.tools.ij.utilMain;

public class StatementFinder {
    private Reader source;
    private StringBuffer statement = new StringBuffer();
    private int state;
    private boolean atEOF = false;
    private boolean peekEOF = false;
    private char peekChar;
    private boolean peeked = false;
    private LocalizedOutput promptwriter;
    private boolean doPrompt;
    private boolean continuedStatement;
    private static final int IN_STATEMENT = 0;
    private static final int IN_STRING = 1;
    private static final int IN_SQLCOMMENT = 2;
    private static final int END_OF_STATEMENT = 3;
    private static final int END_OF_INPUT = 4;
    private static final char MINUS = '-';
    private static final char SINGLEQUOTE = '\'';
    private static final char DOUBLEQUOTE = '\"';
    private static final char SEMICOLON = ';';
    private static final char NEWLINE = '\n';
    private static final char RETURN = '\r';
    private static final char SPACE = ' ';
    private static final char TAB = '\t';
    private static final char FORMFEED = '\f';
    private static final char SLASH = '/';
    private static final char ASTERISK = '*';

    public StatementFinder(LocalizedInput localizedInput, LocalizedOutput localizedOutput) {
        this.source = localizedInput;
        if (localizedOutput != null && localizedInput.isStandardInput()) {
            this.promptwriter = localizedOutput;
            this.doPrompt = true;
        } else {
            this.doPrompt = false;
        }
    }

    public void ReInit(LocalizedInput localizedInput) {
        try {
            this.source.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.source = localizedInput;
        this.state = 0;
        this.atEOF = false;
        this.peekEOF = false;
        this.peeked = false;
        this.doPrompt = localizedInput.isStandardInput() && this.promptwriter != null;
    }

    public void close() throws IOException {
        this.source.close();
    }

    public String nextStatement() {
        boolean bl = false;
        this.statement.setLength(0);
        if (this.state == 4) {
            return null;
        }
        this.state = 0;
        char c2 = this.peekChar();
        if (this.peekEOF()) {
            this.state = 4;
            return null;
        }
        if (this.whiteSpace(c2)) {
            while (this.whiteSpace(this.peekChar()) && !this.peekEOF()) {
            }
            if (this.peekEOF()) {
                this.state = 4;
                return null;
            }
        }
        while (this.state != 3 && this.state != 4) {
            c2 = this.readChar();
            if (this.atEOF()) {
                this.state = 4;
                break;
            }
            if (c2 != '-') {
                this.continuedStatement = true;
            }
            switch (c2) {
                case '-': {
                    this.readSingleLineComment(c2);
                    break;
                }
                case '/': {
                    this.readBracketedComment();
                    break;
                }
                case '\"': 
                case '\'': {
                    this.readString(c2);
                    break;
                }
                case ';': {
                    bl = true;
                    this.state = 3;
                    this.continuedStatement = false;
                    break;
                }
                case '\n': 
                case '\r': {
                    if (!this.doPrompt) break;
                    utilMain.doPrompt(false, this.promptwriter, "");
                    if (c2 != '\r' || this.peekChar() != '\n') break;
                    this.readChar();
                }
            }
        }
        if (bl) {
            this.statement.setLength(this.statement.length() - 1);
        }
        return this.statement.toString();
    }

    private boolean whiteSpace(char c2) {
        return c2 == ' ' || c2 == '\t' || c2 == '\r' || c2 == '\n' || c2 == '\f';
    }

    private void readBracketedComment() {
        char c2 = this.peekChar();
        if (this.peekEOF()) {
            return;
        }
        if (c2 != '*') {
            this.continuedStatement = true;
            return;
        }
        this.readChar();
        int n2 = 1;
        while (true) {
            c2 = this.readChar();
            if (this.atEOF()) {
                this.state = 0;
                return;
            }
            char c3 = this.peekChar();
            if (c2 == '/' && c3 == '*') {
                this.readChar();
                ++n2;
                continue;
            }
            if (c2 == '*' && c3 == '/') {
                this.readChar();
                if (--n2 != 0) continue;
                this.state = 0;
                return;
            }
            if (c2 != '\n' && c2 != '\r' || !this.doPrompt) continue;
            utilMain.doPrompt(false, this.promptwriter, "");
            if (c2 != '\r' || c3 != '\n') continue;
            this.readChar();
        }
    }

    private void readSingleLineComment(char c2) {
        char c3 = this.peekChar();
        if (this.peekEOF()) {
            return;
        }
        if (c3 != c2) {
            this.continuedStatement = true;
            return;
        }
        this.readChar();
        this.state = 2;
        do {
            c3 = this.peekChar();
            if (this.peekEOF()) {
                this.state = 0;
                return;
            }
            switch (c3) {
                case '\n': 
                case '\r': {
                    this.readChar();
                    this.state = 0;
                    if (this.doPrompt) {
                        if (this.continuedStatement) {
                            utilMain.doPrompt(false, this.promptwriter, "");
                        } else {
                            utilMain.doPrompt(true, this.promptwriter, "");
                        }
                        if (c3 == '\r' && this.peekChar() == '\n') {
                            this.readChar();
                        }
                    }
                    return;
                }
            }
            this.readChar();
        } while (this.state == 2);
    }

    private void readString(char c2) {
        this.state = 1;
        do {
            char c3 = this.readChar();
            if (this.atEOF()) {
                this.state = 4;
                return;
            }
            if (c3 != c2) continue;
            this.state = 0;
            return;
        } while (this.state == 1);
    }

    private boolean atEOF() {
        return this.atEOF;
    }

    private boolean peekEOF() {
        return this.peekEOF;
    }

    private char readChar() {
        if (!this.peeked) {
            this.peekChar();
        }
        this.peeked = false;
        this.atEOF = this.peekEOF;
        if (!this.atEOF) {
            this.statement.append(this.peekChar);
        }
        return this.peekChar;
    }

    private char peekChar() {
        this.peeked = true;
        char c2 = '\u0000';
        try {
            int n2 = this.source.read();
            boolean bl = this.peekEOF = n2 == -1;
            if (!this.peekEOF) {
                c2 = (char)n2;
            }
        }
        catch (IOException iOException) {
            throw ijException.iOException(iOException);
        }
        this.peekChar = c2;
        return c2;
    }
}

