/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.tools.ij;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.List;
import org.apache.derby.iapi.tools.ToolUtils;
import org.apache.derby.impl.tools.ij.ijResultImpl;

public class ijMultipleResultSetResult
extends ijResultImpl {
    private ArrayList<ResultSet> resultSets = new ArrayList();
    private int[] displayColumns = null;
    private int[] columnWidths = null;

    public ijMultipleResultSetResult(List<ResultSet> list, int[] nArray, int[] nArray2) throws SQLException {
        this.resultSets.addAll(list);
        this.displayColumns = ToolUtils.copy(nArray);
        this.columnWidths = ToolUtils.copy(nArray2);
    }

    public void addResultSet(ResultSet resultSet) {
        this.resultSets.add(resultSet);
    }

    @Override
    public boolean isMultipleResultSetResult() {
        return true;
    }

    @Override
    public List<ResultSet> getMultipleResultSets() {
        return new ArrayList<ResultSet>(this.resultSets);
    }

    @Override
    public void closeStatement() throws SQLException {
        if (this.resultSets != null) {
            ResultSet resultSet = null;
            for (int i2 = 0; i2 < this.resultSets.size(); ++i2) {
                resultSet = this.resultSets.get(i2);
                if (resultSet.getStatement() != null) {
                    resultSet.getStatement().close();
                    continue;
                }
                resultSet.close();
            }
        }
    }

    @Override
    public int[] getColumnDisplayList() {
        return ToolUtils.copy(this.displayColumns);
    }

    @Override
    public int[] getColumnWidthList() {
        return ToolUtils.copy(this.columnWidths);
    }

    @Override
    public SQLWarning getSQLWarnings() throws SQLException {
        SQLWarning sQLWarning = null;
        ResultSet resultSet = null;
        for (int i2 = 0; i2 < this.resultSets.size(); ++i2) {
            resultSet = this.resultSets.get(i2);
            if (resultSet.getWarnings() == null) continue;
            if (sQLWarning == null) {
                sQLWarning = resultSet.getWarnings();
                continue;
            }
            sQLWarning.setNextWarning(resultSet.getWarnings());
        }
        return sQLWarning;
    }

    @Override
    public void clearSQLWarnings() throws SQLException {
        for (int i2 = 0; i2 < this.resultSets.size(); ++i2) {
            this.resultSets.get(i2).clearWarnings();
        }
    }
}

