/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.Private
public enum ErasureCodingPolicyState {
    DISABLED(1),
    ENABLED(2),
    REMOVED(3);

    private static final ErasureCodingPolicyState[] CACHED_VALUES;
    private final int value;

    private ErasureCodingPolicyState(int v2) {
        this.value = v2;
    }

    public int getValue() {
        return this.value;
    }

    public static ErasureCodingPolicyState fromValue(int v2) {
        if (v2 > 0 && v2 <= CACHED_VALUES.length) {
            return CACHED_VALUES[v2 - 1];
        }
        return null;
    }

    public static ErasureCodingPolicyState read(DataInput in) throws IOException {
        return ErasureCodingPolicyState.fromValue(in.readByte());
    }

    public void write(DataOutput out) throws IOException {
        out.writeByte(this.ordinal());
    }

    static {
        CACHED_VALUES = ErasureCodingPolicyState.values();
    }
}

