/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web.resources;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import org.apache.hadoop.hdfs.web.resources.Param;
import org.apache.hadoop.util.StringUtils;

abstract class EnumSetParam<E extends Enum<E>>
extends Param<EnumSet<E>, Domain<E>> {
    static <E extends Enum<E>> String toString(EnumSet<E> set) {
        if (set == null || set.isEmpty()) {
            return "";
        }
        StringBuilder b2 = new StringBuilder();
        Iterator i2 = set.iterator();
        b2.append(i2.next());
        while (i2.hasNext()) {
            b2.append(',').append(i2.next());
        }
        return b2.toString();
    }

    static <E extends Enum<E>> EnumSet<E> toEnumSet(Class<E> clazz, E[] values) {
        EnumSet<E> set = EnumSet.noneOf(clazz);
        set.addAll(Arrays.asList(values));
        return set;
    }

    EnumSetParam(Domain<E> domain, EnumSet<E> value) {
        super(domain, value);
    }

    @Override
    public String toString() {
        return this.getName() + "=" + EnumSetParam.toString((EnumSet)this.value);
    }

    @Override
    public String getValueString() {
        return EnumSetParam.toString((EnumSet)this.value);
    }

    static final class Domain<E extends Enum<E>>
    extends Param.Domain<EnumSet<E>> {
        private final Class<E> enumClass;

        Domain(String name, Class<E> enumClass) {
            super(name);
            this.enumClass = enumClass;
        }

        @Override
        public final String getDomain() {
            return Arrays.asList(this.enumClass.getEnumConstants()).toString();
        }

        @Override
        final EnumSet<E> parse(String str) {
            EnumSet<E> set = EnumSet.noneOf(this.enumClass);
            if (!str.isEmpty()) {
                int j2 = 0;
                while (j2 >= 0) {
                    int i2 = j2 > 0 ? j2 + 1 : 0;
                    j2 = str.indexOf(44, i2);
                    String sub = j2 >= 0 ? str.substring(i2, j2) : str.substring(i2);
                    set.add(Enum.valueOf(this.enumClass, StringUtils.toUpperCase((String)sub.trim())));
                }
            }
            return set;
        }
    }
}

