/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.snappy;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import org.codehaus.plexus.archiver.AbstractUnArchiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.util.Streams;
import org.iq80.snappy.SnappyInputStream;

public class SnappyUnArchiver
extends AbstractUnArchiver {
    private static final String OPERATION_SNAPPY = "snappy";

    public SnappyUnArchiver() {
    }

    public SnappyUnArchiver(File sourceFile) {
        super(sourceFile);
    }

    @Override
    protected void execute() throws ArchiverException {
        if (this.getSourceFile().lastModified() > this.getDestFile().lastModified()) {
            this.getLogger().info("Expanding " + this.getSourceFile().getAbsolutePath() + " to " + this.getDestFile().getAbsolutePath());
            Streams.copyFully(SnappyUnArchiver.getSnappyInputStream(Streams.bufferedInputStream(Streams.fileInputStream(this.getSourceFile(), OPERATION_SNAPPY))), Streams.bufferedOutputStream(Streams.fileOutputStream(this.getDestFile(), OPERATION_SNAPPY)), OPERATION_SNAPPY);
        }
    }

    @Nonnull
    public static SnappyInputStream getSnappyInputStream(InputStream bis) throws ArchiverException {
        try {
            return new SnappyInputStream(bis);
        }
        catch (IOException e2) {
            throw new ArchiverException("Trouble creating Snappy compressor, invalid file ?", e2);
        }
    }

    @Override
    protected void execute(String path, File outputDirectory) {
        throw new UnsupportedOperationException("Targeted extraction not supported in Snappy format.");
    }
}

