/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.zip;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import javax.annotation.Nonnull;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.commons.io.input.CountingInputStream;
import org.codehaus.plexus.archiver.AbstractUnArchiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.components.io.resources.PlexusIoResource;

public abstract class AbstractZipUnArchiver
extends AbstractUnArchiver {
    private static final String NATIVE_ENCODING = "native-encoding";
    private String encoding = "UTF8";
    private long maxOutputSize = Long.MAX_VALUE;

    public AbstractZipUnArchiver() {
    }

    public AbstractZipUnArchiver(File sourceFile) {
        super(sourceFile);
    }

    public void setEncoding(String encoding) {
        if (NATIVE_ENCODING.equals(encoding)) {
            encoding = null;
        }
        this.encoding = encoding;
    }

    public void setMaxOutputSize(long maxOutputSize) {
        if (maxOutputSize <= 0L) {
            throw new IllegalArgumentException("Invalid max output size specified: " + maxOutputSize);
        }
        this.maxOutputSize = maxOutputSize;
    }

    @Override
    protected void execute() throws ArchiverException {
        this.execute("", this.getDestDirectory());
    }

    private String resolveSymlink(ZipFile zf, ZipArchiveEntry ze) throws IOException {
        if (ze.isUnixSymlink()) {
            return zf.getUnixSymlink(ze);
        }
        return null;
    }

    @Override
    protected void execute(String path, File outputDirectory) throws ArchiverException {
        this.getLogger().debug("Expanding: " + this.getSourceFile() + " into " + outputDirectory);
        try (ZipFile zipFile = new ZipFile(this.getSourceFile(), this.encoding, true);){
            long remainingSpace = this.maxOutputSize;
            Enumeration<ZipArchiveEntry> e2 = zipFile.getEntriesInPhysicalOrder();
            while (e2.hasMoreElements()) {
                ZipArchiveEntry ze = e2.nextElement();
                ZipEntryFileInfo fileInfo = new ZipEntryFileInfo(zipFile, ze);
                if (!this.isSelected(ze.getName(), fileInfo) || !ze.getName().startsWith(path)) continue;
                InputStream in = zipFile.getInputStream(ze);
                Throwable throwable = null;
                try {
                    BoundedInputStream bis = new BoundedInputStream(in, remainingSpace + 1L);
                    CountingInputStream cis = new CountingInputStream(bis);
                    this.extractFile(this.getSourceFile(), outputDirectory, cis, ze.getName(), new Date(ze.getTime()), ze.isDirectory(), ze.getUnixMode() != 0 ? Integer.valueOf(ze.getUnixMode()) : null, this.resolveSymlink(zipFile, ze), this.getFileMappers());
                    if ((remainingSpace -= cis.getByteCount()) >= 0L) continue;
                    throw new ArchiverException("Maximum output size limit reached");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    in.close();
                }
            }
            this.getLogger().debug("expand complete");
        }
        catch (IOException ioe) {
            throw new ArchiverException("Error while expanding " + this.getSourceFile().getAbsolutePath(), ioe);
        }
    }

    private static class ZipEntryFileInfo
    implements PlexusIoResource {
        private final ZipFile zipFile;
        private final ZipArchiveEntry zipEntry;

        ZipEntryFileInfo(ZipFile zipFile, ZipArchiveEntry zipEntry) {
            this.zipFile = zipFile;
            this.zipEntry = zipEntry;
        }

        @Override
        public String getName() {
            return this.zipEntry.getName();
        }

        @Override
        public boolean isDirectory() {
            return this.zipEntry.isDirectory();
        }

        @Override
        public boolean isFile() {
            return !this.zipEntry.isDirectory() && !this.zipEntry.isUnixSymlink();
        }

        @Override
        public boolean isSymbolicLink() {
            return this.zipEntry.isUnixSymlink();
        }

        @Override
        @Nonnull
        public InputStream getContents() throws IOException {
            return this.zipFile.getInputStream(this.zipEntry);
        }

        @Override
        public long getLastModified() {
            long l2 = this.zipEntry.getTime();
            return l2 == 0L ? 0L : l2;
        }

        @Override
        public long getSize() {
            long l2 = this.zipEntry.getSize();
            return l2 == -1L ? -1L : l2;
        }

        @Override
        public URL getURL() throws IOException {
            return null;
        }

        @Override
        public boolean isExisting() {
            return true;
        }
    }
}

