/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.wire;

import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.spi.Element;
import com.google.inject.spi.Elements;
import java.util.Arrays;
import org.eclipse.sisu.inject.DefaultBeanLocator;
import org.eclipse.sisu.wire.ElementAnalyzer;
import org.eclipse.sisu.wire.WireModule;

public final class ChildWireModule
implements Module {
    private final Injector parent;
    private final Iterable<Module> modules;
    private WireModule.Strategy strategy = WireModule.Strategy.DEFAULT;

    public ChildWireModule(Injector parent, Module ... modules) {
        this(parent, Arrays.asList(modules));
    }

    public ChildWireModule(Injector parent, Iterable<Module> modules) {
        this.modules = modules;
        this.parent = parent;
    }

    public Module with(WireModule.Strategy _strategy) {
        this.strategy = _strategy;
        return this;
    }

    @Override
    public void configure(Binder binder) {
        binder.requestStaticInjection(DefaultBeanLocator.class);
        ElementAnalyzer analyzer = new ElementAnalyzer(binder);
        Injector i2 = this.parent;
        while (i2 != null) {
            analyzer.ignoreKeys(i2.getAllBindings().keySet());
            i2 = i2.getParent();
        }
        for (Element e2 : Elements.getElements(this.modules)) {
            e2.acceptVisitor(analyzer);
        }
        analyzer.apply(this.strategy);
    }
}

