/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.configuration.configurators;

import java.io.File;
import java.util.Map;
import org.jahia.configuration.configurators.AbstractXMLConfigurator;
import org.jahia.configuration.configurators.ConfigFile;
import org.jahia.configuration.configurators.JahiaConfigInterface;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;

public class MailServerConfigurator
extends AbstractXMLConfigurator {
    private JahiaConfigInterface cfg;

    public MailServerConfigurator(Map dbProperties, JahiaConfigInterface jahiaConfigInterface) {
        super(dbProperties, jahiaConfigInterface);
        this.cfg = jahiaConfigInterface;
    }

    @Override
    public void updateConfiguration(ConfigFile sourceConfigFile, String destFileName) throws Exception {
        if (sourceConfigFile == null) {
            return;
        }
        SAXBuilder saxBuilder = new SAXBuilder();
        saxBuilder.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        Document jdomDocument = saxBuilder.build(sourceConfigFile.getInputStream());
        Element el = this.getElement(jdomDocument.getRootElement(), "/content/settings/mail-server");
        if (el != null && this.cfg.getMailServer() != null && this.cfg.getMailServer().length() > 0) {
            Namespace jahiaNamespace = el.getNamespace("j");
            el.setAttribute("activated", "true", jahiaNamespace);
            el.setAttribute("uri", this.cfg.getMailServer(), jahiaNamespace);
            if (this.cfg.getMailFrom() != null) {
                el.setAttribute("from", this.cfg.getMailFrom(), jahiaNamespace);
            }
            if (this.cfg.getMailAdministrator() != null) {
                el.setAttribute("to", this.cfg.getMailAdministrator(), jahiaNamespace);
            }
            if (this.cfg.getMailParanoia() != null) {
                el.setAttribute("notificationLevel", this.cfg.getMailParanoia(), jahiaNamespace);
            }
        }
        this.write(jdomDocument, new File(destFileName));
    }
}

