/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.configuration.configurators;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.codehaus.plexus.util.StringUtils;

public class PropertiesManager {
    private Map<String, Object> properties = new LinkedHashMap<String, Object>();
    private Set<String> modifiedProperties = new HashSet<String>();
    private boolean loadedFromInputStream = false;
    private Set<String> removedPropertyNames = new HashSet<String>();
    private boolean unmodifiedCommentingActivated = false;
    private String additionalPropertiesMessage = "The following properties were added.";
    private Map<String, PropertyLayout> propertyLayouts = new LinkedHashMap<String, PropertyLayout>();
    boolean additionalMessageAdded = false;
    private boolean replaceTabsWithSpaces = true;
    private boolean sanitizeValue = true;

    public PropertiesManager() {
    }

    public PropertiesManager(InputStream sourcePropertiesInputStream) throws IOException {
        this.loadProperties(sourcePropertiesInputStream);
    }

    public PropertiesManager(Properties properties) {
        this.properties.clear();
        for (String propertyName : properties.stringPropertyNames()) {
            this.setProperty(propertyName, properties.getProperty(propertyName));
        }
    }

    private void loadProperties(InputStream sourcePropertiesInputStream) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(sourcePropertiesInputStream, "ISO-8859-1"));
        String currentLine = null;
        boolean inMultilineValue = false;
        PropertyLayout currentPropertyLayout = new PropertyLayout();
        while ((currentLine = reader.readLine()) != null) {
            int valueSeparatorPos = -1;
            if (!inMultilineValue) {
                valueSeparatorPos = this.getValueSeparatorPos(currentLine);
            }
            if (inMultilineValue && currentLine.trim().equals("")) {
                if (currentPropertyLayout.getValueLines().size() > 0) {
                    currentPropertyLayout.getValueLines().add(currentLine);
                    this.properties.put(currentPropertyLayout.getName(), currentPropertyLayout.getValue());
                    this.propertyLayouts.put(currentPropertyLayout.getName(), currentPropertyLayout);
                    currentPropertyLayout = new PropertyLayout();
                }
                inMultilineValue = false;
                continue;
            }
            if (currentLine.trim().equals("") || currentLine.trim().startsWith("#") || currentLine.trim().startsWith("!")) {
                currentPropertyLayout.getComments().add(currentLine);
                continue;
            }
            if (valueSeparatorPos >= 0) {
                if (currentPropertyLayout.getNameLine() != null && currentPropertyLayout.getValueLines().size() > 0) {
                    this.properties.put(currentPropertyLayout.getName(), currentPropertyLayout.getValue());
                    this.propertyLayouts.put(currentPropertyLayout.getName(), currentPropertyLayout);
                    currentPropertyLayout = new PropertyLayout();
                }
                currentPropertyLayout.setNameLine(this.unescapeNonASCII(currentLine.substring(0, valueSeparatorPos)));
                currentPropertyLayout.setSeparator(currentLine.substring(valueSeparatorPos, valueSeparatorPos + 1));
                currentPropertyLayout.setName(currentPropertyLayout.getNameLine().trim());
                String lastPropertyLine = this.unescapeNonASCII(currentLine.substring(valueSeparatorPos + 1));
                if (lastPropertyLine == null) {
                    lastPropertyLine = "";
                }
                if (lastPropertyLine.trim().endsWith("\\")) {
                    inMultilineValue = true;
                    lastPropertyLine = StringUtils.stripEnd(lastPropertyLine, "\\");
                    currentPropertyLayout.getValueLines().add(lastPropertyLine);
                    continue;
                }
                currentPropertyLayout.getValueLines().add(lastPropertyLine);
                this.properties.put(currentPropertyLayout.getName(), currentPropertyLayout.getValue());
                this.propertyLayouts.put(currentPropertyLayout.getName(), currentPropertyLayout);
                inMultilineValue = false;
                currentPropertyLayout = new PropertyLayout();
                continue;
            }
            if (inMultilineValue) {
                if (currentLine.trim().endsWith("\\")) {
                    currentLine = this.unescapeNonASCII(StringUtils.stripEnd(currentLine, "\\"));
                    currentPropertyLayout.getValueLines().add(currentLine);
                    continue;
                }
                currentPropertyLayout.getValueLines().add(this.unescapeNonASCII(currentLine));
                this.properties.put(currentPropertyLayout.getName(), currentPropertyLayout.getValue());
                this.propertyLayouts.put(currentPropertyLayout.getName(), currentPropertyLayout);
                inMultilineValue = false;
                currentPropertyLayout = new PropertyLayout();
                continue;
            }
            currentPropertyLayout.setNameLine(this.unescapeNonASCII(currentLine));
            currentPropertyLayout.setName(currentPropertyLayout.getNameLine().trim());
            this.properties.put(currentPropertyLayout.getName(), "");
            this.propertyLayouts.put(currentPropertyLayout.getName(), currentPropertyLayout);
            inMultilineValue = false;
            currentPropertyLayout = new PropertyLayout();
        }
        IOUtils.closeQuietly(reader);
        this.loadedFromInputStream = true;
    }

    public String getProperty(String propertyName) {
        return this.toString(this.properties.get(propertyName));
    }

    public Object getRawProperty(String propertyName) {
        return this.properties.get(propertyName);
    }

    public void setProperty(String propertyName, String propvalue) {
        PropertyLayout propertyLayout;
        String oldValue = (String)this.properties.put(propertyName, propvalue);
        if (!StringUtils.equals(oldValue, propvalue)) {
            this.modifiedProperties.add(propertyName);
        }
        if ((propertyLayout = this.propertyLayouts.get(propertyName)) == null) {
            propertyLayout = new PropertyLayout();
            propertyLayout.setName(propertyName);
            propertyLayout.setNameLine(propertyName);
            if (this.getAdditionalPropertiesMessage() != null && !this.additionalMessageAdded) {
                propertyLayout.getComments().add("# " + this.getAdditionalPropertiesMessage());
                this.additionalMessageAdded = true;
            }
        }
        propertyLayout.getValueLines().clear();
        propertyLayout.getValueLines().add(" " + propvalue);
        this.propertyLayouts.put(propertyName, propertyLayout);
    }

    public void setProperty(String propertyName, Object[] propertyValues) {
        PropertyLayout propertyLayout;
        String newValueString;
        Object oldValue = this.properties.put(propertyName, propertyValues);
        String oldValueString = this.toString(oldValue);
        if (!StringUtils.equals(oldValueString, newValueString = this.toString(propertyValues))) {
            this.modifiedProperties.add(propertyName);
        }
        if ((propertyLayout = this.propertyLayouts.get(propertyName)) == null) {
            propertyLayout = new PropertyLayout();
            propertyLayout.setName(propertyName);
            propertyLayout.setNameLine(propertyName);
            if (this.getAdditionalPropertiesMessage() != null && !this.additionalMessageAdded) {
                propertyLayout.getComments().add("# " + this.getAdditionalPropertiesMessage());
                this.additionalMessageAdded = true;
            }
        }
        propertyLayout.getValueLines().clear();
        boolean i2 = false;
        for (Object propertyValue : propertyValues) {
            if (!i2) {
                propertyLayout.getValueLines().add(" " + propertyValue.toString());
                continue;
            }
            propertyLayout.getValueLines().add("  " + propertyValue.toString());
        }
        this.propertyLayouts.put(propertyName, propertyLayout);
    }

    public void removeProperty(String propertyName) {
        this.properties.remove(propertyName);
        this.propertyLayouts.remove(propertyName);
        this.removedPropertyNames.add(propertyName);
    }

    public void storeProperties(InputStream sourcePropertiesInputStream, String destPropertiesFilePath) throws IOException {
        if (this.loadedFromInputStream && sourcePropertiesInputStream == null) {
            throw new UnsupportedOperationException("If loaded from an input stream, it must be provided when storing the file");
        }
        ArrayList<String> outputLineList = new ArrayList<String>();
        File propertiesFileObject = new File(destPropertiesFilePath);
        File propertiesFileFolder = propertiesFileObject.getParentFile();
        if (!propertiesFileFolder.exists()) {
            propertiesFileFolder.mkdirs();
            propertiesFileFolder = null;
        }
        if (this.loadedFromInputStream) {
            for (Map.Entry<String, PropertyLayout> propertyLayoutEntry : this.propertyLayouts.entrySet()) {
                PropertyLayout value = propertyLayoutEntry.getValue();
                for (String comment : value.getComments()) {
                    outputLineList.add(this.replaceTabsWithSpaces(comment));
                }
                int i2 = 0;
                List<String> valueLines = value.getValueLines();
                int size = valueLines.size();
                if (size == 0) {
                    outputLineList.add(value.getNameLine());
                }
                for (String valueLine : valueLines) {
                    StringBuilder lineBuilder = new StringBuilder();
                    if (this.unmodifiedCommentingActivated && !this.modifiedProperties.contains(propertyLayoutEntry.getKey())) {
                        lineBuilder.append("#");
                    }
                    if (i2 == 0) {
                        lineBuilder.append(this.escapeNonASCII(value.getNameLine(), true));
                        lineBuilder.append(value.getSeparator());
                    }
                    lineBuilder.append(this.escapeNonASCII(i2 == 0 ? this.sanitizeValue(valueLine) : valueLine, false));
                    if (size > 1 && i2 < size - 1) {
                        lineBuilder.append("\\");
                    }
                    outputLineList.add(this.replaceTabsWithSpaces(lineBuilder.toString()));
                    ++i2;
                }
            }
            this.writeTheFile(destPropertiesFilePath, outputLineList);
        } else {
            FileOutputStream outputStream = new FileOutputStream(destPropertiesFilePath);
            this.getPropertiesObject().store(outputStream, "This file has been written by Jahia.");
            outputStream.close();
        }
    }

    public void outputProperty(List<String> outputLineList, String currentLine, Set<String> remainingPropertyNames, String currentPropertyName, int equalPosition) {
        if (remainingPropertyNames.contains(currentPropertyName)) {
            Object propValue = this.properties.get(currentPropertyName);
            remainingPropertyNames.remove(currentPropertyName);
            StringBuilder lineBuilder = new StringBuilder();
            if (this.modifiedProperties.contains(currentPropertyName)) {
                lineBuilder.append(this.escapeNonASCII(currentLine.substring(0, equalPosition + 1), true));
                lineBuilder.append(" ");
                lineBuilder.append(this.escapeValue(currentPropertyName, propValue));
            } else if (this.unmodifiedCommentingActivated) {
                lineBuilder.append("#");
                lineBuilder.append(this.escapeNonASCII(currentLine.substring(0, equalPosition + 1), true));
                lineBuilder.append(" ");
                lineBuilder.append(this.escapeValue(currentPropertyName, propValue));
            } else {
                lineBuilder.append(currentLine);
            }
            outputLineList.add(lineBuilder.toString());
        } else if (this.removedPropertyNames.contains(currentPropertyName)) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTheFile(String propertiesFilePath, List<String> bufferList) {
        File thisFile = null;
        OutputStreamWriter fileWriter = null;
        StringBuffer outputBuffer = null;
        try {
            thisFile = new File(propertiesFilePath);
            fileWriter = new FileWriter(thisFile);
            outputBuffer = new StringBuffer();
            for (int i2 = 0; i2 < bufferList.size(); ++i2) {
                outputBuffer.append(bufferList.get(i2));
                outputBuffer.append("\n");
            }
            fileWriter.write(outputBuffer.toString());
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                fileWriter.close();
            }
            catch (IOException iOException) {}
            fileWriter = null;
            thisFile = null;
        }
    }

    public Properties getPropertiesObject() {
        Properties propertiesObject = new Properties();
        for (Map.Entry<String, Object> propertiesEntry : this.properties.entrySet()) {
            propertiesObject.put(propertiesEntry.getKey(), this.toString(propertiesEntry.getValue()));
        }
        return propertiesObject;
    }

    public boolean isUnmodifiedCommentingActivated() {
        return this.unmodifiedCommentingActivated;
    }

    public void setUnmodifiedCommentingActivated(boolean unmodifiedCommentingActivated) {
        this.unmodifiedCommentingActivated = unmodifiedCommentingActivated;
    }

    public String getAdditionalPropertiesMessage() {
        return this.additionalPropertiesMessage;
    }

    public void setAdditionalPropertiesMessage(String additionalPropertiesMessage) {
        this.additionalPropertiesMessage = additionalPropertiesMessage;
    }

    private String toString(Object propertyValue) {
        if (propertyValue == null) {
            return null;
        }
        if (propertyValue instanceof String) {
            return (String)propertyValue;
        }
        if (propertyValue instanceof Object[]) {
            Object[] propertyValues = (Object[])propertyValue;
            StringBuilder stringValues = new StringBuilder();
            int counter = 0;
            for (Object objectValue : propertyValues) {
                stringValues.append(objectValue.toString());
                if (counter < propertyValues.length - 1) {
                    stringValues.append(",");
                }
                ++counter;
            }
            return stringValues.toString();
        }
        return propertyValue.toString();
    }

    private String escapeValue(String propertyName, Object propertyValue) {
        if (propertyValue == null) {
            return null;
        }
        if (propertyValue instanceof String) {
            String theString = (String)propertyValue;
            if (theString == null || theString.length() == 0 || !theString.contains("\\")) {
                return this.escapeNonASCII(theString, false);
            }
            return this.escapeNonASCII(StringUtils.replace(theString, "\\", "\\\\"), false);
        }
        if (propertyValue instanceof Object[]) {
            StringBuilder valueString = new StringBuilder();
            Object[] objectValues = (Object[])propertyValue;
            ArrayList<String> stringValues = new ArrayList<String>();
            long totalValueLength = 0L;
            for (Object objectValue : objectValues) {
                String stringValue = objectValue.toString();
                totalValueLength += (long)stringValue.length();
                stringValues.add(stringValue);
            }
            boolean multiLineSplit = false;
            if (totalValueLength > 50L || this.propertyLayouts.get(propertyName) != null && this.propertyLayouts.get(propertyName).getValueLines().size() > 1) {
                multiLineSplit = true;
            }
            int counter = 0;
            for (String stringValue : stringValues) {
                valueString.append(stringValue);
                if (counter < stringValues.size() - 1) {
                    if (multiLineSplit) {
                        valueString.append(",\\\n    ");
                    } else {
                        valueString.append(",");
                    }
                }
                ++counter;
            }
            return this.escapeNonASCII(valueString.toString(), false);
        }
        return this.escapeNonASCII(propertyValue.toString(), false);
    }

    private String escapeNonASCII(String input, boolean encodeSeparators) {
        if (input == null || input.length() == 0 || input.trim().length() == 0) {
            return input;
        }
        StringBuilder output = new StringBuilder();
        block12: for (int i2 = 0; i2 < input.length(); ++i2) {
            char curChar = input.charAt(i2);
            if (curChar > '\u007f') {
                output.append("\\u");
                output.append(String.format("%04X", curChar));
                continue;
            }
            if (curChar < ' ') {
                switch (curChar) {
                    case '\b': {
                        output.append("\\b");
                        break;
                    }
                    case '\n': {
                        output.append("\\n");
                        break;
                    }
                    case '\t': {
                        output.append(curChar);
                        break;
                    }
                    case '\f': {
                        output.append("\\f");
                        break;
                    }
                    case '\r': {
                        output.append("\\r");
                        break;
                    }
                    default: {
                        output.append("\\u");
                        output.append(String.format("%04X", curChar));
                        break;
                    }
                }
                continue;
            }
            switch (curChar) {
                case '\"': {
                    output.append('\\');
                    output.append('\"');
                    continue block12;
                }
                case '\\': {
                    output.append('\\');
                    output.append('\\');
                    continue block12;
                }
                case ':': 
                case '=': {
                    if (encodeSeparators) {
                        output.append("\\");
                        output.append(curChar);
                        continue block12;
                    }
                    output.append(curChar);
                    continue block12;
                }
                default: {
                    output.append(curChar);
                }
            }
        }
        return output.toString();
    }

    private String unescapeNonASCII(String input) {
        if (input == null || input.length() == 0 || input.trim().length() == 0) {
            return input;
        }
        StringBuilder output = new StringBuilder();
        boolean processingSlash = false;
        boolean processingUnicode = false;
        StringBuilder unicodeCharacters = new StringBuilder(4);
        for (int i2 = 0; i2 < input.length(); ++i2) {
            char ch = input.charAt(i2);
            if (processingUnicode) {
                unicodeCharacters.append(ch);
                if (unicodeCharacters.length() != 4) continue;
                try {
                    int value = Integer.decode("0x" + unicodeCharacters.toString());
                    output.append((char)value);
                    unicodeCharacters = new StringBuilder(4);
                    processingUnicode = false;
                    processingSlash = false;
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException("Invalid unicode : " + unicodeCharacters + " in string : " + input, nfe);
                }
            }
            if (processingSlash) {
                processingSlash = false;
                switch (ch) {
                    case '\\': {
                        output.append('\\');
                        break;
                    }
                    case '\'': {
                        output.append('\'');
                        break;
                    }
                    case '\"': {
                        output.append('\"');
                        break;
                    }
                    case 'r': {
                        output.append('\r');
                        break;
                    }
                    case 'f': {
                        output.append('\f');
                        break;
                    }
                    case 't': {
                        output.append('\t');
                        break;
                    }
                    case 'n': {
                        output.append('\n');
                        break;
                    }
                    case 'b': {
                        output.append('\b');
                        break;
                    }
                    case 'u': {
                        processingUnicode = true;
                        break;
                    }
                    default: {
                        output.append(ch);
                        break;
                    }
                }
                continue;
            }
            if (ch == '\\') {
                processingSlash = true;
                continue;
            }
            output.append(ch);
        }
        if (processingSlash) {
            output.append('\\');
        }
        return output.toString();
    }

    private int getValueSeparatorPos(String input) {
        int position;
        if (input == null || input.length() == 0) {
            return -1;
        }
        int seperatorPos = this.getFirstSeperatorPos(input, "=");
        if (seperatorPos > -1) {
            return seperatorPos;
        }
        seperatorPos = this.getFirstSeperatorPos(input, ":");
        if (seperatorPos > -1) {
            return seperatorPos;
        }
        for (position = 0; Character.isWhitespace(input.charAt(position)) && input.charAt(position) != '\n' && input.charAt(position) != '\r' && position < input.length() - 1; ++position) {
        }
        if (position == input.length() - 1) {
            return -1;
        }
        while (!Character.isWhitespace(input.charAt(position)) && position < input.length() - 1) {
            ++position;
        }
        if (position == input.length() - 1) {
            return -1;
        }
        return position;
    }

    private int getFirstSeperatorPos(String input, String seperator) {
        int startPosition = 0;
        int seperatorPos = -1;
        while ((seperatorPos = input.indexOf(seperator, startPosition)) >= 0 && startPosition < input.length() - 1) {
            if (seperatorPos > 0 && input.charAt(seperatorPos - 1) == '\\') {
                startPosition = seperatorPos + 1;
                continue;
            }
            if (seperatorPos < 0) continue;
            return seperatorPos;
        }
        return -1;
    }

    public void setReplaceTabsWithSpaces(boolean replaceTabsWithSpaces) {
        this.replaceTabsWithSpaces = replaceTabsWithSpaces;
    }

    public boolean isReplaceTabsWithSpaces() {
        return this.replaceTabsWithSpaces;
    }

    private String replaceTabsWithSpaces(String source) {
        return source != null && this.isReplaceTabsWithSpaces() ? StringUtils.replace(source, "\t", "    ") : source;
    }

    public boolean isSanitizeValue() {
        return this.sanitizeValue;
    }

    public void setSanitizeValue(boolean sanitizeValue) {
        this.sanitizeValue = sanitizeValue;
    }

    private String sanitizeValue(String source) {
        return source != null && this.isSanitizeValue() ? ' ' + StringUtils.stripStart(source, null) : source;
    }

    public class PropertyLayout {
        List<String> comments = new ArrayList<String>();
        String name;
        String nameLine;
        String separator = "=";
        List<String> valueLines = new ArrayList<String>();

        public List<String> getComments() {
            return this.comments;
        }

        public void setComments(List<String> comments) {
            this.comments = comments;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            StringBuilder valueBuilder = new StringBuilder();
            for (String valueLine : this.valueLines) {
                valueBuilder.append(StringUtils.stripStart(PropertiesManager.this.unescapeNonASCII(valueLine), null));
            }
            return valueBuilder.toString();
        }

        public String getNameLine() {
            return this.nameLine;
        }

        public void setNameLine(String nameLine) {
            this.nameLine = nameLine;
        }

        public String getSeparator() {
            return this.separator;
        }

        public void setSeparator(String separator) {
            this.separator = separator;
        }

        public List<String> getValueLines() {
            return this.valueLines;
        }

        public void setValueLines(List<String> valueLines) {
            this.valueLines = valueLines;
        }
    }
}

