/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.codec;

import java.sql.SQLException;
import java.util.Calendar;
import org.mariadb.jdbc.Configuration;
import org.mariadb.jdbc.client.Column;
import org.mariadb.jdbc.codec.RowDecoder;
import org.mariadb.jdbc.plugin.Codec;
import org.mariadb.jdbc.plugin.codec.BooleanCodec;
import org.mariadb.jdbc.plugin.codec.ByteCodec;
import org.mariadb.jdbc.plugin.codec.DoubleCodec;
import org.mariadb.jdbc.plugin.codec.FloatCodec;
import org.mariadb.jdbc.plugin.codec.IntCodec;
import org.mariadb.jdbc.plugin.codec.LongCodec;
import org.mariadb.jdbc.plugin.codec.ShortCodec;
import org.mariadb.jdbc.plugin.codec.StringCodec;

public class BinaryRowDecoder
extends RowDecoder {
    private byte[] nullBitmap;

    public BinaryRowDecoder(int columnCount, Column[] columns, Configuration conf) {
        super(columnCount, columns, conf);
    }

    @Override
    public <T> T decode(Codec<T> codec, Calendar cal) throws SQLException {
        return codec.decodeBinary(this.readBuf, this.length, this.columns[this.index], cal);
    }

    @Override
    public String decodeString() throws SQLException {
        return StringCodec.INSTANCE.decodeBinary(this.readBuf, this.length, this.columns[this.index], null);
    }

    @Override
    public byte decodeByte() throws SQLException {
        return ByteCodec.INSTANCE.decodeBinaryByte(this.readBuf, this.length, this.columns[this.index]);
    }

    @Override
    public boolean decodeBoolean() throws SQLException {
        return BooleanCodec.INSTANCE.decodeBinaryBoolean(this.readBuf, this.length, this.columns[this.index]);
    }

    @Override
    public short decodeShort() throws SQLException {
        return ShortCodec.INSTANCE.decodeBinaryShort(this.readBuf, this.length, this.columns[this.index]);
    }

    @Override
    public int decodeInt() throws SQLException {
        return IntCodec.INSTANCE.decodeBinaryInt(this.readBuf, this.length, this.columns[this.index]);
    }

    @Override
    public long decodeLong() throws SQLException {
        return LongCodec.INSTANCE.decodeBinaryLong(this.readBuf, this.length, this.columns[this.index]);
    }

    @Override
    public float decodeFloat() throws SQLException {
        return FloatCodec.INSTANCE.decodeBinaryFloat(this.readBuf, this.length, this.columns[this.index]);
    }

    @Override
    public double decodeDouble() throws SQLException {
        return DoubleCodec.INSTANCE.decodeBinaryDouble(this.readBuf, this.length, this.columns[this.index]);
    }

    @Override
    public void setRow(byte[] buf) {
        if (buf != null) {
            this.nullBitmap = new byte[(this.columnCount + 9) / 8];
            for (int i2 = 0; i2 < this.nullBitmap.length; ++i2) {
                this.nullBitmap[i2] = buf[i2 + 1];
            }
            this.readBuf.buf(buf, buf.length, 1 + this.nullBitmap.length);
        } else {
            this.readBuf.buf(null, 0, 0);
        }
        this.index = -1;
    }

    @Override
    public boolean wasNull() {
        return (this.nullBitmap[(this.index + 2) / 8] & 1 << (this.index + 2) % 8) > 0;
    }

    @Override
    public void setPosition(int newIndex) {
        if (this.index >= newIndex) {
            this.index = 0;
            this.readBuf.pos(1 + (this.columnCount + 9) / 8);
        } else {
            ++this.index;
        }
        while (this.index < newIndex) {
            if ((this.nullBitmap[(this.index + 2) / 8] & 1 << (this.index + 2) % 8) == 0) {
                switch (this.columns[this.index].getType()) {
                    case BIGINT: 
                    case DOUBLE: {
                        this.readBuf.skip(8);
                        break;
                    }
                    case INTEGER: 
                    case MEDIUMINT: 
                    case FLOAT: {
                        this.readBuf.skip(4);
                        break;
                    }
                    case SMALLINT: 
                    case YEAR: {
                        this.readBuf.skip(2);
                        break;
                    }
                    case TINYINT: {
                        this.readBuf.skip(1);
                        break;
                    }
                    default: {
                        this.readBuf.skipLengthEncoded();
                    }
                }
            }
            ++this.index;
        }
        if (this.wasNull()) {
            this.length = -1;
            return;
        }
        switch (this.columns[this.index].getType()) {
            case BIGINT: 
            case DOUBLE: {
                this.length = 8;
                return;
            }
            case INTEGER: 
            case MEDIUMINT: 
            case FLOAT: {
                this.length = 4;
                return;
            }
            case SMALLINT: 
            case YEAR: {
                this.length = 2;
                return;
            }
            case TINYINT: {
                this.length = 1;
                return;
            }
        }
        short len = this.readBuf.readUnsignedByte();
        if (len < 251) {
            this.length = len;
            return;
        }
        switch (len) {
            case 252: {
                this.length = this.readBuf.readUnsignedShort();
                return;
            }
            case 253: {
                this.length = this.readBuf.readUnsignedMedium();
                return;
            }
            case 254: {
                this.length = (int)this.readBuf.readLong();
                return;
            }
        }
    }
}

