/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.message.client;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import org.mariadb.jdbc.ServerPreparedStatement;
import org.mariadb.jdbc.client.Context;
import org.mariadb.jdbc.client.socket.Writer;
import org.mariadb.jdbc.client.util.Parameters;
import org.mariadb.jdbc.codec.Parameter;
import org.mariadb.jdbc.export.Prepare;
import org.mariadb.jdbc.message.ClientMessage;
import org.mariadb.jdbc.message.client.LongDataPacket;
import org.mariadb.jdbc.message.client.RedoableWithPrepareClientMessage;
import org.mariadb.jdbc.message.server.PrepareResultPacket;
import org.mariadb.jdbc.plugin.codec.ByteArrayCodec;

public final class ExecutePacket
implements RedoableWithPrepareClientMessage {
    private Parameters parameters;
    private final String command;
    private final ServerPreparedStatement prep;
    private Prepare prepareResult;
    private InputStream localInfileInputStream;

    public ExecutePacket(Prepare prepareResult, Parameters parameters, String command, ServerPreparedStatement prep, InputStream localInfileInputStream) {
        this.parameters = parameters;
        this.prepareResult = prepareResult;
        this.command = command;
        this.prep = prep;
        this.localInfileInputStream = localInfileInputStream;
    }

    @Override
    public void saveParameters() {
        this.parameters = this.parameters.clone();
    }

    @Override
    public void ensureReplayable(Context context) throws IOException, SQLException {
        int parameterCount = this.parameters.size();
        for (int i2 = 0; i2 < parameterCount; ++i2) {
            org.mariadb.jdbc.client.util.Parameter p2 = this.parameters.get(i2);
            if (p2.isNull() || !p2.canEncodeLongData()) continue;
            this.parameters.set(i2, new Parameter<byte[]>(ByteArrayCodec.INSTANCE, p2.encodeData()));
        }
    }

    @Override
    public int encode(Writer writer, Context context, Prepare newPrepareResult) throws IOException, SQLException {
        int statementId = newPrepareResult != null && newPrepareResult.getStatementId() != -1 ? newPrepareResult.getStatementId() : (this.prepareResult != null ? this.prepareResult.getStatementId() : -1);
        int parameterCount = this.parameters.size();
        for (int i2 = 0; i2 < parameterCount; ++i2) {
            org.mariadb.jdbc.client.util.Parameter p2 = this.parameters.get(i2);
            if (p2.isNull() || !p2.canEncodeLongData()) continue;
            new LongDataPacket(statementId, p2, i2).encode(writer, context);
        }
        writer.initPacket();
        writer.writeByte(23);
        writer.writeInt(statementId);
        writer.writeByte(0);
        writer.writeInt(1);
        if (parameterCount > 0) {
            org.mariadb.jdbc.client.util.Parameter p3;
            int i3;
            int nullCount = (parameterCount + 7) / 8;
            byte[] nullBitsBuffer = new byte[nullCount];
            int initialPos = writer.pos();
            writer.pos(initialPos + nullCount);
            writer.writeByte(1);
            for (i3 = 0; i3 < parameterCount; ++i3) {
                p3 = this.parameters.get(i3);
                writer.writeByte(p3.getBinaryEncodeType());
                writer.writeByte(0);
                if (!p3.isNull()) continue;
                int n2 = i3 / 8;
                nullBitsBuffer[n2] = (byte)(nullBitsBuffer[n2] | 1 << i3 % 8);
            }
            writer.writeBytesAtPos(nullBitsBuffer, initialPos);
            for (i3 = 0; i3 < parameterCount; ++i3) {
                p3 = this.parameters.get(i3);
                if (p3.isNull() || p3.canEncodeLongData()) continue;
                p3.encodeBinary(writer);
            }
        }
        writer.flush();
        return 1;
    }

    @Override
    public boolean canSkipMeta() {
        return true;
    }

    @Override
    public int batchUpdateLength() {
        return 1;
    }

    @Override
    public String getCommand() {
        return this.command;
    }

    @Override
    public InputStream getLocalInfileInputStream() {
        return this.localInfileInputStream;
    }

    @Override
    public ServerPreparedStatement prep() {
        return this.prep;
    }

    @Override
    public boolean binaryProtocol() {
        return true;
    }

    @Override
    public String description() {
        return "EXECUTE " + this.command;
    }

    @Override
    public boolean validateLocalFileName(String fileName, Context context) {
        return ClientMessage.validateLocalFileName(this.command, this.parameters, fileName, context);
    }

    @Override
    public void setPrepareResult(PrepareResultPacket prepareResult) {
        this.prepareResult = prepareResult;
    }
}

