/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.message.client;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import org.mariadb.jdbc.client.Context;
import org.mariadb.jdbc.client.socket.Writer;
import org.mariadb.jdbc.client.util.Parameters;
import org.mariadb.jdbc.codec.Parameter;
import org.mariadb.jdbc.message.ClientMessage;
import org.mariadb.jdbc.message.client.RedoableClientMessage;
import org.mariadb.jdbc.plugin.codec.ByteArrayCodec;
import org.mariadb.jdbc.util.ClientParser;

public final class QueryWithParametersPacket
implements RedoableClientMessage {
    private final String preSqlCmd;
    private final ClientParser parser;
    private Parameters parameters;
    private InputStream localInfileInputStream;

    public QueryWithParametersPacket(String preSqlCmd, ClientParser parser, Parameters parameters, InputStream localInfileInputStream) {
        this.preSqlCmd = preSqlCmd;
        this.parser = parser;
        this.parameters = parameters;
        this.localInfileInputStream = localInfileInputStream;
    }

    @Override
    public void ensureReplayable(Context context) throws IOException, SQLException {
        int parameterCount = this.parameters.size();
        for (int i2 = 0; i2 < parameterCount; ++i2) {
            org.mariadb.jdbc.client.util.Parameter p2 = this.parameters.get(i2);
            if (p2.isNull() || !p2.canEncodeLongData()) continue;
            this.parameters.set(i2, new Parameter<byte[]>(ByteArrayCodec.INSTANCE, p2.encodeData()));
        }
    }

    @Override
    public void saveParameters() {
        this.parameters = this.parameters.clone();
    }

    @Override
    public int encode(Writer encoder, Context context) throws IOException, SQLException {
        encoder.initPacket();
        encoder.writeByte(3);
        if (this.preSqlCmd != null) {
            encoder.writeAscii(this.preSqlCmd);
        }
        if (this.parser.getParamPositions().size() == 0) {
            encoder.writeBytes(this.parser.getQuery());
        } else {
            int pos = 0;
            for (int i2 = 0; i2 < this.parser.getParamPositions().size(); ++i2) {
                int paramPos = this.parser.getParamPositions().get(i2);
                encoder.writeBytes(this.parser.getQuery(), pos, paramPos - pos);
                pos = paramPos + 1;
                this.parameters.get(i2).encodeText(encoder, context);
            }
            encoder.writeBytes(this.parser.getQuery(), pos, this.parser.getQuery().length - pos);
        }
        encoder.flush();
        return 1;
    }

    @Override
    public int batchUpdateLength() {
        return 1;
    }

    @Override
    public boolean validateLocalFileName(String fileName, Context context) {
        return ClientMessage.validateLocalFileName(this.parser.getSql(), this.parameters, fileName, context);
    }

    @Override
    public InputStream getLocalInfileInputStream() {
        return this.localInfileInputStream;
    }

    @Override
    public String description() {
        return this.parser.getSql();
    }
}

